/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.fest.assertions.Assertions;
import org.fest.assertions.IntAssert;
import org.fest.assertions.ObjectAssert;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.elasticsearch.ElasticsearchQueries;
import org.hibernate.search.elasticsearch.test.BachelorThesis;
import org.hibernate.search.elasticsearch.test.GolfCourse;
import org.hibernate.search.elasticsearch.test.GolfPlayer;
import org.hibernate.search.elasticsearch.test.Hole;
import org.hibernate.search.elasticsearch.test.MasterThesis;
import org.hibernate.search.elasticsearch.test.ResearchPaper;
import org.hibernate.search.elasticsearch.test.ScientificArticle;
import org.hibernate.search.elasticsearch.test.model.Address;
import org.hibernate.search.elasticsearch.test.model.Country;
import org.hibernate.search.elasticsearch.test.model.Owner;
import org.hibernate.search.elasticsearch.test.model.State;
import org.hibernate.search.elasticsearch.test.model.StateCandidate;
import org.hibernate.search.elasticsearch.test.model.Tower;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ElasticsearchIT
extends SearchTestBase {
    @Before
    public void setupTestData() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        ScientificArticle article1 = new ScientificArticle("ORM for dummies", "Object/relational mapping with Hibernate", "blah blah blah", 7);
        s.persist((Object)article1);
        ScientificArticle article2 = new ScientificArticle("Latest in ORM", "Object/relational mapping with Hibernate - The latest news", "blah blah blah", 8);
        s.persist((Object)article2);
        ScientificArticle article3 = new ScientificArticle("ORM for beginners", "Object/relational mapping with an unknown tool", "blah blah blah", 9);
        s.persist((Object)article3);
        ScientificArticle article4 = new ScientificArticle("High-performance ORM", "Tuning persistence with Hibernate", "blah blah blah", 10);
        s.persist((Object)article4);
        ScientificArticle article5 = new ScientificArticle("ORM modelling", "Modelling your domain model with Hibernate", "blah blah blah", 11);
        s.persist((Object)article5);
        ResearchPaper paper1 = new ResearchPaper("Very important research on Hibernate", "Latest research on Hibernate", "blah blah blah", 7);
        s.persist((Object)paper1);
        ResearchPaper paper2 = new ResearchPaper("Some research", "Important Hibernate research", "blah blah blah", 7);
        s.persist((Object)paper2);
        BachelorThesis bachelorThesis = new BachelorThesis("Latest findings", "blah blah blah");
        s.persist((Object)bachelorThesis);
        MasterThesis masterThesis = new MasterThesis("Great findings", "blah blah blah");
        s.persist((Object)masterThesis);
        Calendar dob = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
        dob.set(1958, 3, 7, 0, 0, 0);
        dob.set(14, 0);
        GolfPlayer hergesheimer = new GolfPlayer.Builder().firstName("Klaus").lastName("Hergesheimer").active(true).dateOfBirth(dob.getTime()).handicap(3.4).puttingStrength(2.5).driveWidth(285).ranking(311).strength("precision").strength("willingness").strength("stamina").build();
        s.persist((Object)hergesheimer);
        tx.commit();
        s.close();
    }

    @After
    public void deleteTestData() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        for (Object entity : result) {
            session.delete(entity);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testFields() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match' : { 'abstract' : 'Hibernate' } } }");
        List result = session.createFullTextQuery(query, new Class[]{ScientificArticle.class}).list();
        Assertions.assertThat((List)result).onProperty("title").containsOnly(new Object[]{"Latest in ORM", "ORM for dummies", "High-performance ORM", "ORM modelling"});
        tx.commit();
        s.close();
    }

    @Test
    public void testNumericFieldQuery() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'range' : { 'wordCount' : { 'gte' : 8, 'lt' : 10 } } } }");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        Assertions.assertThat((List)result).onProperty("title").containsOnly(new Object[]{"Latest in ORM", "ORM for beginners"});
        tx.commit();
        s.close();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2467")
    public void testDateFieldRangeQuery() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        NumericRangeQuery query = NumericRangeQuery.newLongRange((String)"dateOfBirth", (Long)-373078800000L, null, (boolean)true, (boolean)true);
        List result = session.createFullTextQuery((Query)query, new Class[]{GolfPlayer.class}).setSort(new Sort(new SortField("id", SortField.Type.STRING))).list();
        Assertions.assertThat((List)result).onProperty("firstName").containsOnly(new Object[]{"Klaus"});
        tx.commit();
        s.close();
    }

    @Test
    public void testEmbeddedIndexing() throws Exception {
        Tower tower = new Tower();
        tower.setName("JBoss tower");
        Address a = new Address();
        a.setStreet("Tower place");
        a.getTowers().add(tower);
        tower.setAddress(a);
        Owner o = new Owner();
        o.setName("Atlanta Renting corp");
        a.setOwnedBy(o);
        o.setAddress(a);
        Country c = new Country();
        c.setName("France");
        a.setCountry(c);
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        s.persist((Object)tower);
        tx.commit();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{'query' : { 'match' : { 'address.street' : 'place' } } }");
        List result = session.createFullTextQuery(query, new Class[]{Tower.class}).list();
        Assert.assertEquals((String)"unable to find property in embedded", (long)1L, (long)result.size());
        query = ElasticsearchQueries.fromJson((String)"{'query' : { 'match' : { 'address.ownedBy.name' : 'renting' } } }");
        result = session.createFullTextQuery(query, new Class[]{Tower.class}).list();
        Assert.assertEquals((String)"unable to find property in embedded", (long)1L, (long)result.size());
        query = ElasticsearchQueries.fromJson((String)("{'query' : { 'match' : { 'address.id' : " + a.getId() + " } } }"));
        result = session.createFullTextQuery(query, new Class[]{Tower.class}).list();
        Assert.assertEquals((String)"unable to find property by id of embedded", (long)1L, (long)result.size());
        query = ElasticsearchQueries.fromJson((String)"{'query' : { 'match' : { 'address.country.name' : 'France' } } }");
        result = session.createFullTextQuery(query, new Class[]{Tower.class}).list();
        Assert.assertEquals((String)"unable to find property with 2 levels of embedded", (long)1L, (long)result.size());
        s.clear();
        tx = s.beginTransaction();
        Address address = (Address)s.get(Address.class, (Serializable)a.getId());
        address.getOwnedBy().setName("Buckhead community");
        tx.commit();
        s.clear();
        session = Search.getFullTextSession((Session)s);
        query = ElasticsearchQueries.fromJson((String)"{'query' : { 'match' : { 'address.ownedBy.name' : 'buckhead' } } }");
        result = session.createFullTextQuery(query, new Class[]{Tower.class}).list();
        Assert.assertEquals((String)"change in embedded not reflected in root index", (long)1L, (long)result.size());
        s.clear();
        tx = s.beginTransaction();
        s.delete(s.get(Tower.class, (Serializable)tower.getId()));
        tx.commit();
        s.close();
    }

    @Test
    public void testEmbeddedIndexingOfElementCollection() throws Exception {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        FullTextSession session = Search.getFullTextSession((Session)s);
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{'query' : { 'match' : { 'strengths' : 'willingness' } } }");
        List result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).list();
        Assert.assertEquals((String)"unable to find property in embedded element collection", (long)1L, (long)result.size());
        tx.commit();
        s.close();
    }

    @Test
    public void testIndexSharing() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match' : { 'title' : 'findings' } } }");
        List result = session.createFullTextQuery(query, new Class[]{MasterThesis.class, BachelorThesis.class}).list();
        Assertions.assertThat((List)result).onProperty("title").containsOnly(new Object[]{"Great findings", "Latest findings"});
        tx.commit();
        s.close();
    }

    @Test
    public void testRestrictionByType() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match' : { 'abstract' : 'Hibernate' } } }");
        List result = session.createFullTextQuery(query, new Class[]{ResearchPaper.class}).list();
        Assertions.assertThat((List)result).onProperty("title").containsOnly(new Object[]{"Very important research on Hibernate", "Some research"});
        tx.commit();
        s.close();
    }

    @Test
    public void testFirstResultAndMaxResults() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match' : { 'abstract' : 'Hibernate' } } }");
        List result = session.createFullTextQuery(query, new Class[]{ScientificArticle.class}).setFirstResult(1).setMaxResults(2).setSort(new Sort(new SortField("id", SortField.Type.STRING, false))).list();
        Assertions.assertThat((List)result).onProperty("title").containsOnly(new Object[]{"Latest in ORM", "High-performance ORM"});
        tx.commit();
        s.close();
    }

    @Test
    public void testGetResultSize() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match' : { 'abstract' : 'Hibernate' } } }");
        FullTextQuery fullTextQuery = session.createFullTextQuery(query, new Class[]{ScientificArticle.class});
        Assertions.assertThat((int)fullTextQuery.getResultSize()).isEqualTo(4);
        tx.commit();
        s.close();
    }

    @Test
    public void testScroll() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match' : { 'abstract' : 'Hibernate' } } }");
        FullTextQuery fullTextQuery = session.createFullTextQuery(query, new Class[]{ScientificArticle.class}).setSort(new Sort(new SortField("id", SortField.Type.STRING, false)));
        ScrollableResults scrollableResults = fullTextQuery.scroll();
        Assert.assertEquals((long)-1L, (long)scrollableResults.getRowNumber());
        Assert.assertTrue((boolean)scrollableResults.last());
        Assert.assertEquals((long)3L, (long)scrollableResults.getRowNumber());
        scrollableResults.beforeFirst();
        ArrayList<ScientificArticle> articles = new ArrayList<ScientificArticle>();
        while (scrollableResults.next()) {
            articles.add((ScientificArticle)scrollableResults.get()[0]);
        }
        scrollableResults.close();
        Assertions.assertThat(articles).onProperty("title").containsExactly(new Object[]{"ORM for dummies", "Latest in ORM", "High-performance ORM", "ORM modelling"});
        fullTextQuery = session.createFullTextQuery(query, new Class[]{ScientificArticle.class}).setSort(new Sort(new SortField("id", SortField.Type.STRING, false)));
        scrollableResults = fullTextQuery.setFirstResult(1).setMaxResults(2).scroll();
        Assert.assertEquals((long)-1L, (long)scrollableResults.getRowNumber());
        Assert.assertTrue((boolean)scrollableResults.last());
        Assert.assertEquals((long)1L, (long)scrollableResults.getRowNumber());
        scrollableResults.beforeFirst();
        articles = new ArrayList();
        while (scrollableResults.next()) {
            articles.add((ScientificArticle)scrollableResults.get()[0]);
        }
        scrollableResults.close();
        Assertions.assertThat(articles).onProperty("title").containsExactly(new Object[]{"Latest in ORM", "High-performance ORM"});
        tx.commit();
        s.close();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2253")
    public void testSort() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match' : { 'abstract' : 'Hibernate' } } }");
        List result = session.createFullTextQuery(query, new Class[]{ScientificArticle.class}).setSort(new Sort(new SortField("title", SortField.Type.STRING, false))).list();
        Assertions.assertThat((List)result).onProperty("title").containsExactly(new Object[]{"High-performance ORM", "Latest in ORM", "ORM for dummies", "ORM modelling"});
        result = session.createFullTextQuery(query, new Class[]{ScientificArticle.class}).setSort(new Sort(new SortField("id", SortField.Type.STRING, true))).list();
        Assertions.assertThat((List)result).onProperty("id").containsExactly(new Object[]{5L, 4L, 2L, 1L});
        tx.commit();
        s.close();
    }

    @Test
    public void testFieldBoost() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{'query': {'bool' : {'should' : [{ 'match' : { 'abstract' : 'important' } },{ 'match' : { 'title' : 'important' } }]}}}");
        List result = session.createFullTextQuery(query, new Class[]{ResearchPaper.class}).list();
        Assertions.assertThat((List)result).onProperty("title").containsExactly(new Object[]{"Very important research on Hibernate", "Some research"});
        tx.commit();
        s.close();
    }

    @Test
    public void testQueryStringQuery() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromQueryString((String)"abstract:Hibernate");
        List result = session.createFullTextQuery(query, new Class[]{ScientificArticle.class}).list();
        Assertions.assertThat((List)result).onProperty("title").containsOnly(new Object[]{"Latest in ORM", "ORM for dummies", "High-performance ORM", "ORM modelling"});
        query = ElasticsearchQueries.fromQueryString((String)"abstract:important OR title:important");
        result = session.createFullTextQuery(query, new Class[]{ResearchPaper.class}).list();
        Assertions.assertThat((List)result).onProperty("title").containsExactly(new Object[]{"Very important research on Hibernate", "Some research"});
        query = ElasticsearchQueries.fromQueryString((String)"wordCount:[8 TO 10}");
        result = session.createFullTextQuery(query, new Class[]{ScientificArticle.class}).list();
        Assertions.assertThat((List)result).onProperty("title").containsOnly(new Object[]{"Latest in ORM", "ORM for beginners"});
        tx.commit();
        s.close();
    }

    @Test
    public void testProjection() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromQueryString((String)"lastName:Hergesheimer");
        List result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).setProjection(new String[]{"__HSearch_id", "_hibernate_class", "__HSearch_Score", "__HSearch_This", "firstName", "lastName", "active", "dateOfBirth", "handicap", "driveWidth", "ranking.value", "__HSearch_Took", "__HSearch_TimedOut"}).list();
        Assertions.assertThat((List)result).hasSize(1);
        Calendar dob = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
        dob.set(1958, 3, 7, 0, 0, 0);
        dob.set(14, 0);
        Object[] projection = (Object[])result.iterator().next();
        ((ObjectAssert)Assertions.assertThat((Object)projection[0]).describedAs("id")).isEqualTo((Object)1L);
        ((ObjectAssert)Assertions.assertThat((Object)projection[1]).describedAs("object class")).isEqualTo(GolfPlayer.class);
        ((ObjectAssert)Assertions.assertThat((Object)projection[2]).describedAs("score")).isEqualTo((Object)Float.valueOf(0.30685282f));
        ((ObjectAssert)Assertions.assertThat((Object)projection[3]).describedAs("this")).isInstanceOf(GolfPlayer.class);
        Assertions.assertThat((Long)((GolfPlayer)projection[3]).getId()).isEqualTo(1L);
        ((ObjectAssert)Assertions.assertThat((Object)projection[4]).describedAs("firstName")).isEqualTo((Object)"Klaus");
        ((ObjectAssert)Assertions.assertThat((Object)projection[5]).describedAs("lastName")).isEqualTo((Object)"Hergesheimer");
        ((ObjectAssert)Assertions.assertThat((Object)projection[6]).describedAs("active")).isEqualTo((Object)true);
        ((ObjectAssert)Assertions.assertThat((Object)projection[7]).describedAs("dateOfBirth")).isEqualTo((Object)dob.getTime());
        ((ObjectAssert)Assertions.assertThat((Object)projection[8]).describedAs("handicap")).isEqualTo((Object)3.4);
        ((ObjectAssert)Assertions.assertThat((Object)projection[9]).describedAs("driveWidth")).isEqualTo((Object)285);
        ((ObjectAssert)Assertions.assertThat((Object)projection[10]).describedAs("ranking value")).isEqualTo((Object)BigInteger.valueOf(311L));
        ((ObjectAssert)Assertions.assertThat((Object)projection[11]).describedAs("took")).isInstanceOf(Integer.class);
        ((IntAssert)Assertions.assertThat((Integer)((Integer)projection[11])).describedAs("took")).isGreaterThanOrEqualTo(0);
        ((ObjectAssert)Assertions.assertThat((Object)projection[12]).describedAs("timeout")).isEqualTo((Object)Boolean.FALSE);
        tx.commit();
        s.close();
    }

    @Test
    public void testQueryById() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{'query': {'ids' : {'values' : ['1', '3']}}}");
        List result = session.createFullTextQuery(query, new Class[]{ScientificArticle.class}).list();
        Assertions.assertThat((List)result).onProperty("title").containsOnly(new Object[]{"ORM for dummies", "ORM for beginners"});
        query = ElasticsearchQueries.fromQueryString((String)"_id:1 OR _id:3");
        result = session.createFullTextQuery(query, new Class[]{ScientificArticle.class}).list();
        Assertions.assertThat((List)result).onProperty("title").containsOnly(new Object[]{"ORM for dummies", "ORM for beginners"});
        tx.commit();
        s.close();
    }

    @Test
    public void testStringMappedNumericProperty() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match' : { 'puttingStrength' : '2.5' } } }");
        List result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).setProjection(new String[]{"__HSearch_id", "puttingStrength"}).list();
        Assertions.assertThat((List)result).hasSize(1);
        Object[] projection = (Object[])result.iterator().next();
        Assertions.assertThat((Object)projection[0]).isEqualTo((Object)1L);
        Assertions.assertThat((Object)projection[1]).isEqualTo((Object)2.5);
        tx.commit();
        s.close();
    }

    @Test
    public void testBooleanProperty() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'term' : { 'active' : 'true' } } }");
        List result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).setProjection(new String[]{"__HSearch_id"}).list();
        Assertions.assertThat((List)result).hasSize(1);
        Object[] projection = (Object[])result.iterator().next();
        Assertions.assertThat((Object)projection[0]).isEqualTo((Object)1L);
        tx.commit();
        s.close();
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{ScientificArticle.class, Tower.class, Address.class, Country.class, State.class, StateCandidate.class, ResearchPaper.class, BachelorThesis.class, MasterThesis.class, GolfPlayer.class, GolfCourse.class, Hole.class};
    }
}

