/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test.deletebyquery;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.DeleteByQueryWork;
import org.hibernate.search.backend.spi.DeletionQuery;
import org.hibernate.search.backend.spi.SingularTermDeletionQuery;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.elasticsearch.ElasticsearchQueries;
import org.hibernate.search.elasticsearch.test.deletebyquery.HockeyPlayer;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DeleteByQueryMultiTenancyIT
extends SearchTestBase {
    private static final String EXTRA_TERRESTRIAL = "Extraterrestrial";
    private static final String DOWN_TO_THE_EARTH = "DownToTheEarth";

    @Before
    public void setupTestData() {
        Session s = this.getSessionFactory().withOptions().tenantIdentifier(DOWN_TO_THE_EARTH).openSession();
        Transaction tx = s.beginTransaction();
        HockeyPlayer hergesheimer = new HockeyPlayer();
        hergesheimer.name = "Hergesheimer";
        hergesheimer.active = true;
        s.persist((Object)hergesheimer);
        HockeyPlayer galore = new HockeyPlayer();
        galore.name = "Galore";
        galore.active = false;
        s.persist((Object)galore);
        HockeyPlayer kidd = new HockeyPlayer();
        kidd.name = "Kidd";
        kidd.active = false;
        s.persist((Object)kidd);
        HockeyPlayer brand = new HockeyPlayer();
        brand.name = "Brand";
        brand.active = true;
        s.persist((Object)brand);
        tx.commit();
        s.close();
        s = this.getSessionFactory().withOptions().tenantIdentifier(EXTRA_TERRESTRIAL).openSession();
        tx = s.beginTransaction();
        HockeyPlayer metz = new HockeyPlayer();
        metz.name = "Metz";
        metz.active = false;
        s.persist((Object)metz);
        HockeyPlayer plenty = new HockeyPlayer();
        plenty.name = "Plenty";
        plenty.active = true;
        s.persist((Object)plenty);
        tx.commit();
        s.close();
    }

    @After
    public void deleteTestData() {
        for (String tenantId : this.multiTenantIds()) {
            Session s = this.getSessionFactory().withOptions().tenantIdentifier(tenantId).openSession();
            FullTextSession session = Search.getFullTextSession((Session)s);
            Transaction tx = s.beginTransaction();
            QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
            List result = session.createFullTextQuery(query, new Class[0]).list();
            for (Object entity : result) {
                session.delete(entity);
            }
            tx.commit();
            s.close();
        }
    }

    @Test
    public void deleteByQueryOnlyAffectsEntitiesOfCurrentTenant() throws Exception {
        Session s = this.getSessionFactory().withOptions().tenantIdentifier(DOWN_TO_THE_EARTH).openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        ExtendedSearchIntegrator integrator = (ExtendedSearchIntegrator)session.getSearchFactory().unwrap(ExtendedSearchIntegrator.class);
        DeleteByQueryWork queryWork = new DeleteByQueryWork(DOWN_TO_THE_EARTH, HockeyPlayer.class, (DeletionQuery)new SingularTermDeletionQuery("active", "false"));
        TransactionContextForTest tc = new TransactionContextForTest();
        integrator.getWorker().performWork((Work)queryWork, (TransactionContext)tc);
        integrator.getWorker().flushWorks((TransactionContext)tc);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
        List result = session.createFullTextQuery(query, new Class[]{HockeyPlayer.class}).list();
        Assertions.assertThat((List)result).onProperty("name").containsOnly(new Object[]{"Hergesheimer", "Brand"});
        tx.commit();
        s.close();
        s = this.getSessionFactory().withOptions().tenantIdentifier(EXTRA_TERRESTRIAL).openSession();
        session = Search.getFullTextSession((Session)s);
        tx = s.beginTransaction();
        query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
        result = session.createFullTextQuery(query, new Class[]{HockeyPlayer.class}).list();
        ((ListAssert)Assertions.assertThat((List)result).describedAs("Running delete-by-query for other tenant should not affect entities of this entity")).onProperty("name").containsOnly(new Object[]{"Metz", "Plenty"});
        tx.commit();
        s.close();
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{HockeyPlayer.class};
    }

    public Set<String> multiTenantIds() {
        return new HashSet<String>(Arrays.asList(EXTRA_TERRESTRIAL, DOWN_TO_THE_EARTH));
    }
}

