/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl;

import java.util.Map;
import java.util.Properties;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaCreator;
import org.hibernate.search.elasticsearch.schema.impl.ExecutionOptions;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexMetadata;
import org.hibernate.search.elasticsearch.schema.impl.model.TypeMapping;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.Startable;
import org.hibernate.search.engine.service.spi.Stoppable;
import org.hibernate.search.spi.BuildContext;

public class DefaultElasticsearchSchemaCreator
implements ElasticsearchSchemaCreator,
Startable,
Stoppable {
    private ServiceManager serviceManager;
    private ElasticsearchSchemaAccessor schemaAccessor;

    public void start(Properties properties, BuildContext context) {
        this.serviceManager = context.getServiceManager();
        this.schemaAccessor = (ElasticsearchSchemaAccessor)this.serviceManager.requestService(ElasticsearchSchemaAccessor.class);
    }

    public void stop() {
        this.schemaAccessor = null;
        this.serviceManager.releaseService(ElasticsearchSchemaAccessor.class);
        this.serviceManager = null;
    }

    @Override
    public void createIndex(IndexMetadata indexMetadata, ExecutionOptions executionOptions) {
        String indexName = indexMetadata.getName();
        this.schemaAccessor.createIndex(indexName, executionOptions);
        this.schemaAccessor.waitForIndexStatus(indexName, executionOptions);
        for (Map.Entry<String, TypeMapping> entry : indexMetadata.getMappings().entrySet()) {
            String mappingName = entry.getKey();
            TypeMapping mapping = entry.getValue();
            this.schemaAccessor.putMapping(indexName, mappingName, mapping);
        }
    }

    @Override
    public boolean createIndexIfAbsent(IndexMetadata indexMetadata, ExecutionOptions executionOptions) {
        String indexName = indexMetadata.getName();
        boolean created = false;
        if (!this.schemaAccessor.indexExists(indexName) && (created = this.schemaAccessor.createIndexIfAbsent(indexName, executionOptions))) {
            this.schemaAccessor.waitForIndexStatus(indexName, executionOptions);
        }
        return created;
    }

    @Override
    public void createMappings(IndexMetadata indexMetadata, ExecutionOptions executionOptions) {
        String indexName = indexMetadata.getName();
        for (Map.Entry<String, TypeMapping> entry : indexMetadata.getMappings().entrySet()) {
            String mappingName = entry.getKey();
            TypeMapping mapping = entry.getValue();
            this.schemaAccessor.putMapping(indexName, mappingName, mapping);
        }
    }
}

