/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.HashMap;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.document.Document;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.MetadataProvidingFieldBridge;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.TestConfiguration;
import org.hibernate.search.test.util.impl.ExceptionMatcherBuilder;
import org.hibernate.testing.TestForIssue;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ElasticsearchSchemaNamingErrorsIT
extends SearchInitializationTestBase {
    private static final String COMPOSITE_CONCRETE_CONFLICT_MESSAGE_ID = "HSEARCH400036";
    private static final String INDEXED_EMBEDDED_BYPASS_MESSAGE_ID = "HSEARCH400054";
    private static final String CONFLICTING_FIELD_NAME = "conflictingFieldName";
    private static final String BYPASSING_FIELD_NAME = "fieldNameThatBypassesIndexedEmbeddedPrefix";
    private static final String BYPASSING_FIELD_INDEXED_EMBEDDED_PREFIX = "indexedEmbeddedPrefix.";
    private static final String BYPASSING_FIELD_DEFAULT_FIELD_NAME = "defaultFieldName";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TestElasticsearchClient elasticSearchClient = new TestElasticsearchClient();
    private IndexSchemaManagementStrategy strategy;

    @Parameterized.Parameters(name="With strategy {0}")
    public static IndexSchemaManagementStrategy[] strategies() {
        return IndexSchemaManagementStrategy.values();
    }

    public ElasticsearchSchemaNamingErrorsIT(IndexSchemaManagementStrategy strategy) {
        this.strategy = strategy;
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2448")
    public void detectConflict_schemaGeneration_compositeOnConcrete() throws Exception {
        this.testDetectConflictDuringSchemaGeneration(CompositeOnConcreteEntity.class);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2448")
    public void detectConflict_schemaGeneration_concreteOnComposite() throws Exception {
        this.testDetectConflictDuringSchemaGeneration(ConcreteOnCompositeEntity.class);
    }

    private void testDetectConflictDuringSchemaGeneration(Class<?> entityClass) {
        Assume.assumeTrue((String)("The strategy " + this.strategy + " does not involve schema generation. No point running this test."), (boolean)this.generatesSchema(this.strategy));
        this.thrown.expect(ExceptionMatcherBuilder.isException(SearchException.class).withMessage(COMPOSITE_CONCRETE_CONFLICT_MESSAGE_ID).withMessage("conflictingFieldName'").withMessage(entityClass.getName()).build());
        this.elasticSearchClient.index(entityClass).registerForCleanup();
        this.init(this.strategy, entityClass);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2448")
    public void detectConflict_indexing_compositeOnConcrete() throws Exception {
        this.testDetectConflictDuringIndexing(CompositeOnConcreteEntity.class);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2448")
    public void detectConflict_indexing_concreteOnComposite() throws Exception {
        this.testDetectConflictDuringIndexing(ConcreteOnCompositeEntity.class);
    }

    private void testDetectConflictDuringIndexing(Class<?> entityClass) throws Exception {
        Assume.assumeFalse((String)("The strategy " + this.strategy + " involves schema generation, which means conflicts prevent search factory initialization and thus prevent indexing. No point running this test."), (boolean)this.generatesSchema(this.strategy));
        this.elasticSearchClient.index(entityClass).deleteAndCreate();
        this.init(this.strategy, entityClass);
        this.thrown.expect(ExceptionMatcherBuilder.isException(AssertionFailure.class).causedBy(HibernateException.class).causedBy(SearchException.class).withMessage(COMPOSITE_CONCRETE_CONFLICT_MESSAGE_ID).withMessage("conflictingFieldName'").withMessage(entityClass.getName()).build());
        Object newEntity = entityClass.newInstance();
        try (Session session = this.getTestResourceManager().openSession();){
            Transaction tx = session.beginTransaction();
            session.save(newEntity);
            tx.commit();
        }
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2488")
    public void detectIndexedEmbeddedPrefixBypass_schemaGeneration() {
        Assume.assumeTrue((String)("The strategy " + this.strategy + " does not involve schema generation. No point running this test."), (boolean)this.generatesSchema(this.strategy));
        Class<BypassingIndexedEmbeddedPrefixEntity> entityClass = BypassingIndexedEmbeddedPrefixEntity.class;
        this.thrown.expect(ExceptionMatcherBuilder.isException(SearchException.class).withMessage(INDEXED_EMBEDDED_BYPASS_MESSAGE_ID).withMessage("'fieldNameThatBypassesIndexedEmbeddedPrefix'").withMessage("'indexedEmbeddedPrefix.'").withMessage(entityClass.getName()).build());
        this.elasticSearchClient.index(entityClass).registerForCleanup();
        this.init(this.strategy, entityClass);
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2488")
    public void detectIndexedEmbeddedPrefixBypass_indexing() throws Exception {
        Assume.assumeFalse((String)("The strategy " + this.strategy + " involves schema generation, which means @IndexedEmbedded.prefix bypasses prevent search factory initialization and thus prevent indexing. No point running this test."), (boolean)this.generatesSchema(this.strategy));
        Class<BypassingIndexedEmbeddedPrefixEntity> entityClass = BypassingIndexedEmbeddedPrefixEntity.class;
        this.elasticSearchClient.index(entityClass).deleteAndCreate();
        this.init(this.strategy, entityClass);
        this.thrown.expect(ExceptionMatcherBuilder.isException(AssertionFailure.class).causedBy(HibernateException.class).causedBy(SearchException.class).withMessage(INDEXED_EMBEDDED_BYPASS_MESSAGE_ID).withMessage("'fieldNameThatBypassesIndexedEmbeddedPrefix'").withMessage("'indexedEmbeddedPrefix.'").withMessage(entityClass.getName()).build());
        Object newEntity = entityClass.newInstance();
        try (Session session = this.getTestResourceManager().openSession();){
            Transaction tx = session.beginTransaction();
            session.save(newEntity);
            tx.commit();
        }
    }

    private boolean generatesSchema(IndexSchemaManagementStrategy strategy) {
        return !IndexSchemaManagementStrategy.NONE.equals((Object)strategy);
    }

    private void init(IndexSchemaManagementStrategy strategy, Class<?> ... entityClasses) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("hibernate.search.default.elasticsearch.index_schema_management_strategy", strategy.name());
        this.init((TestConfiguration)new ImmutableTestConfiguration(settings, (Class[])entityClasses));
    }

    public static class BypassingIndexedEmbeddedPrefixFieldBridge
    implements MetadataProvidingFieldBridge {
        public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
            builder.field(ElasticsearchSchemaNamingErrorsIT.BYPASSING_FIELD_NAME, FieldType.STRING);
        }

        public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
            luceneOptions.addFieldToDocument(ElasticsearchSchemaNamingErrorsIT.BYPASSING_FIELD_NAME, (String)value, document);
        }
    }

    @Embeddable
    static class BypassingIndexedEmbeddedPrefixEmbedded {
        @Field(name="defaultFieldName", bridge=@FieldBridge(impl=BypassingIndexedEmbeddedPrefixFieldBridge.class))
        private String field = "fieldValue";

        BypassingIndexedEmbeddedPrefixEmbedded() {
        }
    }

    @Indexed
    @Entity
    static class BypassingIndexedEmbeddedPrefixEntity {
        @Id
        @GeneratedValue
        private Integer id;
        @IndexedEmbedded(prefix="indexedEmbeddedPrefix.")
        private BypassingIndexedEmbeddedPrefixEmbedded embedded = new BypassingIndexedEmbeddedPrefixEmbedded();

        BypassingIndexedEmbeddedPrefixEntity() {
        }
    }

    @Entity
    @Indexed
    static class ConcreteOnCompositeEntity {
        @DocumentId
        @Id
        @GeneratedValue
        Long id;
        @Embedded
        EmbeddedTypeWithNonConflictingField embedded = new EmbeddedTypeWithNonConflictingField();
        @IndexedEmbedded(prefix="")
        @Embedded
        EmbeddedTypeWithConflictingField otherEmbedded = new EmbeddedTypeWithConflictingField();

        ConcreteOnCompositeEntity() {
        }

        @IndexedEmbedded(prefix="conflictingFieldName.")
        public EmbeddedTypeWithNonConflictingField getEmbedded() {
            return this.embedded;
        }
    }

    @Entity
    @Indexed
    static class CompositeOnConcreteEntity {
        @DocumentId
        @Id
        @GeneratedValue
        Long id;
        @IndexedEmbedded(prefix="conflictingFieldName.")
        @Field(name="conflictingFieldName", bridge=@FieldBridge(impl=SimpleToStringBridge.class))
        @Embedded
        EmbeddedTypeWithNonConflictingField embedded = new EmbeddedTypeWithNonConflictingField();

        CompositeOnConcreteEntity() {
        }

        public static class SimpleToStringBridge
        implements MetadataProvidingFieldBridge {
            public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
                luceneOptions.addFieldToDocument(name, String.valueOf(value), document);
            }

            public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
                builder.field(name, FieldType.STRING);
            }
        }
    }

    @Embeddable
    static class EmbeddedTypeWithConflictingField {
        @Field(name="conflictingFieldName")
        int conflictingField = 0;

        EmbeddedTypeWithConflictingField() {
        }
    }

    @Embeddable
    static class EmbeddedTypeWithNonConflictingField {
        @Field
        int nonConflictingField = 0;

        EmbeddedTypeWithNonConflictingField() {
        }
    }
}

