/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilterFactory;
import org.apache.lucene.analysis.cjk.CJKBigramFilterFactory;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.apache.lucene.analysis.no.NorwegianLightStemFilterFactory;
import org.apache.lucene.analysis.pattern.PatternCaptureGroupFilterFactory;
import org.apache.lucene.analysis.pattern.PatternReplaceFilterFactory;
import org.apache.lucene.analysis.standard.StandardFilterFactory;
import org.apache.lucene.analysis.standard.StandardTokenizerFactory;
import org.apache.lucene.analysis.synonym.SynonymFilterFactory;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.fest.assertions.Assertions;
import org.fest.assertions.CollectionAssert;
import org.fest.assertions.MapAssert;
import org.fest.assertions.StringAssert;
import org.hibernate.annotations.common.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotations.common.annotationfactory.AnnotationFactory;
import org.hibernate.search.annotations.CharFilterDef;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.elasticsearch.analyzer.ElasticsearchTokenFilterFactory;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.settings.impl.model.CharFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenizerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.translation.DefaultElasticsearchAnalyzerDefinitionTranslator;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class DefaultElasticsearchAnalyzerDefinitionTranslatorTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private DefaultElasticsearchAnalyzerDefinitionTranslator translator = new DefaultElasticsearchAnalyzerDefinitionTranslator();

    @Before
    public void setup() {
        this.translator.start(null, (BuildContext)new BuildContextForTest((SearchConfiguration)new SearchConfigurationForTest()));
    }

    @After
    public void tearDown() {
        this.translator.stop();
    }

    @Test
    public void unknownClass() {
        TokenizerDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenizerDef.class, CustomTokenizerFactory.class, new Parameter[0]);
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400059");
        this.thrown.expectMessage(CustomTokenizerFactory.class.getSimpleName());
        this.translator.translate(annotation);
    }

    @Test
    public void translateType() {
        TokenFilterDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenFilterDef.class, StandardFilterFactory.class, new Parameter[0]);
        TokenFilterDefinition definition = this.translator.translate(annotation);
        ((StringAssert)Assertions.assertThat((String)definition.getType()).as("type")).isEqualTo((Object)"standard");
    }

    @Test
    public void renameParameter() {
        TokenizerDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenizerDef.class, StandardTokenizerFactory.class, DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("maxTokenLength", "5"));
        TokenizerDefinition definition = this.translator.translate(annotation);
        ((MapAssert)Assertions.assertThat((Map)definition.getParameters()).as("parameters")).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"max_token_length", (Object)new JsonPrimitive("5"))});
        ((CollectionAssert)Assertions.assertThat(definition.getParameters().keySet()).as("parameter names")).excludes(new Object[]{"maxTokenLength"});
    }

    @Test
    public void disallowParameter() {
        TokenizerDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenizerDef.class, WhitespaceTokenizerFactory.class, DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("rule", "foo"));
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400061");
        this.thrown.expectMessage(WhitespaceTokenizerFactory.class.getSimpleName());
        this.thrown.expectMessage("'rule'");
        this.translator.translate(annotation);
    }

    @Test
    public void transformParameter() {
        CharFilterDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(CharFilterDef.class, HTMLStripCharFilterFactory.class, DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("escapedTags", "foo,bar"));
        CharFilterDefinition definition = this.translator.translate(annotation);
        ((MapAssert)Assertions.assertThat((Map)definition.getParameters()).as("parameters")).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"escaped_tags", (Object)JsonBuilder.array().add((JsonElement)new JsonPrimitive("foo")).add((JsonElement)new JsonPrimitive("bar")).build())});
    }

    @Test
    public void transformParameter_tokenizerClass() {
        TokenFilterDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenFilterDef.class, SynonymFilterFactory.class, DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("tokenizerFactory", WhitespaceTokenizerFactory.class.getName()));
        TokenFilterDefinition definition = this.translator.translate(annotation);
        ((MapAssert)Assertions.assertThat((Map)definition.getParameters()).as("parameters")).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"tokenizer", (Object)new JsonPrimitive("whitespace"))});
    }

    @Test
    public void transformParameter_tokenizerClass_unknownClass() {
        TokenFilterDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenFilterDef.class, SynonymFilterFactory.class, DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("tokenizerFactory", CustomTokenizerFactory.class.getName()));
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400062");
        this.thrown.expectMessage(SynonymFilterFactory.class.getSimpleName());
        this.thrown.expectMessage("'tokenizerFactory'");
        this.translator.translate(annotation);
    }

    @Test
    public void transformParameter_singleElementArray() {
        TokenFilterDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenFilterDef.class, PatternCaptureGroupFilterFactory.class, DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("pattern", "foo"));
        TokenFilterDefinition definition = this.translator.translate(annotation);
        ((MapAssert)Assertions.assertThat((Map)definition.getParameters()).as("parameters")).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"patterns", (Object)JsonBuilder.array().add((JsonElement)new JsonPrimitive("foo")).build())});
    }

    @Test
    public void transformParameter_norwegianStemmer() {
        TokenFilterDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenFilterDef.class, NorwegianLightStemFilterFactory.class, new Parameter[0]);
        TokenFilterDefinition definition = this.translator.translate(annotation);
        ((StringAssert)Assertions.assertThat((String)definition.getType()).as("type")).isEqualTo((Object)"stemmer");
        ((MapAssert)Assertions.assertThat((Map)definition.getParameters()).as("parameters")).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"name", (Object)new JsonPrimitive("light_norwegian"))});
    }

    @Test
    public void transformParameter_norwegianStemmer_bokmal() {
        TokenFilterDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenFilterDef.class, NorwegianLightStemFilterFactory.class, DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("variant", "nb"));
        TokenFilterDefinition definition = this.translator.translate(annotation);
        ((StringAssert)Assertions.assertThat((String)definition.getType()).as("type")).isEqualTo((Object)"stemmer");
        ((MapAssert)Assertions.assertThat((Map)definition.getParameters()).as("parameters")).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"name", (Object)new JsonPrimitive("light_norwegian"))});
    }

    @Test
    public void transformParameter_norwegianStemmer_nynorsk() {
        TokenFilterDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenFilterDef.class, NorwegianLightStemFilterFactory.class, DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("variant", "nn"));
        TokenFilterDefinition definition = this.translator.translate(annotation);
        ((StringAssert)Assertions.assertThat((String)definition.getType()).as("type")).isEqualTo((Object)"stemmer");
        ((MapAssert)Assertions.assertThat((Map)definition.getParameters()).as("parameters")).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"name", (Object)new JsonPrimitive("light_nynorsk"))});
    }

    @Test
    public void transformParameter_norwegianStemmer_invalid() {
        TokenFilterDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenFilterDef.class, NorwegianLightStemFilterFactory.class, DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("variant", "invalid"));
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400063");
        this.thrown.expectMessage(NorwegianLightStemFilterFactory.class.getSimpleName());
        this.thrown.expectMessage("'variant'");
        this.thrown.expectMessage("'invalid'");
        this.translator.translate(annotation);
    }

    @Test
    public void transformParameter_patternReplace() {
        TokenFilterDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenFilterDef.class, PatternReplaceFilterFactory.class, DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("replace", "first"));
        TokenFilterDefinition definition = this.translator.translate(annotation);
        ((MapAssert)Assertions.assertThat((Map)definition.getParameters()).as("parameters")).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"all", (Object)new JsonPrimitive("false"))});
    }

    @Test
    public void transformParameter_cjkBigramIgnoredScripts() {
        TokenFilterDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenFilterDef.class, CJKBigramFilterFactory.class, DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("outputUnigrams", "true"), DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("han", "false"), DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("hiragana", "false"), DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("katakana", "false"), DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("hangul", "false"));
        TokenFilterDefinition definition = this.translator.translate(annotation);
        ((MapAssert)Assertions.assertThat((Map)definition.getParameters()).as("parameters")).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"output_unigrams", (Object)new JsonPrimitive("true"))});
        ((MapAssert)Assertions.assertThat((Map)definition.getParameters()).as("parameters")).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"ignored_scripts", (Object)JsonBuilder.array().add((JsonElement)new JsonPrimitive("han")).add((JsonElement)new JsonPrimitive("hiragana")).add((JsonElement)new JsonPrimitive("katakana")).add((JsonElement)new JsonPrimitive("hangul")).build())});
        ((CollectionAssert)Assertions.assertThat(definition.getParameters().keySet()).as("parameter names")).excludes(new Object[]{"han", "hiragana", "katakana", "hangul", "outputUnigrams"});
    }

    @Test
    public void passThrough() {
        TokenFilterDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenFilterDef.class, ElasticsearchTokenFilterFactory.class, DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("type", "'foo'"), DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("string", "'foo'"), DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("boolean", "true"), DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("integer", "42"), DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("string_array", "['a','b']"), DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("integer_array", "[1,2]"), DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("object", "{'a':42}"));
        TokenFilterDefinition definition = this.translator.translate(annotation);
        ((StringAssert)Assertions.assertThat((String)definition.getType()).as("type")).isEqualTo((Object)"foo");
        ((MapAssert)Assertions.assertThat((Map)definition.getParameters()).as("parameters")).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"string", (Object)new JsonPrimitive("foo")), MapAssert.entry((Object)"boolean", (Object)new JsonPrimitive(Boolean.valueOf(true))), MapAssert.entry((Object)"integer", (Object)new JsonPrimitive((Number)42)), MapAssert.entry((Object)"string_array", (Object)JsonBuilder.array().add((JsonElement)new JsonPrimitive("a")).add((JsonElement)new JsonPrimitive("b")).build()), MapAssert.entry((Object)"integer_array", (Object)JsonBuilder.array().add((JsonElement)new JsonPrimitive((Number)1)).add((JsonElement)new JsonPrimitive((Number)2)).build()), MapAssert.entry((Object)"object", (Object)JsonBuilder.object().add("a", (JsonElement)new JsonPrimitive((Number)42)).build())});
        ((CollectionAssert)Assertions.assertThat(definition.getParameters().keySet()).as("parameters")).excludes(new Object[]{"type"});
    }

    @Test
    public void passThrough_stringWithoutQuotes() {
        TokenFilterDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenFilterDef.class, ElasticsearchTokenFilterFactory.class, DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("type", "stringWithoutQuotes"), DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("param", "stringWithoutQuotes"));
        TokenFilterDefinition definition = this.translator.translate(annotation);
        ((StringAssert)Assertions.assertThat((String)definition.getType()).as("type")).isEqualTo((Object)"stringWithoutQuotes");
        ((MapAssert)Assertions.assertThat((Map)definition.getParameters()).as("parameters")).includes(new MapAssert.Entry[]{MapAssert.entry((Object)"param", (Object)new JsonPrimitive("stringWithoutQuotes"))});
        ((CollectionAssert)Assertions.assertThat(definition.getParameters().keySet()).as("parameters")).excludes(new Object[]{"type"});
    }

    @Test
    public void passThrough_nonJsonType() {
        TokenFilterDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenFilterDef.class, ElasticsearchTokenFilterFactory.class, DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("type", "["));
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400065");
        this.thrown.expectMessage(ElasticsearchTokenFilterFactory.class.getSimpleName());
        this.thrown.expectMessage("'type'");
        this.translator.translate(annotation);
    }

    @Test
    public void passThrough_nonStringType() {
        TokenFilterDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenFilterDef.class, ElasticsearchTokenFilterFactory.class, DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("type", "{'foo':'bar'}"));
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400065");
        this.thrown.expectMessage(ElasticsearchTokenFilterFactory.class.getSimpleName());
        this.thrown.expectMessage("'type'");
        this.translator.translate(annotation);
    }

    @Test
    public void passThrough_nonJsonParameter() {
        TokenFilterDef annotation = DefaultElasticsearchAnalyzerDefinitionTranslatorTest.annotation(TokenFilterDef.class, ElasticsearchTokenFilterFactory.class, DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("type", "'foo'"), DefaultElasticsearchAnalyzerDefinitionTranslatorTest.param("param", "{"));
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400066");
        this.thrown.expectMessage(ElasticsearchTokenFilterFactory.class.getSimpleName());
        this.thrown.expectMessage("'param'");
        this.translator.translate(annotation);
    }

    private static <T extends Annotation> T annotation(Class<T> annotationType, Class<?> factoryType, Parameter ... parameters) {
        AnnotationDescriptor descriptor = new AnnotationDescriptor(annotationType);
        descriptor.setValue("factory", factoryType);
        descriptor.setValue("params", (Object)parameters);
        return (T)AnnotationFactory.create((AnnotationDescriptor)descriptor);
    }

    private static Parameter param(String name, String value) {
        AnnotationDescriptor descriptor = new AnnotationDescriptor(Parameter.class);
        descriptor.setValue("name", (Object)name);
        descriptor.setValue("value", (Object)value);
        return (Parameter)AnnotationFactory.create((AnnotationDescriptor)descriptor);
    }

    private static abstract class CustomTokenizerFactory
    extends TokenizerFactory {
        protected CustomTokenizerFactory(Map<String, String> args) {
            super(args);
        }
    }
}

