/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.analysis.core.KeywordTokenizerFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.fest.assertions.ObjectAssert;
import org.hibernate.search.analyzer.definition.LuceneAnalyzerDefinitionRegistryBuilder;
import org.hibernate.search.analyzer.definition.spi.LuceneAnalyzerDefinitionProvider;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.elasticsearch.analyzer.definition.ElasticsearchAnalysisDefinitionRegistryBuilder;
import org.hibernate.search.elasticsearch.analyzer.definition.spi.ElasticsearchAnalysisDefinitionProvider;
import org.hibernate.search.elasticsearch.spi.ElasticsearchIndexManagerType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.SearchIntegratorBuilder;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@TestForIssue(jiraKey="HSEARCH-2418")
public class ElasticsearchAnalysisDefinitionProviderIT {
    private static final String CUSTOM_ANALYZER_NAME = "custom-analyzer";
    private static final String CUSTOM_ANALYZER_2_NAME = "custom-analyzer-2";
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void simple() {
        ExtendedSearchIntegrator integrator = this.init(CustomAnalyzerProvider.class, CustomAnalyzerEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getAnalyzerRegistry((IndexManagerType)ElasticsearchIndexManagerType.INSTANCE).getAnalyzerReference(CUSTOM_ANALYZER_NAME)).as("Analyzer reference for 'custom-analyzer' fetched from the integrator")).isNotNull();
        CustomAnalyzerEntity entity = new CustomAnalyzerEntity();
        entity.id = 0L;
        entity.field = "charFilterShouldReplace|foo";
        this.index((SearchIntegrator)integrator, entity);
        this.assertMatchesExactly((SearchIntegrator)integrator, entity, "field", "charfilterdidreplace");
    }

    @Test
    public void override() {
        ExtendedSearchIntegrator integrator = this.init(CustomAnalyzerProvider.class, AnalyzerDefAnnotationEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getAnalyzerRegistry((IndexManagerType)ElasticsearchIndexManagerType.INSTANCE).getAnalyzerReference(CUSTOM_ANALYZER_NAME)).as("Analyzer reference for 'custom-analyzer' fetched from the integrator")).isNotNull();
        AnalyzerDefAnnotationEntity entity = new AnalyzerDefAnnotationEntity();
        entity.id = 0L;
        entity.field = "charFilterShouldReplace|foo";
        this.index((SearchIntegrator)integrator, entity);
        this.assertMatchesExactly((SearchIntegrator)integrator, entity, "field", "charFilterShouldReplace|foo");
    }

    @Test
    public void searchFactoryIncrement() {
        MutatingProviderFactory.provider = new CustomAnalyzerProvider();
        ExtendedSearchIntegrator integrator = this.init(MutatingProviderFactory.class, CustomAnalyzerEntity.class);
        MutatingProviderFactory.provider = new CustomAnalyzer2Provider();
        integrator.addClasses(new Class[]{CustomAnalyzer2Entity.class});
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getAnalyzerRegistry((IndexManagerType)ElasticsearchIndexManagerType.INSTANCE).getAnalyzerReference(CUSTOM_ANALYZER_2_NAME)).as("Analyzer reference for 'custom-analyzer-2' fetched from the integrator")).isNotNull();
        CustomAnalyzer2Entity entity = new CustomAnalyzer2Entity();
        entity.id = 0L;
        entity.field = "foo bar";
        this.index((SearchIntegrator)integrator, entity);
        this.assertMatchesExactly((SearchIntegrator)integrator, entity, "field", "foo");
    }

    @Test
    public void unreferencedAnalyzer() {
        ExtendedSearchIntegrator integrator = this.init(CustomAnalyzerProvider.class, NoAnalyzerEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getAnalyzerRegistry((IndexManagerType)ElasticsearchIndexManagerType.INSTANCE).getAnalyzerReference(CUSTOM_ANALYZER_NAME)).as("Analyzer reference for 'custom-analyzer' fetched from the integrator")).isNotNull();
    }

    @Test
    public void instantiation_factorymethod() {
        ExtendedSearchIntegrator integrator = this.init(ProviderFactory.class, CustomAnalyzerEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getAnalyzerRegistry((IndexManagerType)ElasticsearchIndexManagerType.INSTANCE).getAnalyzerReference(CUSTOM_ANALYZER_NAME)).as("Analyzer reference for 'custom-analyzer' fetched from the integrator")).isNotNull();
    }

    @Test
    public void invalid_notAClass() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(CustomAnalyzerEntity.class);
        cfg.addProperty("hibernate.search.elasticsearch.analyzer_definition_provider", "invalidValue");
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400075");
        new SearchIntegratorBuilder().configuration((SearchConfiguration)cfg).buildSearchIntegrator();
    }

    @Test
    public void invalid_luceneProvider() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(CustomAnalyzerEntity.class);
        cfg.addProperty("hibernate.search.elasticsearch.analyzer_definition_provider", LuceneAnalyzerDefinitionProviderImpl.class.getName());
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400075");
        new SearchIntegratorBuilder().configuration((SearchConfiguration)cfg).buildSearchIntegrator();
    }

    @Test
    public void namingConflict_withinProvider_analyzer() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400074");
        this.init(ProviderWithInternalAnalyzerNamingConflict.class, CustomAnalyzerEntity.class);
    }

    @Test
    public void namingConflict_withinProvider_tokenizer() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400055");
        this.init(ProviderWithInternalTokenizerNamingConflict.class, CustomAnalyzerEntity.class);
    }

    @Test
    public void namingConflict_withinProvider_charFilter() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400056");
        this.init(ProviderWithInternalCharFilterNamingConflict.class, CustomAnalyzerEntity.class);
    }

    @Test
    public void namingConflict_withinProvider_tokenFilter() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400057");
        this.init(ProviderWithInternalTokenFilterNamingConflict.class, CustomAnalyzerEntity.class);
    }

    private ExtendedSearchIntegrator init(Class<?> providerClass, Class<?> ... entityClasses) {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        for (Class<?> entityClass : entityClasses) {
            cfg.addClass(entityClass);
        }
        cfg.addProperty("hibernate.search.elasticsearch.analyzer_definition_provider", providerClass.getName());
        return (ExtendedSearchIntegrator)new SearchIntegratorBuilder().configuration((SearchConfiguration)cfg).buildSearchIntegrator().unwrap(ExtendedSearchIntegrator.class);
    }

    private void index(SearchIntegrator integrator, Identifiable entity) {
        Work work = new Work((Object)entity, (Serializable)Long.valueOf(entity.getId()), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        integrator.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    private void assertMatchesExactly(SearchIntegrator integrator, Identifiable entity, String fieldName, String termValue) {
        this.assertMatchesExactly(integrator, entity, (Query)new TermQuery(new Term(fieldName, termValue)));
    }

    private void assertMatchesExactly(SearchIntegrator integrator, Identifiable entity, Query luceneQuery) {
        Class<?> entityClass = entity.getClass();
        HSQuery query = integrator.createHSQuery(luceneQuery, new Class[]{entityClass});
        List results = query.queryEntityInfos();
        ((ListAssert)Assertions.assertThat((List)results).onProperty("id").as("Results of query '" + luceneQuery + "' on " + entityClass.getSimpleName())).containsExactly(new Object[]{entity.getId()});
    }

    public static class LuceneAnalyzerDefinitionProviderImpl
    implements LuceneAnalyzerDefinitionProvider {
        public void register(LuceneAnalyzerDefinitionRegistryBuilder builder) {
        }
    }

    public static class ProviderWithInternalTokenFilterNamingConflict
    implements ElasticsearchAnalysisDefinitionProvider {
        public void register(ElasticsearchAnalysisDefinitionRegistryBuilder builder) {
            builder.tokenFilter("foo").type("standard");
            builder.tokenFilter("foo").type("standard");
        }
    }

    public static class ProviderWithInternalCharFilterNamingConflict
    implements ElasticsearchAnalysisDefinitionProvider {
        public void register(ElasticsearchAnalysisDefinitionRegistryBuilder builder) {
            builder.charFilter("foo").type("standard");
            builder.charFilter("foo").type("standard");
        }
    }

    public static class ProviderWithInternalTokenizerNamingConflict
    implements ElasticsearchAnalysisDefinitionProvider {
        public void register(ElasticsearchAnalysisDefinitionRegistryBuilder builder) {
            builder.tokenizer("foo").type("standard");
            builder.tokenizer("foo").type("standard");
        }
    }

    public static class ProviderWithInternalAnalyzerNamingConflict
    implements ElasticsearchAnalysisDefinitionProvider {
        public void register(ElasticsearchAnalysisDefinitionRegistryBuilder builder) {
            builder.analyzer(ElasticsearchAnalysisDefinitionProviderIT.CUSTOM_ANALYZER_NAME).withTokenizer("standard");
            builder.analyzer(ElasticsearchAnalysisDefinitionProviderIT.CUSTOM_ANALYZER_NAME).withTokenizer("standard");
        }
    }

    public static class MutatingProviderFactory {
        private static ElasticsearchAnalysisDefinitionProvider provider;

        @Factory
        public static ElasticsearchAnalysisDefinitionProvider create() {
            return provider;
        }
    }

    public static class CustomAnalyzer2Provider
    implements ElasticsearchAnalysisDefinitionProvider {
        public void register(ElasticsearchAnalysisDefinitionRegistryBuilder builder) {
            builder.analyzer(ElasticsearchAnalysisDefinitionProviderIT.CUSTOM_ANALYZER_2_NAME).withTokenizer("myPattern2");
            builder.tokenizer("myPattern2").type("pattern").param("pattern", " ");
        }
    }

    public static class ProviderFactory {
        @Factory
        public static CustomAnalyzerProvider create() {
            return new CustomAnalyzerProvider();
        }
    }

    public static class CustomAnalyzerProvider
    implements ElasticsearchAnalysisDefinitionProvider {
        public void register(ElasticsearchAnalysisDefinitionRegistryBuilder builder) {
            builder.analyzer(ElasticsearchAnalysisDefinitionProviderIT.CUSTOM_ANALYZER_NAME).withTokenizer("myPattern").withCharFilters(new String[]{"myPattern"}).withTokenFilters(new String[]{"myLowerCase"});
            builder.tokenizer("myPattern").type("pattern").param("pattern", "\\|");
            builder.charFilter("myPattern").type("pattern_replace").param("pattern", "charFilterShouldReplace").param("replacement", "charFilterDidReplace");
            builder.tokenFilter("myLowerCase").type("lowercase");
        }
    }

    @Indexed
    static class CustomAnalyzer2Entity
    implements Identifiable {
        @DocumentId
        long id;
        @Field(analyzer=@Analyzer(definition="custom-analyzer-2"))
        String field;

        CustomAnalyzer2Entity() {
        }

        @Override
        public long getId() {
            return this.id;
        }
    }

    @Indexed
    @AnalyzerDef(name="custom-analyzer", tokenizer=@TokenizerDef(factory=KeywordTokenizerFactory.class))
    static class AnalyzerDefAnnotationEntity
    extends CustomAnalyzerEntity {
        AnalyzerDefAnnotationEntity() {
        }
    }

    @Indexed
    static class CustomAnalyzerEntity
    implements Identifiable {
        @DocumentId
        long id;
        @Field(analyzer=@Analyzer(definition="custom-analyzer"))
        String field;

        CustomAnalyzerEntity() {
        }

        @Override
        public long getId() {
            return this.id;
        }
    }

    @Indexed
    static class NoAnalyzerEntity
    implements Identifiable {
        @DocumentId
        long id;
        @Field(analyze=Analyze.NO)
        String field;

        NoAnalyzerEntity() {
        }

        @Override
        public long getId() {
            return this.id;
        }
    }

    private static interface Identifiable {
        public long getId();
    }
}

