/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzer;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzerReference;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class LuceneClassElasticsearchAnalyzerReference
extends ElasticsearchAnalyzerReference {
    private static final Log LOG = LoggerFactory.make();
    private final Class<?> luceneClass;
    private ElasticsearchAnalyzer analyzer;

    public LuceneClassElasticsearchAnalyzerReference(Class<?> luceneClass) {
        this.luceneClass = luceneClass;
        this.analyzer = null;
    }

    public Class<?> getLuceneClass() {
        return this.luceneClass;
    }

    @Override
    public ElasticsearchAnalyzer getAnalyzer() {
        if (this.analyzer == null) {
            throw LOG.lazyRemoteAnalyzerReferenceNotInitialized((RemoteAnalyzerReference)this);
        }
        return this.analyzer;
    }

    public boolean isInitialized() {
        return this.analyzer != null;
    }

    public void initialize(String name, ElasticsearchAnalyzer analyzer) {
        if (this.analyzer != null) {
            throw new AssertionFailure("A named analyzer reference has been initialized more than once: " + (Object)((Object)this));
        }
        this.analyzer = analyzer;
    }

    public void close() {
        if (this.analyzer != null) {
            this.analyzer.close();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append("<");
        sb.append(this.luceneClass);
        sb.append(",");
        sb.append(this.analyzer);
        sb.append(">");
        return sb.toString();
    }
}

