/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import javax.persistence.Entity;
import javax.persistence.Id;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.apache.lucene.analysis.miscellaneous.ASCIIFoldingFilterFactory;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Before;
import org.junit.Test;

public class ElasticsearchSimpleQueryStringDSLIT
extends SearchTestBase {
    private FullTextSession fullTextSession;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        Session session = this.openSession();
        this.fullTextSession = Search.getFullTextSession((Session)session);
        this.indexTestData();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=SearchException.class)
    @TestForIssue(jiraKey="HSEARCH-2678")
    public void testOverridingSeveralAnalyzers() {
        Transaction transaction = this.fullTextSession.beginTransaction();
        try {
            QueryBuilder qb = this.fullTextSession.getSearchFactory().buildQueryBuilder().forEntity(Book.class).overridesForField("author", "titleAnalyzer").overridesForField("title", "authorAnalyzer").get();
            Query query = qb.simpleQueryString().onFields("title", new String[]{"author"}).withAndAsDefaultOperator().matching("Moli\u00e8re").createQuery();
            FullTextQuery fullTextQuery = this.fullTextSession.createFullTextQuery(query, new Class[]{Book.class});
            fullTextQuery.setSort(new Sort(new SortField("title", SortField.Type.STRING)));
            fullTextQuery.getResultList();
        }
        finally {
            transaction.commit();
        }
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Book.class};
    }

    private void indexTestData() {
        Transaction tx = this.fullTextSession.beginTransaction();
        this.fullTextSession.persist((Object)new Book(1L, "Le chat qui regardait les \u00e9toiles", "Lilian Jackson Braun"));
        this.fullTextSession.persist((Object)new Book(2L, "Le chat qui d\u00e9pla\u00e7ait des montagnes", "Lilian Jackson Braun"));
        this.fullTextSession.persist((Object)new Book(3L, "Le Grand Moli\u00e8re illustr\u00e9", "Caroline Guillot"));
        this.fullTextSession.persist((Object)new Book(4L, "Tartuffe", "Moli\u00e8re"));
        this.fullTextSession.persist((Object)new Book(5L, "Dom Garcie de Navarre", "moliere"));
        tx.commit();
        this.fullTextSession.clear();
    }

    @Indexed
    @Entity
    @AnalyzerDefs(value={@AnalyzerDef(name="titleAnalyzer", tokenizer=@TokenizerDef(factory=WhitespaceTokenizerFactory.class), filters={@TokenFilterDef(factory=LowerCaseFilterFactory.class), @TokenFilterDef(factory=ASCIIFoldingFilterFactory.class)}), @AnalyzerDef(name="authorAnalyzer", tokenizer=@TokenizerDef(factory=WhitespaceTokenizerFactory.class))})
    public class Book {
        @DocumentId
        @Id
        Long id;
        @Field(analyzer=@Analyzer(definition="titleAnalyzer"))
        @SortableField
        private String title;
        @Field(analyzer=@Analyzer(definition="authorAnalyzer"))
        private String author;

        public Book() {
        }

        public Book(Long id, String title, String author) {
            this.id = id;
            this.title = title;
            this.author = author;
        }

        public Long getId() {
            return this.id;
        }

        public String getTitle() {
            return this.title;
        }

        public String getAuthor() {
            return this.author;
        }
    }
}

