/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.List;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.elasticsearch.ElasticsearchQueries;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.spatial.DistanceSortField;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.spatial.POI;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ElasticsearchSpatialIT
extends SearchTestBase {
    @Before
    public void setupTestData() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        POI poi = new POI(Integer.valueOf(1), "Distance to 24,32 : 0", Double.valueOf(24.0), Double.valueOf(32.0), "");
        POI poi2 = new POI(Integer.valueOf(2), "Distance to 24,32 : 10.16", Double.valueOf(24.0), Double.valueOf(31.9), "");
        POI poi3 = new POI(Integer.valueOf(3), "Distance to 24,32 : 11.12", Double.valueOf(23.9), Double.valueOf(32.0), "");
        POI poi4 = new POI(Integer.valueOf(4), "Distance to 24,32 : 15.06", Double.valueOf(23.9), Double.valueOf(32.1), "");
        POI poi5 = new POI(Integer.valueOf(5), "Distance to 24,32 : 22.24", Double.valueOf(24.2), Double.valueOf(32.0), "");
        POI poi6 = new POI(Integer.valueOf(6), "Distance to 24,32 : 24.45", Double.valueOf(24.2), Double.valueOf(31.9), "");
        s.persist((Object)poi);
        s.persist((Object)poi2);
        s.persist((Object)poi3);
        s.persist((Object)poi4);
        s.persist((Object)poi5);
        s.persist((Object)poi6);
        tx.commit();
        s.close();
    }

    @After
    public void deleteTestData() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        for (Object entity : result) {
            session.delete(entity);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testGeoDistanceQuery() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        String geoDistanceQuery = "{\n'query' : {\n'bool' : {\n'must' : {\n'match_all' : {}\n},\n'filter' : {\n'geo_distance' : {\n'distance' : '12km',\n'location' : {\n'lat' : 24,\n'lon' : 32\n}\n}\n}\n}\n}\n}";
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)geoDistanceQuery);
        List result = session.createFullTextQuery(query, new Class[]{POI.class}).setSort(new Sort((SortField)new DistanceSortField(24.0, 32.0, "location"))).list();
        ((ListAssert)Assertions.assertThat((List)result).onProperty("id").describedAs("Geo distance query")).containsOnly(new Object[]{1, 2, 3});
        tx.commit();
        s.close();
    }

    @Test
    public void testBoundingBoxQuery() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        String boundingBoxQuery = "{\n'query' : {\n'bool' : {\n'must' : {\n'match_all' : {}\n},\n'filter' : {\n'geo_bounding_box' : {\n'location' : {\n'top_left' : {\n'lat' : 24,\n'lon' : 31.8\n},\n'bottom_right' : {\n'lat' : 23.8,\n'lon' : 32.1\n}\n}\n}\n}\n}\n}\n}";
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)boundingBoxQuery);
        List result = session.createFullTextQuery(query, new Class[]{POI.class}).list();
        ((ListAssert)Assertions.assertThat((List)result).onProperty("id").describedAs("Geo distance query")).containsOnly(new Object[]{1, 2, 3, 4});
        tx.commit();
        s.close();
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{POI.class};
    }
}

