/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.client.impl;

import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.nio.conn.NoopIOSessionStrategy;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.Sniffer;
import org.hibernate.search.elasticsearch.client.impl.DefaultElasticsearchClient;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClientFactory;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClientImplementor;
import org.hibernate.search.elasticsearch.client.impl.ServerUris;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.impl.SearchThreadFactory;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DefaultElasticsearchClientFactory
implements ElasticsearchClientFactory {
    private static final Log log = (Log)LoggerFactory.make(Log.class);
    private static final String HTTP_SCHEME = "http";
    private static final String CLIENT_PROP_PREFIX = "hibernate.search.";

    @Override
    public ElasticsearchClientImplementor create(String scopeName, Properties properties) {
        RestClient restClient = this.createClient(scopeName, properties);
        Sniffer sniffer = this.createSniffer(scopeName, restClient, properties);
        return new DefaultElasticsearchClient(restClient, sniffer);
    }

    private RestClient createClient(String scopeName, Properties properties) {
        String propertyPrefix = this.propertyPrefix(scopeName);
        String serverUrisString = ConfigurationParseHelper.getString((Properties)properties, (String)(propertyPrefix + "elasticsearch.host"), (String)"http://localhost:9200");
        ServerUris hosts = ServerUris.fromString(serverUrisString);
        return RestClient.builder((HttpHost[])hosts.asHostsArray()).setMaxRetryTimeoutMillis(ConfigurationParseHelper.getIntValue((Properties)properties, (String)(propertyPrefix + "elasticsearch.request_timeout"), (int)60000)).setRequestConfigCallback(b -> this.customizeRequestConfig(propertyPrefix, properties, b)).setHttpClientConfigCallback(b -> this.customizeHttpClientConfig(propertyPrefix, properties, hosts, b)).build();
    }

    private Sniffer createSniffer(String scopeName, RestClient client, Properties properties) {
        String propertyPrefix = this.propertyPrefix(scopeName);
        boolean discoveryEnabled = ConfigurationParseHelper.getBooleanValue((Properties)properties, (String)(propertyPrefix + "elasticsearch.discovery.enabled"), (boolean)false);
        if (discoveryEnabled) {
            return Sniffer.builder((RestClient)client).setSniffIntervalMillis(ConfigurationParseHelper.getIntValue((Properties)properties, (String)(propertyPrefix + "elasticsearch.discovery.refresh_interval"), (int)10) * 1000).build();
        }
        return null;
    }

    private HttpAsyncClientBuilder customizeHttpClientConfig(String propertyPrefix, Properties properties, ServerUris hosts, HttpAsyncClientBuilder builder) {
        String username;
        builder = builder.setMaxConnTotal(ConfigurationParseHelper.getIntValue((Properties)properties, (String)(propertyPrefix + "elasticsearch.max_total_connection"), (int)20)).setMaxConnPerRoute(ConfigurationParseHelper.getIntValue((Properties)properties, (String)(propertyPrefix + "elasticsearch.max_total_connection_per_route"), (int)2)).setThreadFactory((ThreadFactory)new SearchThreadFactory("Elasticsearch transport thread"));
        if (!hosts.isAnyRequiringSSL()) {
            builder.setSSLStrategy((SchemeIOSessionStrategy)NoopIOSessionStrategy.INSTANCE);
        }
        if ((username = ConfigurationParseHelper.getString((Properties)properties, (String)(propertyPrefix + "elasticsearch.username"), null)) != null) {
            String password = ConfigurationParseHelper.getString((Properties)properties, (String)(propertyPrefix + "elasticsearch.password"), null);
            if (password != null) {
                hosts.warnPasswordsOverHttp();
            }
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), (Credentials)new UsernamePasswordCredentials(username, password));
            builder = builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        }
        return builder;
    }

    private RequestConfig.Builder customizeRequestConfig(String propertyPrefix, Properties properties, RequestConfig.Builder builder) {
        return builder.setConnectionRequestTimeout(0).setSocketTimeout(ConfigurationParseHelper.getIntValue((Properties)properties, (String)(propertyPrefix + "elasticsearch.read_timeout"), (int)60000)).setConnectTimeout(ConfigurationParseHelper.getIntValue((Properties)properties, (String)(propertyPrefix + "elasticsearch.connection_timeout"), (int)3000));
    }

    private String propertyPrefix(String scopeName) {
        return CLIENT_PROP_PREFIX + scopeName + ".";
    }
}

