/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.dialect.impl.es2;

import com.google.gson.GsonBuilder;
import org.hibernate.search.elasticsearch.dialect.impl.ElasticsearchDialect;
import org.hibernate.search.elasticsearch.gson.impl.DefaultGsonProvider;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.nulls.impl.Elasticsearch2MissingValueStrategy;
import org.hibernate.search.elasticsearch.schema.impl.Elasticsearch2SchemaTranslator;
import org.hibernate.search.elasticsearch.schema.impl.Elasticsearch2SchemaValidator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaAccessor;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaTranslator;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaValidator;
import org.hibernate.search.elasticsearch.schema.impl.model.FieldDataType;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexType;
import org.hibernate.search.elasticsearch.schema.impl.model.NormsType;
import org.hibernate.search.elasticsearch.util.impl.gson.ES2FieldDataTypeJsonAdapter;
import org.hibernate.search.elasticsearch.util.impl.gson.ES2IndexTypeJsonAdapter;
import org.hibernate.search.elasticsearch.util.impl.gson.ES2NormsTypeJsonAdapter;
import org.hibernate.search.elasticsearch.work.impl.factory.Elasticsearch2WorkFactory;
import org.hibernate.search.elasticsearch.work.impl.factory.ElasticsearchWorkFactory;
import org.hibernate.search.engine.nulls.impl.MissingValueStrategy;

public class Elasticsearch2Dialect
implements ElasticsearchDialect {
    @Override
    public GsonProvider createGsonProvider() {
        return DefaultGsonProvider.create(() -> new GsonBuilder().registerTypeAdapter(IndexType.class, (Object)new ES2IndexTypeJsonAdapter().nullSafe()).registerTypeAdapter(FieldDataType.class, (Object)new ES2FieldDataTypeJsonAdapter().nullSafe()).registerTypeAdapter(NormsType.class, (Object)new ES2NormsTypeJsonAdapter().nullSafe()));
    }

    @Override
    public ElasticsearchWorkFactory createWorkFactory(GsonProvider gsonProvider) {
        return new Elasticsearch2WorkFactory(gsonProvider);
    }

    @Override
    public ElasticsearchSchemaTranslator createSchemaTranslator() {
        return new Elasticsearch2SchemaTranslator();
    }

    @Override
    public ElasticsearchSchemaValidator createSchemaValidator(ElasticsearchSchemaAccessor schemaAccessor) {
        return new Elasticsearch2SchemaValidator(schemaAccessor);
    }

    @Override
    public MissingValueStrategy createMissingValueStrategy() {
        return Elasticsearch2MissingValueStrategy.INSTANCE;
    }
}

