/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.schema.impl.model;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.search.elasticsearch.schema.impl.model.DataType;
import org.hibernate.search.elasticsearch.schema.impl.model.ElasticsearchFormatJsonAdapter;
import org.hibernate.search.elasticsearch.schema.impl.model.FieldDataType;
import org.hibernate.search.elasticsearch.schema.impl.model.IndexType;
import org.hibernate.search.elasticsearch.schema.impl.model.NormsType;
import org.hibernate.search.elasticsearch.schema.impl.model.TypeMapping;

public class PropertyMapping
extends TypeMapping {
    private DataType type;
    private Float boost;
    private IndexType index;
    private NormsType norms;
    @SerializedName(value="doc_values")
    private Boolean docValues;
    private Boolean store;
    @SerializedName(value="null_value")
    private JsonPrimitive nullValue;
    private Map<String, PropertyMapping> fields;
    private String analyzer;
    @SerializedName(value="fielddata")
    private FieldDataType fieldData;
    @JsonAdapter(value=ElasticsearchFormatJsonAdapter.class)
    private List<String> format;

    public DataType getType() {
        return this.type;
    }

    public void setType(DataType type) {
        this.type = type;
    }

    public List<String> getFormat() {
        return this.format;
    }

    public void setFormat(List<String> format) {
        this.format = format;
    }

    public Float getBoost() {
        return this.boost;
    }

    public void setBoost(Float boost) {
        this.boost = boost;
    }

    public IndexType getIndex() {
        return this.index;
    }

    public void setIndex(IndexType index) {
        this.index = index;
    }

    public NormsType getNorms() {
        return this.norms;
    }

    public void setNorms(NormsType norms) {
        this.norms = norms;
    }

    public Boolean getDocValues() {
        return this.docValues;
    }

    public void setDocValues(Boolean docValues) {
        this.docValues = docValues;
    }

    public Boolean getStore() {
        return this.store;
    }

    public void setStore(Boolean store) {
        this.store = store;
    }

    public JsonPrimitive getNullValue() {
        return this.nullValue;
    }

    public void setNullValue(JsonPrimitive nullValue) {
        this.nullValue = nullValue;
    }

    public Map<String, PropertyMapping> getFields() {
        return this.fields;
    }

    private Map<String, PropertyMapping> getInitializedFields() {
        if (this.fields == null) {
            this.fields = new TreeMap<String, PropertyMapping>();
        }
        return this.fields;
    }

    public void addField(String name, PropertyMapping mapping) {
        this.getInitializedFields().put(name, mapping);
    }

    public void removeField(String name) {
        this.getInitializedFields().remove(name);
    }

    public String getAnalyzer() {
        return this.analyzer;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public FieldDataType getFieldData() {
        return this.fieldData;
    }

    public void setFieldData(FieldDataType fieldData) {
        this.fieldData = fieldData;
    }

    @Override
    public String toString() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((Object)this);
    }
}

