/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.util.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.elasticsearch.client.Response;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;

public class ElasticsearchClientUtils {
    private static final ContentType JSON_CONTENT_TYPE = ContentType.APPLICATION_JSON.withCharset("utf-8");

    private ElasticsearchClientUtils() {
    }

    public static boolean isSuccessCode(int code) {
        return 200 <= code && code < 300;
    }

    public static HttpEntity toEntity(Gson gson, ElasticsearchRequest request) {
        List<JsonObject> bodyParts = request.getBodyParts();
        if (bodyParts.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (JsonObject bodyPart : bodyParts) {
            gson.toJson((JsonElement)bodyPart, (Appendable)builder);
            builder.append("\n");
        }
        return new StringEntity(builder.toString(), JSON_CONTENT_TYPE);
    }

    /*
     * Exception decompiling
     */
    public static JsonObject parseJsonResponse(GsonProvider gsonProvider, Response response) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String formatRequest(GsonProvider gsonProvider, ElasticsearchRequest request) {
        StringBuilder sb = new StringBuilder();
        sb.append("Method: ").append(request.getMethod()).append("\n");
        sb.append("Path: ").append(request.getPath()).append("\n");
        sb.append("Data:\n");
        sb.append(ElasticsearchClientUtils.formatRequestData(gsonProvider, request));
        sb.append("\n");
        return sb.toString();
    }

    public static String formatRequestData(GsonProvider gsonProvider, ElasticsearchRequest request) {
        List<JsonObject> bodyParts = request.getBodyParts();
        Gson gson = gsonProvider.getGsonPrettyPrinting();
        StringBuilder builder = new StringBuilder();
        for (JsonObject bodyPart : bodyParts) {
            gson.toJson((JsonElement)bodyPart, (Appendable)builder);
            builder.append("\n");
        }
        return builder.toString();
    }

    public static String formatRequestData(GsonProvider gsonProvider, JsonObject body) {
        Gson gson = gsonProvider.getGsonPrettyPrinting();
        return gson.toJson((JsonElement)body);
    }

    public static String formatResponse(GsonProvider gsonProvider, Response response, JsonObject parsedResponse) {
        if (response == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        StatusLine statusLine = response.getStatusLine();
        sb.append("Status: ").append(statusLine.getStatusCode()).append(" ").append(statusLine.getReasonPhrase()).append("\n");
        sb.append("Error message: ").append(ElasticsearchClientUtils.propertyAsString((JsonElement)parsedResponse, "error")).append("\n");
        sb.append("Cluster name: ").append(ElasticsearchClientUtils.propertyAsString((JsonElement)parsedResponse, "cluster_name")).append("\n");
        sb.append("Cluster status: ").append(ElasticsearchClientUtils.propertyAsString((JsonElement)parsedResponse, "status")).append("\n");
        sb.append("\n");
        JsonElement items = ElasticsearchClientUtils.property(parsedResponse, "items");
        if (items != null && items.isJsonArray()) {
            for (JsonElement item : items.getAsJsonArray()) {
                for (Map.Entry entry : item.getAsJsonObject().entrySet()) {
                    sb.append("Operation: ").append((String)entry.getKey()).append("\n");
                    JsonElement value = (JsonElement)entry.getValue();
                    sb.append("  Index: ").append(ElasticsearchClientUtils.propertyAsString(value, "_index")).append("\n");
                    sb.append("  Type: ").append(ElasticsearchClientUtils.propertyAsString(value, "_type")).append("\n");
                    sb.append("  Id: ").append(ElasticsearchClientUtils.propertyAsString(value, "_id")).append("\n");
                    sb.append("  Status: ").append(ElasticsearchClientUtils.propertyAsString(value, "status")).append("\n");
                    sb.append("  Error: ").append(ElasticsearchClientUtils.propertyAsString(value, "error")).append("\n");
                }
            }
        }
        return sb.toString();
    }

    private static JsonElement property(JsonObject parent, String name) {
        if (parent == null) {
            return null;
        }
        return parent.get(name);
    }

    private static String propertyAsString(JsonElement parent, String name) {
        if (parent == null || !parent.isJsonObject()) {
            return null;
        }
        JsonElement propretyValue = ElasticsearchClientUtils.property(parent.getAsJsonObject(), name);
        if (propretyValue == null) {
            return null;
        }
        return propretyValue.toString();
    }
}

