/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.client.Response;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.Paths;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchClientUtils;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.DeleteByQueryWorkBuilder;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ES2DeleteByQueryWork
extends SimpleElasticsearchWork<Void> {
    protected ES2DeleteByQueryWork(Builder builder) {
        super(builder);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, Response response, JsonObject parsedResponseBody) {
        return null;
    }

    private static class SuccessAssessor
    implements ElasticsearchRequestSuccessAssessor {
        private static final Log LOG = (Log)LoggerFactory.make(Log.class);
        private static final int NOT_FOUND_HTTP_STATUS_CODE = 404;
        public static final SuccessAssessor INSTANCE = new SuccessAssessor();
        private final DefaultElasticsearchRequestSuccessAssessor delegate = DefaultElasticsearchRequestSuccessAssessor.builder().ignoreErrorStatuses(404).build();

        private SuccessAssessor() {
        }

        @Override
        public void checkSuccess(ElasticsearchWorkExecutionContext context, ElasticsearchRequest request, Response response, JsonObject parsedResponseBody) throws SearchException {
            this.delegate.checkSuccess(context, request, response, parsedResponseBody);
            if (response.getStatusLine().getStatusCode() == 404) {
                GsonProvider gsonProvider = context.getGsonProvider();
                throw LOG.elasticsearch2RequestDeleteByQueryNotFound(ElasticsearchClientUtils.formatRequest(gsonProvider, request), ElasticsearchClientUtils.formatResponse(gsonProvider, response, parsedResponseBody));
            }
        }

        @Override
        public boolean isSuccess(ElasticsearchWorkExecutionContext context, JsonObject bulkResponseItem) {
            throw new AssertionFailure("This method should never be called, because DeleteByQuery actions are not Bulkable");
        }
    }

    public static class Builder
    extends SimpleElasticsearchWork.Builder<Builder>
    implements DeleteByQueryWorkBuilder {
        private final URLEncodedString indexName;
        private final JsonObject payload;
        private final Set<URLEncodedString> typeNames = new HashSet<URLEncodedString>();

        public Builder(URLEncodedString indexName, JsonObject payload) {
            super(indexName, SuccessAssessor.INSTANCE);
            this.indexName = indexName;
            this.payload = payload;
        }

        @Override
        public Builder type(URLEncodedString typeName) {
            this.typeNames.add(typeName);
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.delete().pathComponent(this.indexName);
            if (!this.typeNames.isEmpty()) {
                builder.multiValuedPathComponent(this.typeNames);
            }
            builder.pathComponent(Paths._QUERY).body(this.payload);
            return builder.build();
        }

        @Override
        public ES2DeleteByQueryWork build() {
            return new ES2DeleteByQueryWork(this);
        }
    }
}

