/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import org.elasticsearch.client.Response;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.Paths;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.DeleteByQueryWorkBuilder;

public class ES5DeleteByQueryWork
extends SimpleElasticsearchWork<Void> {
    protected ES5DeleteByQueryWork(Builder builder) {
        super(builder);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, Response response, JsonObject parsedResponseBody) {
        return null;
    }

    public static class Builder
    extends SimpleElasticsearchWork.Builder<Builder>
    implements DeleteByQueryWorkBuilder {
        private final URLEncodedString indexName;
        private final JsonObject payload;
        private final Set<URLEncodedString> typeNames = new HashSet<URLEncodedString>();

        public Builder(URLEncodedString indexName, JsonObject payload) {
            super(indexName, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.indexName = indexName;
            this.payload = payload;
        }

        @Override
        public Builder type(URLEncodedString typeName) {
            this.typeNames.add(typeName);
            return this;
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.post().pathComponent(this.indexName);
            if (!this.typeNames.isEmpty()) {
                builder.multiValuedPathComponent(this.typeNames);
            }
            builder.pathComponent(Paths._DELETE_BY_QUERY).body(this.payload);
            return builder.build();
        }

        @Override
        public ES5DeleteByQueryWork build() {
            return new ES5DeleteByQueryWork(this);
        }
    }
}

