/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.work.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import org.elasticsearch.client.Response;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.Paths;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.schema.impl.model.TypeMapping;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.builder.PutIndexMappingWorkBuilder;

public class PutIndexTypeMappingWork
extends SimpleElasticsearchWork<Void> {
    protected PutIndexTypeMappingWork(Builder builder) {
        super(builder);
    }

    @Override
    protected Void generateResult(ElasticsearchWorkExecutionContext context, Response response, JsonObject parsedResponseBody) {
        return null;
    }

    public static class Builder
    extends SimpleElasticsearchWork.Builder<Builder>
    implements PutIndexMappingWorkBuilder {
        private final URLEncodedString indexName;
        private final URLEncodedString typeName;
        private final JsonObject payload;

        public Builder(GsonProvider gsonProvider, URLEncodedString indexName, URLEncodedString typeName, TypeMapping typeMapping) {
            super(null, DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
            this.indexName = indexName;
            this.typeName = typeName;
            Gson gson = gsonProvider.getGsonNoSerializeNulls();
            this.payload = gson.toJsonTree((Object)typeMapping).getAsJsonObject();
        }

        @Override
        protected ElasticsearchRequest buildRequest() {
            ElasticsearchRequest.Builder builder = ElasticsearchRequest.put().pathComponent(this.indexName).pathComponent(this.typeName).pathComponent(Paths._MAPPING).body(this.payload);
            return builder.build();
        }

        @Override
        public PutIndexTypeMappingWork build() {
            return new PutIndexTypeMappingWork(this);
        }
    }
}

