/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.io.IOException;
import java.util.HashMap;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.CharFilterDef;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.elasticsearch.analyzer.ElasticsearchCharFilterFactory;
import org.hibernate.search.elasticsearch.analyzer.ElasticsearchTokenFilterFactory;
import org.hibernate.search.elasticsearch.analyzer.ElasticsearchTokenizerFactory;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.schema.impl.ElasticsearchSchemaValidationException;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.TestConfiguration;
import org.hibernate.search.test.util.impl.ExceptionMatcherBuilder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public abstract class AbstractAnalyzerDefinitionValidationIT
extends SearchInitializationTestBase {
    private static final String VALIDATION_FAILED_MESSAGE_ID = "HSEARCH400033";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TestElasticsearchClient elasticSearchClient = new TestElasticsearchClient();

    protected void init(Class<?> ... annotatedClasses) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("hibernate.search.default.elasticsearch.index_schema_management_strategy", IndexSchemaManagementStrategy.VALIDATE.getExternalName());
        this.init((TestConfiguration)new ImmutableTestConfiguration(settings, (Class[])annotatedClasses));
    }

    @Test
    public void success_simple() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate("index.analysis", "{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types', 'custom-word-delimiter']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': '10'}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<DOUBLE>', '<NUM>']},'custom-word-delimiter': {'type': 'word_delimiter','generate_word_parts': false}}}");
        this.putMapping();
        this.init(AnalyzedEntity.class);
    }

    protected abstract void putMapping() throws IOException;

    @Test
    public void analyzer_missing() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate("index.analysis", "{'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']},'custom-word-delimiter': {'type': 'word_delimiter','generate_word_parts': false}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("analyzer 'analyzerWithElasticsearchFactories':\n\tMissing analyzer").build());
        this.init(AnalyzedEntity.class);
    }

    @Test
    public void analyzer_charFilters_invalid() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate("index.analysis", "{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['html_strip'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types', 'custom-word-delimiter']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']},'custom-word-delimiter': {'type': 'word_delimiter','generate_word_parts': false}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("analyzer 'analyzerWithElasticsearchFactories':\n\tInvalid char filters. Expected '[custom-pattern-replace]', actual is '[html_strip]'").build());
        this.init(AnalyzedEntity.class);
    }

    @Test
    public void analyzer_tokenizer_invalid() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate("index.analysis", "{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'whitespace','filter': ['custom-keep-types', 'custom-word-delimiter']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']},'custom-word-delimiter': {'type': 'word_delimiter','generate_word_parts': false}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("analyzer 'analyzerWithElasticsearchFactories':\n\tInvalid tokenizer. Expected 'custom-edgeNGram', actual is 'whitespace'").build());
        this.init(AnalyzedEntity.class);
    }

    @Test
    public void analyzer_tokenFilters_invalid() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate("index.analysis", "{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['standard', 'custom-word-delimiter']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']},'custom-word-delimiter': {'type': 'word_delimiter','generate_word_parts': false}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("analyzer 'analyzerWithElasticsearchFactories':\n\tInvalid token filters. Expected '[custom-keep-types, custom-word-delimiter]', actual is '[standard, custom-word-delimiter]'").build());
        this.init(AnalyzedEntity.class);
    }

    @Test
    public void charFilter_missing() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate("index.analysis", "{'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']},'custom-word-delimiter': {'type': 'word_delimiter','generate_word_parts': false}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("char filter 'custom-pattern-replace':\n\tMissing char filter").build());
        this.init(AnalyzedEntity.class);
    }

    @Test
    public void tokenizer_missing() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate("index.analysis", "{'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']},'custom-word-delimiter': {'type': 'word_delimiter','generate_word_parts': false}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("tokenizer 'custom-edgeNGram':\n\tMissing tokenizer").build());
        this.init(AnalyzedEntity.class);
    }

    @Test
    public void tokenFilter_missing() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate("index.analysis", "{'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("token filter 'custom-keep-types':\n\tMissing token filter").build());
        this.init(AnalyzedEntity.class);
    }

    @Test
    public void charFilter_type_invalid() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate("index.analysis", "{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types', 'custom-word-delimiter']}},'char_filter': {'custom-pattern-replace': {'type': 'html_strip','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']},'custom-word-delimiter': {'type': 'word_delimiter','generate_word_parts': false}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("char filter 'custom-pattern-replace':\n\tInvalid type. Expected 'pattern_replace', actual is 'html_strip'").build());
        this.init(AnalyzedEntity.class);
    }

    @Test
    public void charFilter_parameter_invalid() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate("index.analysis", "{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types', 'custom-word-delimiter']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^a-z]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']},'custom-word-delimiter': {'type': 'word_delimiter','generate_word_parts': false}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("char filter 'custom-pattern-replace':\n\tInvalid value for parameter 'pattern'. Expected '\"[^0-9]\"', actual is '\"[^a-z]\"'").build());
        this.init(AnalyzedEntity.class);
    }

    @Test
    public void charFilter_parameter_missing() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate("index.analysis", "{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types', 'custom-word-delimiter']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']},'custom-word-delimiter': {'type': 'word_delimiter','generate_word_parts': false}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("char filter 'custom-pattern-replace':\n\tInvalid value for parameter 'tags'. Expected '\"CASE_INSENSITIVE|COMMENTS\"', actual is 'null'").build());
        this.init(AnalyzedEntity.class);
    }

    @Test
    public void tokenFilter_parameter_unexpected() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate("index.analysis", "{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types', 'custom-word-delimiter']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']},'custom-word-delimiter': {'type': 'word_delimiter','generate_word_parts': false,'generate_number_parts': false}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(ElasticsearchSchemaValidationException.class).withMessage(VALIDATION_FAILED_MESSAGE_ID).withMessage("filter 'custom-word-delimiter':\n\tInvalid value for parameter 'generate_number_parts'. Expected 'null', actual is '\"false\"'").build());
        this.init(AnalyzedEntity.class);
    }

    @Indexed
    @Entity
    @AnalyzerDef(name="analyzerWithElasticsearchFactories", charFilters={@CharFilterDef(name="custom-pattern-replace", factory=ElasticsearchCharFilterFactory.class, params={@Parameter(name="type", value="'pattern_replace'"), @Parameter(name="pattern", value="'[^0-9]'"), @Parameter(name="replacement", value="'0'"), @Parameter(name="tags", value="'CASE_INSENSITIVE|COMMENTS'")})}, tokenizer=@TokenizerDef(name="custom-edgeNGram", factory=ElasticsearchTokenizerFactory.class, params={@Parameter(name="type", value="edgeNGram"), @Parameter(name="min_gram", value="1"), @Parameter(name="max_gram", value="'10'")}), filters={@TokenFilterDef(name="custom-keep-types", factory=ElasticsearchTokenFilterFactory.class, params={@Parameter(name="type", value="'keep_types'"), @Parameter(name="types", value="['<NUM>','<DOUBLE>']")}), @TokenFilterDef(name="custom-word-delimiter", factory=ElasticsearchTokenFilterFactory.class, params={@Parameter(name="type", value="'word_delimiter'"), @Parameter(name="generate_word_parts", value="false")})})
    public static class AnalyzedEntity {
        @DocumentId
        @Id
        Long id;
        @Field(analyzer=@Analyzer(definition="analyzerWithElasticsearchFactories"))
        String myField;
    }
}

