/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.testutil.JsonHelper;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.elasticsearch.testutil.junit.SkipFromElasticsearch50;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.TestConfiguration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SkipFromElasticsearch50.class})
public class Elasticsearch2SchemaCreationIT
extends SearchInitializationTestBase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TestElasticsearchClient elasticSearchClient = new TestElasticsearchClient();
    private final IndexSchemaManagementStrategy strategy;

    @Parameterized.Parameters(name="With strategy {0}")
    public static EnumSet<IndexSchemaManagementStrategy> strategies() {
        return EnumSet.complementOf(EnumSet.of(IndexSchemaManagementStrategy.NONE, IndexSchemaManagementStrategy.VALIDATE));
    }

    public Elasticsearch2SchemaCreationIT(IndexSchemaManagementStrategy strategy) {
        this.strategy = strategy;
    }

    protected void init(Class<?> ... annotatedClasses) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("hibernate.search.default.elasticsearch.index_schema_management_strategy", this.strategy.getExternalName());
        this.init((TestConfiguration)new ImmutableTestConfiguration(settings, (Class[])annotatedClasses));
    }

    @Test
    public void dateField() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).ensureDoesNotExist().registerForCleanup();
        this.init(SimpleDateEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','format': 'strict_date_optional_time||epoch_millis'}}}", this.elasticSearchClient.type(SimpleDateEntity.class).getMapping());
    }

    @Test
    public void booleanField() throws Exception {
        this.elasticSearchClient.index(SimpleBooleanEntity.class).ensureDoesNotExist().registerForCleanup();
        this.init(SimpleBooleanEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean'}}}", this.elasticSearchClient.type(SimpleBooleanEntity.class).getMapping());
    }

    @Test
    public void stringField() throws Exception {
        this.elasticSearchClient.index(SimpleStringEntity.class).ensureDoesNotExist().registerForCleanup();
        this.init(SimpleStringEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'analyzedField': {'type': 'string'},'nonAnalyzedField': {'type': 'string','index': 'not_analyzed'}}}", this.elasticSearchClient.type(SimpleStringEntity.class).getMapping());
    }

    @Indexed
    @Entity
    private static class SimpleStringEntity {
        @DocumentId
        @Id
        Long id;
        @Field(analyze=Analyze.YES)
        String analyzedField;
        @Field(analyze=Analyze.NO)
        String nonAnalyzedField;

        private SimpleStringEntity() {
        }
    }

    @Indexed
    @Entity
    private static class SimpleDateEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        Date myField;

        private SimpleDateEntity() {
        }
    }

    @Indexed
    @Entity
    private static class SimpleBooleanEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        Boolean myField;

        private SimpleBooleanEntity() {
        }
    }
}

