/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.testutil.JsonHelper;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.elasticsearch.testutil.junit.SkipFromElasticsearch50;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.TestConfiguration;
import org.hibernate.search.test.util.impl.ExceptionMatcherBuilder;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={SkipFromElasticsearch50.class})
public class Elasticsearch2SchemaMigrationIT
extends SearchInitializationTestBase {
    private static final String UPDATE_FAILED_MESSAGE_ID = "HSEARCH400035";
    private static final String MAPPING_CREATION_FAILED_MESSAGE_ID = "HSEARCH400020";
    private static final String ELASTICSEARCH_REQUEST_FAILED_MESSAGE_ID = "HSEARCH400007";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TestElasticsearchClient elasticSearchClient = new TestElasticsearchClient();

    protected void init(Class<?> ... annotatedClasses) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("hibernate.search.default.elasticsearch.index_schema_management_strategy", IndexSchemaManagementStrategy.UPDATE.getExternalName());
        this.init((TestConfiguration)new ImmutableTestConfiguration(settings, (Class[])annotatedClasses));
    }

    @Test
    public void nothingToDo() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate().type(SimpleDateEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'not_analyzed','ignore_malformed': true},'NOTmyField': {'type': 'date','index': 'not_analyzed'}}}");
        this.elasticSearchClient.index(SimpleBooleanEntity.class).deleteAndCreate().type(SimpleBooleanEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean','index': 'not_analyzed'},'NOTmyField': {'type': 'boolean','index': 'not_analyzed'}}}");
        this.elasticSearchClient.index(SimpleStringEntity.class).deleteAndCreate("index.analysis", this.generateAnalysisSettings());
        this.elasticSearchClient.type(SimpleStringEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'defaultAnalyzer': {'type': 'string'},'nonDefaultAnalyzer': {'type': 'string','analyzer': 'customAnalyzer'},'normalizer': {'type': 'string','analyzer': 'customNormalizer'}}}");
        this.init(SimpleDateEntity.class, SimpleBooleanEntity.class, SimpleStringEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','format': 'strict_date_optional_time||epoch_millis','ignore_malformed': true},'NOTmyField': {'type': 'date','format': 'strict_date_optional_time||epoch_millis'}}}", this.elasticSearchClient.type(SimpleDateEntity.class).getMapping());
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean'},'NOTmyField': {'type': 'boolean'}}}", this.elasticSearchClient.type(SimpleBooleanEntity.class).getMapping());
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'defaultAnalyzer': {'type': 'string'},'nonDefaultAnalyzer': {'type': 'string','analyzer': 'customAnalyzer'},'normalizer': {'type': 'string','analyzer': 'customNormalizer'}}}", this.elasticSearchClient.type(SimpleStringEntity.class).getMapping());
    }

    @Test
    public void mapping_missing() throws Exception {
        this.elasticSearchClient.index(SimpleBooleanEntity.class).deleteAndCreate();
        this.init(SimpleBooleanEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean'}}}", this.elasticSearchClient.type(SimpleBooleanEntity.class).getMapping());
    }

    @Test
    public void rootMapping_attribute_missing() throws Exception {
        this.elasticSearchClient.index(SimpleBooleanEntity.class).deleteAndCreate().type(SimpleBooleanEntity.class).putMapping("{'properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean','index': 'not_analyzed'},'NOTmyField': {'type': 'boolean','index': 'not_analyzed'}}}");
        this.init(SimpleBooleanEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'boolean'},'NOTmyField': {'type': 'boolean'}}}", this.elasticSearchClient.type(SimpleBooleanEntity.class).getMapping());
    }

    @Test
    public void property_missing() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate().type(SimpleDateEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'NOTmyField': {'type': 'date','index': 'not_analyzed'}}}");
        this.init(SimpleDateEntity.class);
        JsonHelper.assertJsonEquals("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','format': 'strict_date_optional_time||epoch_millis'},'NOTmyField': {'type': 'date','format': 'strict_date_optional_time||epoch_millis'}}}", this.elasticSearchClient.type(SimpleDateEntity.class).getMapping());
    }

    @Test
    public void property_attribute_invalid() throws Exception {
        this.elasticSearchClient.index(SimpleDateEntity.class).deleteAndCreate().type(SimpleDateEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'myField': {'type': 'date','index': 'analyzed'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(SearchException.class).withMessage(UPDATE_FAILED_MESSAGE_ID).causedBy(SearchException.class).withMessage(MAPPING_CREATION_FAILED_MESSAGE_ID).causedBy(SearchException.class).withMessage(ELASTICSEARCH_REQUEST_FAILED_MESSAGE_ID).withMessage("index").build());
        this.init(SimpleDateEntity.class);
    }

    @Test
    public void property_attribute_invalid_conflictingAnalyzer() throws Exception {
        this.elasticSearchClient.index(SimpleStringEntity.class).deleteAndCreate("index.analysis", this.generateAnalysisSettings());
        this.elasticSearchClient.type(SimpleStringEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'defaultAnalyzer': {'type': 'string'},'nonDefaultAnalyzer': {'type': 'string','analyzer': 'standard'},'normalizer': {'type': 'string','analyzer': 'customNormalizer'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(SearchException.class).withMessage(UPDATE_FAILED_MESSAGE_ID).causedBy(SearchException.class).withMessage(MAPPING_CREATION_FAILED_MESSAGE_ID).causedBy(SearchException.class).withMessage(ELASTICSEARCH_REQUEST_FAILED_MESSAGE_ID).withMessage("analyzer").build());
        this.init(SimpleStringEntity.class);
    }

    @Test
    public void property_attribute_invalid_conflictingNormalizer() throws Exception {
        this.elasticSearchClient.index(SimpleStringEntity.class).deleteAndCreate("index.analysis", this.generateAnalysisSettings());
        this.elasticSearchClient.type(SimpleStringEntity.class).putMapping("{'dynamic': 'strict','properties': {'id': {'type': 'string','index': 'not_analyzed','store': true},'defaultAnalyzer': {'type': 'string'},'nonDefaultAnalyzer': {'type': 'string','index': 'analyzed','analyzer': 'customAnalyzer'},'normalizer': {'type': 'string','index': 'analyzed','analyzer': 'standard'}}}");
        this.thrown.expect(ExceptionMatcherBuilder.isException(SearchException.class).withMessage(UPDATE_FAILED_MESSAGE_ID).causedBy(SearchException.class).withMessage(MAPPING_CREATION_FAILED_MESSAGE_ID).causedBy(SearchException.class).withMessage(ELASTICSEARCH_REQUEST_FAILED_MESSAGE_ID).withMessage("analyzer").build());
        this.init(SimpleStringEntity.class);
    }

    private String generateAnalysisSettings() throws IOException {
        return "{'analyzer': {'customAnalyzer': {'tokenizer': 'whitespace'},'customNormalizer': {'tokenizer': 'keyword'}}}";
    }

    @Indexed
    @Entity
    public static class SimpleStringEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        String defaultAnalyzer;
        @Field(analyzer=@Analyzer(definition="customAnalyzer"))
        String nonDefaultAnalyzer;
        @Field(analyzer=@Analyzer(definition="customNormalizer"))
        String normalizer;
    }

    @Indexed
    @Entity
    public static class SimpleDateEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        Date myField;
    }

    @Indexed
    @Entity
    public static class SimpleBooleanEntity {
        @DocumentId
        @Id
        Long id;
        @Field
        Boolean myField;
    }
}

