/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.elasticsearch.ElasticsearchQueries;
import org.hibernate.search.elasticsearch.test.GolfCourse;
import org.hibernate.search.elasticsearch.test.GolfPlayer;
import org.hibernate.search.elasticsearch.test.Hole;
import org.hibernate.search.elasticsearch.testutil.JsonHelper;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.elasticsearch.testutil.junit.SkipBelowElasticsearch50;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchDateHelper;
import org.hibernate.search.query.engine.spi.QueryDescriptor;
import org.hibernate.search.test.SearchTestBase;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SkipBelowElasticsearch50.class})
public class Elasticsearch5IndexMappingIT
extends SearchTestBase {
    @Rule
    public TestElasticsearchClient elasticsearchClient = new TestElasticsearchClient();

    @Before
    public void setupTestData() {
        Session s = this.openSession();
        Transaction tx = s.beginTransaction();
        Calendar dob = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.ENGLISH);
        dob.set(1958, 3, 7, 0, 0, 0);
        dob.set(14, 0);
        Calendar subscriptionEndDate = GregorianCalendar.getInstance(TimeZone.getTimeZone("Europe/Paris"), Locale.FRENCH);
        subscriptionEndDate.set(2016, 5, 7, 4, 4, 4);
        GolfPlayer hergesheimer = new GolfPlayer.Builder().firstName("Klaus").lastName("Hergesheimer").active(true).dateOfBirth(dob.getTime()).subscriptionEndDate(subscriptionEndDate).handicap(3.4).puttingStrength(2.5).driveWidth(285).strength("precision").strength("willingness").strength("stamina").build();
        s.persist((Object)hergesheimer);
        GolfPlayer galore = new GolfPlayer.Builder().lastName("Galore").ranking(311).build();
        s.persist((Object)galore);
        GolfPlayer kidd = new GolfPlayer.Builder().lastName("Kidd").build();
        s.persist((Object)kidd);
        GolfCourse purbeck = new GolfCourse("Purbeck", 127.3, new Hole(433, 4), new Hole(163, 3));
        s.persist((Object)purbeck);
        GolfCourse mountMaja = new GolfCourse("Mount Maja", 111.9, new Hole(512, 5), new Hole(113, 3));
        s.persist((Object)mountMaja);
        GolfPlayer brand = new GolfPlayer.Builder().lastName("Brand").playedCourses(purbeck, mountMaja).wonCourses(purbeck, mountMaja).build();
        s.persist((Object)brand);
        purbeck.getPlayedBy().add(brand);
        mountMaja.getPlayedBy().add(brand);
        s.persist((Object)brand);
        tx.commit();
        s.close();
    }

    @After
    public void deleteTestData() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match_all' : {} } }");
        List result = session.createFullTextQuery(query, new Class[0]).list();
        for (Object entity : result) {
            session.delete(entity);
        }
        tx.commit();
        s.close();
    }

    @Test
    public void testMapping() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        JsonHelper.assertJsonEquals("{'dynamic':'strict','properties':{'active':{'type':'boolean','null_value':false},'age':{'type':'integer'},'dateOfBirth':{'type':'date','null_value': '" + this.toElasticsearchDateHelperDateString("1970-01-01+00:00") + "'},'driveWidth':{'type':'integer','null_value':-1},'firstName':{'type':'text'},'fullName':{'type':'text'},'fullNameStored':{'type':'keyword','index':false,'store':true},'handicap':{'type':'double'},'id':{'type':'keyword','store':true},'lastName':{'type':'text'},'playedCourses':{'properties':{'holes':{'properties':{'length':{'type':'integer'},'par':{'type':'integer'}}},'name':{'type':'text'},'rating':{'type':'double'}}},'puttingStrength':{'type':'text'},'ranking':{'properties':{'value':{'type':'text'}}},'strengths':{'type':'text'},'subscriptionEndDate':{'type':'date','null_value': '" + this.toElasticsearchDateHelperDateString("1970-01-01+00:00") + "'},'won_holes':{'properties':{'length':{'type':'integer'},'par':{'type':'integer'}}},'won_name':{'type':'text'},'won_rating':{'type':'double'}}}", this.elasticsearchClient.index("golfplayer").type(GolfPlayer.class.getName()).getMapping());
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match' : { 'lastName' : 'Hergesheimer' } } }");
        List result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).setProjection(new String[]{"__HSearch_Source"}).list();
        String source = (String)((Object[])result.iterator().next())[0];
        JsonHelper.assertJsonEqualsIgnoringUnknownFields("{\"active\": true,\"dateOfBirth\": \"1958-04-07T00:00:00Z\",\"subscriptionEndDate\": \"2016-06-07T02:00:00+02:00\",\"driveWidth\": 285,\"firstName\": \"Klaus\",\"handicap\": 3.4,\"lastName\": \"Hergesheimer\",\"fullName\": \"Klaus Hergesheimer\",\"age\": 34,\"puttingStrength\": \"2.5\"}", source);
        tx.commit();
        s.close();
    }

    private String toElasticsearchDateHelperDateString(String string) {
        Date date = ElasticsearchDateHelper.stringToDate((String)string);
        return ElasticsearchDateHelper.dateToString((Date)date);
    }

    @Test
    public void testEmbeddedMapping() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match' : { 'lastName' : 'Galore' } } }");
        List result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).setProjection(new String[]{"__HSearch_Source"}).list();
        String source = (String)((Object[])result.iterator().next())[0];
        JsonHelper.assertJsonEqualsIgnoringUnknownFields("{\"lastName\": \"Galore\",\"ranking\": {\"value\": \"311\"}}", source);
        tx.commit();
        s.close();
    }

    @Test
    public void testElementCollectionOfBasicTypeMapping() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match' : { 'lastName' : 'Hergesheimer' } } }");
        List result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).setProjection(new String[]{"__HSearch_Source"}).list();
        String source = (String)((Object[])result.iterator().next())[0];
        JsonHelper.assertJsonEqualsIgnoringUnknownFields("{\"lastName\": \"Hergesheimer\",\"strengths\": [\"willingness\", \"precision\", \"stamina\"]}", source);
        tx.commit();
        s.close();
    }

    @Test
    public void testEmbeddedListOfEntityMapping() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match' : { 'lastName' : 'Brand' } } }");
        List result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).setProjection(new String[]{"__HSearch_Source"}).list();
        String source = (String)((Object[])result.iterator().next())[0];
        JsonHelper.assertJsonEqualsIgnoringUnknownFields("{'lastName' : 'Brand','playedCourses': [{'name' : 'Purbeck','rating' : 127.3, 'holes': [{ 'par' : 4, 'length' : 433 },{ 'par' : 3, 'length' : 163 }]},{'name' : 'Mount Maja','rating' : 111.9, 'holes': [{ 'par' : 5, 'length' : 512 },{ 'par' : 3, 'length' : 113 }]}],'won_name': ['Purbeck', 'Mount Maja'],'won_rating': [127.3, 111.9],'won_holes': [[{ 'par' : 4, 'length' : 433 },{ 'par' : 3, 'length' : 163 }], [{ 'par' : 5, 'length' : 512 },{ 'par' : 3, 'length' : 113 }]]}", source);
        tx.commit();
        s.close();
    }

    @Test
    public void testEmbeddedListOfEntityWithPrefixMapping() throws Exception {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromJson((String)"{ 'query': { 'match' : { 'lastName' : 'Brand' } } }");
        List result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).setProjection(new String[]{"__HSearch_Source"}).list();
        String source = (String)((Object[])result.iterator().next())[0];
        JsonHelper.assertJsonEqualsIgnoringUnknownFields("{'lastName' : 'Brand','playedCourses': [{'name' : 'Purbeck','rating' : 127.3, 'holes': [{ 'par' : 4, 'length' : 433 },{ 'par' : 3, 'length' : 163 }]},{'name' : 'Mount Maja','rating' : 111.9, 'holes': [{ 'par' : 5, 'length' : 512 },{ 'par' : 3, 'length' : 113 }]}]}", source);
        tx.commit();
        s.close();
    }

    @Test
    public void testNullTokenMapping() {
        Session s = this.openSession();
        FullTextSession session = Search.getFullTextSession((Session)s);
        Transaction tx = s.beginTransaction();
        QueryDescriptor query = ElasticsearchQueries.fromQueryString((String)"lastName:Kidd");
        List result = session.createFullTextQuery(query, new Class[]{GolfPlayer.class}).setProjection(new String[]{"__HSearch_Source"}).list();
        String source = (String)((Object[])result.iterator().next())[0];
        JsonHelper.assertJsonEquals("{\"active\": null,\"dateOfBirth\": null,\"subscriptionEndDate\":null,\"driveWidth\": null,\"firstName\": <NULL>,\"handicap\": 0.0,\"id\": '3',\"puttingStrength\": \"0.0\",\"lastName\": \"Kidd\",\"fullName\": \"Kidd\",\"fullNameStored\": \"Kidd\"}", source);
        tx.commit();
        s.close();
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{GolfPlayer.class, GolfCourse.class, Hole.class};
    }
}

