/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.io.Serializable;
import java.util.List;
import org.apache.lucene.analysis.core.KeywordTokenizerFactory;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.fest.assertions.ObjectAssert;
import org.hibernate.search.analyzer.definition.LuceneAnalysisDefinitionProvider;
import org.hibernate.search.analyzer.definition.LuceneAnalysisDefinitionRegistryBuilder;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Normalizer;
import org.hibernate.search.annotations.NormalizerDef;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.elasticsearch.analyzer.definition.ElasticsearchAnalysisDefinitionProvider;
import org.hibernate.search.elasticsearch.analyzer.definition.ElasticsearchAnalysisDefinitionRegistryBuilder;
import org.hibernate.search.elasticsearch.spi.ElasticsearchIndexManagerType;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.indexes.spi.IndexManagerType;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchIntegratorResource;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.hibernate.search.testsupport.setup.TransactionContextForTest;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

@TestForIssue(jiraKey="HSEARCH-2418")
public class ElasticsearchAnalysisDefinitionProviderIT {
    private static final String CUSTOM_ANALYZER_NAME = "custom-analyzer";
    private static final String CUSTOM_ANALYZER_2_NAME = "custom-analyzer-2";
    private static final String CUSTOM_NORMALIZER_NAME = "custom-normalizer";
    private static final String CUSTOM_NORMALIZER_2_NAME = "custom-normalizer-2";
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public SearchIntegratorResource integratorResource = new SearchIntegratorResource();

    @Test
    public void simple() {
        ExtendedSearchIntegrator integrator = this.init(CustomAnalyzerProvider.class, CustomAnalyzerEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getIntegration((IndexManagerType)ElasticsearchIndexManagerType.INSTANCE).getAnalyzerRegistry().getAnalyzerReference(CUSTOM_ANALYZER_NAME)).as("Analyzer reference for 'custom-analyzer' fetched from the integrator")).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getIntegration((IndexManagerType)ElasticsearchIndexManagerType.INSTANCE).getNormalizerRegistry().getNamedNormalizerReference(CUSTOM_NORMALIZER_NAME)).as("Normalizer reference for 'custom-normalizer' fetched from the integrator")).isNotNull();
        CustomAnalyzerEntity entity = new CustomAnalyzerEntity();
        entity.id = 0L;
        entity.field = "charFilterShouldReplace|foo";
        this.index((SearchIntegrator)integrator, entity);
        this.assertMatchesExactly((SearchIntegrator)integrator, entity, "field", "charfilterdidreplace");
        this.assertMatchesExactly((SearchIntegrator)integrator, entity, "normalized", "charfilterdidreplace|foo");
    }

    @Test
    public void override() {
        ExtendedSearchIntegrator integrator = this.init(CustomAnalyzerProvider.class, AnalyzerDefAnnotationEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getIntegration((IndexManagerType)ElasticsearchIndexManagerType.INSTANCE).getAnalyzerRegistry().getAnalyzerReference(CUSTOM_ANALYZER_NAME)).as("Analyzer reference for 'custom-analyzer' fetched from the integrator")).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getIntegration((IndexManagerType)ElasticsearchIndexManagerType.INSTANCE).getNormalizerRegistry().getNamedNormalizerReference(CUSTOM_NORMALIZER_NAME)).as("Normalizer reference for 'custom-normalizer' fetched from the integrator")).isNotNull();
        AnalyzerDefAnnotationEntity entity = new AnalyzerDefAnnotationEntity();
        entity.id = 0L;
        entity.field = "charFilterShouldReplace|foo";
        this.index((SearchIntegrator)integrator, entity);
        this.assertMatchesExactly((SearchIntegrator)integrator, entity, "field", "charFilterShouldReplace|foo");
        this.assertMatchesExactly((SearchIntegrator)integrator, entity, "normalized", "charfiltershouldreplace|foo");
    }

    @Test
    public void searchFactoryIncrement() {
        MutatingProviderFactory.provider = new CustomAnalyzerProvider();
        ExtendedSearchIntegrator integrator = this.init(MutatingProviderFactory.class, CustomAnalyzerEntity.class);
        MutatingProviderFactory.provider = new CustomAnalyzer2Provider();
        integrator.addClasses(new Class[]{CustomAnalyzer2Entity.class});
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getIntegration((IndexManagerType)ElasticsearchIndexManagerType.INSTANCE).getAnalyzerRegistry().getAnalyzerReference(CUSTOM_ANALYZER_2_NAME)).as("Analyzer reference for 'custom-analyzer-2' fetched from the integrator")).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getIntegration((IndexManagerType)ElasticsearchIndexManagerType.INSTANCE).getNormalizerRegistry().getNamedNormalizerReference(CUSTOM_NORMALIZER_2_NAME)).as("Normalizer reference for 'custom-normalizer-2' fetched from the integrator")).isNotNull();
        CustomAnalyzer2Entity entity = new CustomAnalyzer2Entity();
        entity.id = 0L;
        entity.field = "Foo bar";
        this.index((SearchIntegrator)integrator, entity);
        this.assertMatchesExactly((SearchIntegrator)integrator, entity, "field", "Foo");
        this.assertMatchesExactly((SearchIntegrator)integrator, entity, "normalized", "foo bar");
    }

    @Test
    public void unreferencedAnalyzer() {
        ExtendedSearchIntegrator integrator = this.init(CustomAnalyzerProvider.class, NoAnalyzerEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getIntegration((IndexManagerType)ElasticsearchIndexManagerType.INSTANCE).getAnalyzerRegistry().getAnalyzerReference(CUSTOM_ANALYZER_NAME)).as("Analyzer reference for 'custom-analyzer' fetched from the integrator")).isNotNull();
    }

    @Test
    public void instantiation_factorymethod() {
        ExtendedSearchIntegrator integrator = this.init(ProviderFactory.class, CustomAnalyzerEntity.class);
        ((ObjectAssert)Assertions.assertThat((Object)integrator.getIntegration((IndexManagerType)ElasticsearchIndexManagerType.INSTANCE).getAnalyzerRegistry().getAnalyzerReference(CUSTOM_ANALYZER_NAME)).as("Analyzer reference for 'custom-analyzer' fetched from the integrator")).isNotNull();
    }

    @Test
    public void invalid_notAClass() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(CustomAnalyzerEntity.class);
        cfg.addProperty("hibernate.search.elasticsearch.analysis_definition_provider", "invalidValue");
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400075");
        this.integratorResource.create((SearchConfiguration)cfg);
    }

    @Test
    public void invalid_luceneProvider() {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        cfg.addClass(CustomAnalyzerEntity.class);
        cfg.addProperty("hibernate.search.elasticsearch.analysis_definition_provider", LuceneAnalyzerDefinitionProviderImpl.class.getName());
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400075");
        this.integratorResource.create((SearchConfiguration)cfg);
    }

    @Test
    public void namingConflict_withinProvider_analyzer() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400074");
        this.init(ProviderWithInternalAnalyzerNamingConflict.class, CustomAnalyzerEntity.class);
    }

    @Test
    public void namingConflict_withinProvider_normalizer() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400086");
        this.init(ProviderWithInternalNormalizerNamingConflict.class, CustomAnalyzerEntity.class);
    }

    @Test
    public void namingConflict_withinProvider_tokenizer() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400055");
        this.init(ProviderWithInternalTokenizerNamingConflict.class, CustomAnalyzerEntity.class);
    }

    @Test
    public void namingConflict_withinProvider_charFilter() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400056");
        this.init(ProviderWithInternalCharFilterNamingConflict.class, CustomAnalyzerEntity.class);
    }

    @Test
    public void namingConflict_withinProvider_tokenFilter() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH400057");
        this.init(ProviderWithInternalTokenFilterNamingConflict.class, CustomAnalyzerEntity.class);
    }

    private ExtendedSearchIntegrator init(Class<?> providerClass, Class<?> ... entityClasses) {
        SearchConfigurationForTest cfg = new SearchConfigurationForTest();
        for (Class<?> entityClass : entityClasses) {
            cfg.addClass(entityClass);
        }
        cfg.addProperty("hibernate.search.elasticsearch.analysis_definition_provider", providerClass.getName());
        return this.integratorResource.create((SearchConfiguration)cfg);
    }

    private void index(SearchIntegrator integrator, Identifiable entity) {
        Work work = new Work((Object)entity, (Serializable)Long.valueOf(entity.getId()), WorkType.ADD, false);
        TransactionContextForTest tc = new TransactionContextForTest();
        integrator.getWorker().performWork(work, (TransactionContext)tc);
        tc.end();
    }

    private void assertMatchesExactly(SearchIntegrator integrator, Identifiable entity, String fieldName, String termValue) {
        this.assertMatchesExactly(integrator, entity, (Query)new TermQuery(new Term(fieldName, termValue)));
    }

    private void assertMatchesExactly(SearchIntegrator integrator, Identifiable entity, Query luceneQuery) {
        Class<?> entityClass = entity.getClass();
        HSQuery query = integrator.createHSQuery(luceneQuery, new Class[]{entityClass});
        List results = query.queryEntityInfos();
        ((ListAssert)Assertions.assertThat((List)results).onProperty("id").as("Results of query '" + luceneQuery + "' on " + entityClass.getSimpleName())).containsExactly(new Object[]{entity.getId()});
    }

    public static class LuceneAnalyzerDefinitionProviderImpl
    implements LuceneAnalysisDefinitionProvider {
        public void register(LuceneAnalysisDefinitionRegistryBuilder builder) {
        }
    }

    public static class ProviderWithInternalTokenFilterNamingConflict
    implements ElasticsearchAnalysisDefinitionProvider {
        public void register(ElasticsearchAnalysisDefinitionRegistryBuilder builder) {
            builder.tokenFilter("foo").type("standard");
            builder.tokenFilter("foo").type("standard");
        }
    }

    public static class ProviderWithInternalCharFilterNamingConflict
    implements ElasticsearchAnalysisDefinitionProvider {
        public void register(ElasticsearchAnalysisDefinitionRegistryBuilder builder) {
            builder.charFilter("foo").type("standard");
            builder.charFilter("foo").type("standard");
        }
    }

    public static class ProviderWithInternalTokenizerNamingConflict
    implements ElasticsearchAnalysisDefinitionProvider {
        public void register(ElasticsearchAnalysisDefinitionRegistryBuilder builder) {
            builder.tokenizer("foo").type("standard");
            builder.tokenizer("foo").type("standard");
        }
    }

    public static class ProviderWithInternalNormalizerNamingConflict
    implements ElasticsearchAnalysisDefinitionProvider {
        public void register(ElasticsearchAnalysisDefinitionRegistryBuilder builder) {
            builder.normalizer(ElasticsearchAnalysisDefinitionProviderIT.CUSTOM_NORMALIZER_NAME);
            builder.normalizer(ElasticsearchAnalysisDefinitionProviderIT.CUSTOM_NORMALIZER_NAME);
        }
    }

    public static class ProviderWithInternalAnalyzerNamingConflict
    implements ElasticsearchAnalysisDefinitionProvider {
        public void register(ElasticsearchAnalysisDefinitionRegistryBuilder builder) {
            builder.analyzer(ElasticsearchAnalysisDefinitionProviderIT.CUSTOM_ANALYZER_NAME).withTokenizer("standard");
            builder.analyzer(ElasticsearchAnalysisDefinitionProviderIT.CUSTOM_ANALYZER_NAME).withTokenizer("standard");
        }
    }

    public static class MutatingProviderFactory {
        private static ElasticsearchAnalysisDefinitionProvider provider;

        @Factory
        public static ElasticsearchAnalysisDefinitionProvider create() {
            return provider;
        }
    }

    public static class CustomAnalyzer2Provider
    implements ElasticsearchAnalysisDefinitionProvider {
        public void register(ElasticsearchAnalysisDefinitionRegistryBuilder builder) {
            builder.analyzer(ElasticsearchAnalysisDefinitionProviderIT.CUSTOM_ANALYZER_2_NAME).withTokenizer("myPattern2");
            builder.tokenizer("myPattern2").type("pattern").param("pattern", " ");
            builder.normalizer(ElasticsearchAnalysisDefinitionProviderIT.CUSTOM_NORMALIZER_2_NAME).withTokenFilters(new String[]{"lowercase"});
        }
    }

    public static class ProviderFactory {
        @Factory
        public static CustomAnalyzerProvider create() {
            return new CustomAnalyzerProvider();
        }
    }

    public static class CustomAnalyzerProvider
    implements ElasticsearchAnalysisDefinitionProvider {
        public void register(ElasticsearchAnalysisDefinitionRegistryBuilder builder) {
            builder.analyzer(ElasticsearchAnalysisDefinitionProviderIT.CUSTOM_ANALYZER_NAME).withTokenizer("myPattern").withCharFilters(new String[]{"myPattern"}).withTokenFilters(new String[]{"myLowerCase"});
            builder.normalizer(ElasticsearchAnalysisDefinitionProviderIT.CUSTOM_NORMALIZER_NAME).withCharFilters(new String[]{"myMapping"}).withTokenFilters(new String[]{"myLowerCase"});
            builder.tokenizer("myPattern").type("pattern").param("pattern", "\\|");
            builder.charFilter("myMapping").type("mapping").param("mappings", "charFilterShouldReplace => charFilterDidReplace");
            builder.charFilter("myPattern").type("pattern_replace").param("pattern", "charFilterShouldReplace").param("replacement", "charFilterDidReplace");
            builder.tokenFilter("myLowerCase").type("lowercase");
        }
    }

    @Indexed
    static class CustomAnalyzer2Entity
    implements Identifiable {
        @DocumentId
        long id;
        @Fields(value={@Field(analyzer=@Analyzer(definition="custom-analyzer-2")), @Field(name="normalized", normalizer=@Normalizer(definition="custom-normalizer-2"))})
        String field;

        CustomAnalyzer2Entity() {
        }

        @Override
        public long getId() {
            return this.id;
        }
    }

    @Indexed
    @AnalyzerDef(name="custom-analyzer", tokenizer=@TokenizerDef(factory=KeywordTokenizerFactory.class))
    @NormalizerDef(name="custom-normalizer", filters={@TokenFilterDef(factory=LowerCaseFilterFactory.class)})
    static class AnalyzerDefAnnotationEntity
    extends CustomAnalyzerEntity {
        AnalyzerDefAnnotationEntity() {
        }
    }

    @Indexed
    static class CustomAnalyzerEntity
    implements Identifiable {
        @DocumentId
        long id;
        @Fields(value={@Field(analyzer=@Analyzer(definition="custom-analyzer")), @Field(name="normalized", normalizer=@Normalizer(definition="custom-normalizer"))})
        String field;

        CustomAnalyzerEntity() {
        }

        @Override
        public long getId() {
            return this.id;
        }
    }

    @Indexed
    static class NoAnalyzerEntity
    implements Identifiable {
        @DocumentId
        long id;
        @Field(analyze=Analyze.NO)
        String field;

        NoAnalyzerEntity() {
        }

        @Override
        public long getId() {
            return this.id;
        }
    }

    private static interface Identifiable {
        public long getId();
    }
}

