/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.EnumSet;
import java.util.HashMap;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.apache.lucene.analysis.charfilter.HTMLStripCharFilterFactory;
import org.apache.lucene.analysis.core.LowerCaseFilterFactory;
import org.apache.lucene.analysis.core.WhitespaceTokenizerFactory;
import org.apache.lucene.analysis.miscellaneous.WordDelimiterFilterFactory;
import org.apache.lucene.analysis.standard.ClassicTokenizerFactory;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.CharFilterDef;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.elasticsearch.analyzer.ElasticsearchCharFilterFactory;
import org.hibernate.search.elasticsearch.analyzer.ElasticsearchTokenFilterFactory;
import org.hibernate.search.elasticsearch.analyzer.ElasticsearchTokenizerFactory;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.testutil.JsonHelper;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.TestConfiguration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ElasticsearchAnalyzerDefinitionCreationIT
extends SearchInitializationTestBase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TestElasticsearchClient elasticSearchClient = new TestElasticsearchClient();
    private final IndexSchemaManagementStrategy strategy;

    @Parameterized.Parameters(name="With strategy {0}")
    public static EnumSet<IndexSchemaManagementStrategy> strategies() {
        return EnumSet.complementOf(EnumSet.of(IndexSchemaManagementStrategy.NONE, IndexSchemaManagementStrategy.VALIDATE));
    }

    public ElasticsearchAnalyzerDefinitionCreationIT(IndexSchemaManagementStrategy strategy) {
        this.strategy = strategy;
    }

    protected void init(Class<?> ... annotatedClasses) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("hibernate.search.default.elasticsearch.index_schema_management_strategy", this.strategy.getExternalName());
        this.init((TestConfiguration)new ImmutableTestConfiguration(settings, (Class[])annotatedClasses));
    }

    @Test
    public void success_simple() throws Exception {
        this.elasticSearchClient.index(SimpleAnalyzedEntity.class).ensureDoesNotExist().registerForCleanup();
        this.init(SimpleAnalyzedEntity.class);
        JsonHelper.assertJsonEquals("{'analyzer': {'analyzerWithSimpleComponents': {'char_filter': ['html_strip'],'tokenizer': 'whitespace','filter': ['lowercase']},'analyzerWithNamedSimpleComponents': {'char_filter': ['namedCharFilter'],'tokenizer': 'namedTokenizer','filter': ['namedTokenFilter']},'analyzerWithComplexComponents': {'char_filter': ['analyzerWithComplexComponents_HTMLStripCharFilterFactory'],'tokenizer': 'classic','filter': ['analyzerWithComplexComponents_WordDelimiterFilterFactory']},'analyzerWithNamedComplexComponents': {'char_filter': ['custom-html-stripper'],'tokenizer': 'custom-classic-tokenizer','filter': ['custom-word-delimiter']},'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types']}},'char_filter': {'namedCharFilter': {'type': 'html_strip'},'analyzerWithComplexComponents_HTMLStripCharFilterFactory': {'type': 'html_strip','escaped_tags': ['br', 'p']},'custom-html-stripper': {'type': 'html_strip','escaped_tags': ['br', 'p']},'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'namedTokenizer': {'type': 'whitespace'},'custom-classic-tokenizer': {'type': 'classic'},'custom-edgeNGram': {'type': 'edgeNGram','min_gram': '1','max_gram': '10'}},'filter': {'namedTokenFilter': {'type': 'lowercase'},'analyzerWithComplexComponents_WordDelimiterFilterFactory': {'type': 'word_delimiter','generate_word_parts': 'true','generate_number_parts': 'true','catenate_words': 'false','catenate_numbers': 'false','catenate_all': 'false','split_on_case_change': 'false','split_on_numerics': 'false','preserve_original': 'true'},'custom-word-delimiter': {'type': 'word_delimiter','generate_word_parts': 'true','generate_number_parts': 'true','catenate_words': 'false','catenate_numbers': 'false','catenate_all': 'false','split_on_case_change': 'false','split_on_numerics': 'false','preserve_original': 'true'},'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}", this.elasticSearchClient.index(SimpleAnalyzedEntity.class).settings("index.analysis").get());
    }

    @Indexed
    @Entity
    @AnalyzerDefs(value={@AnalyzerDef(name="analyzerWithSimpleComponents", charFilters={@CharFilterDef(factory=HTMLStripCharFilterFactory.class)}, tokenizer=@TokenizerDef(factory=WhitespaceTokenizerFactory.class), filters={@TokenFilterDef(factory=LowerCaseFilterFactory.class)}), @AnalyzerDef(name="analyzerWithNamedSimpleComponents", charFilters={@CharFilterDef(name="namedCharFilter", factory=HTMLStripCharFilterFactory.class)}, tokenizer=@TokenizerDef(name="namedTokenizer", factory=WhitespaceTokenizerFactory.class), filters={@TokenFilterDef(name="namedTokenFilter", factory=LowerCaseFilterFactory.class)}), @AnalyzerDef(name="analyzerWithComplexComponents", charFilters={@CharFilterDef(factory=HTMLStripCharFilterFactory.class, params={@Parameter(name="escapedTags", value="br p")})}, tokenizer=@TokenizerDef(factory=ClassicTokenizerFactory.class), filters={@TokenFilterDef(factory=WordDelimiterFilterFactory.class, params={@Parameter(name="generateWordParts", value="1"), @Parameter(name="generateNumberParts", value="1"), @Parameter(name="catenateWords", value="0"), @Parameter(name="catenateNumbers", value="0"), @Parameter(name="catenateAll", value="0"), @Parameter(name="splitOnCaseChange", value="0"), @Parameter(name="splitOnNumerics", value="0"), @Parameter(name="preserveOriginal", value="1")})}), @AnalyzerDef(name="analyzerWithNamedComplexComponents", charFilters={@CharFilterDef(name="custom-html-stripper", factory=HTMLStripCharFilterFactory.class, params={@Parameter(name="escapedTags", value="br p")})}, tokenizer=@TokenizerDef(name="custom-classic-tokenizer", factory=ClassicTokenizerFactory.class), filters={@TokenFilterDef(name="custom-word-delimiter", factory=WordDelimiterFilterFactory.class, params={@Parameter(name="generateWordParts", value="1"), @Parameter(name="generateNumberParts", value="1"), @Parameter(name="catenateWords", value="0"), @Parameter(name="catenateNumbers", value="0"), @Parameter(name="catenateAll", value="0"), @Parameter(name="splitOnCaseChange", value="0"), @Parameter(name="splitOnNumerics", value="0"), @Parameter(name="preserveOriginal", value="1")})}), @AnalyzerDef(name="analyzerWithElasticsearchFactories", charFilters={@CharFilterDef(name="custom-pattern-replace", factory=ElasticsearchCharFilterFactory.class, params={@Parameter(name="type", value="'pattern_replace'"), @Parameter(name="pattern", value="'[^0-9]'"), @Parameter(name="replacement", value="'0'"), @Parameter(name="tags", value="'CASE_INSENSITIVE|COMMENTS'")})}, tokenizer=@TokenizerDef(name="custom-edgeNGram", factory=ElasticsearchTokenizerFactory.class, params={@Parameter(name="type", value="'edgeNGram'"), @Parameter(name="min_gram", value="1"), @Parameter(name="max_gram", value="10")}), filters={@TokenFilterDef(name="custom-keep-types", factory=ElasticsearchTokenFilterFactory.class, params={@Parameter(name="type", value="'keep_types'"), @Parameter(name="types", value="['<NUM>','<DOUBLE>']")})})})
    private static class SimpleAnalyzedEntity {
        @DocumentId
        @Id
        Long id;
        @Fields(value={@Field(name="myField1", analyzer=@Analyzer(definition="analyzerWithSimpleComponents")), @Field(name="myField2", analyzer=@Analyzer(definition="analyzerWithNamedSimpleComponents")), @Field(name="myField3", analyzer=@Analyzer(definition="analyzerWithComplexComponents")), @Field(name="myField4", analyzer=@Analyzer(definition="analyzerWithNamedComplexComponents")), @Field(name="myField5", analyzer=@Analyzer(definition="analyzerWithElasticsearchFactories"))})
        String myField;

        private SimpleAnalyzedEntity() {
        }
    }
}

