/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.util.HashMap;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizerFactory;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.CharFilterDef;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Parameter;
import org.hibernate.search.annotations.TokenFilterDef;
import org.hibernate.search.annotations.TokenizerDef;
import org.hibernate.search.elasticsearch.analyzer.ElasticsearchCharFilterFactory;
import org.hibernate.search.elasticsearch.analyzer.ElasticsearchTokenFilterFactory;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.testutil.JsonHelper;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.elasticsearch.testutil.junit.SkipOnAWS;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.hibernate.search.test.util.ImmutableTestConfiguration;
import org.hibernate.search.test.util.TestConfiguration;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={SkipOnAWS.class})
public class ElasticsearchAnalyzerDefinitionMigrationIT
extends SearchInitializationTestBase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    @Rule
    public TestElasticsearchClient elasticSearchClient = new TestElasticsearchClient();

    protected void init(Class<?> ... annotatedClasses) {
        HashMap<String, String> settings = new HashMap<String, String>();
        settings.put("hibernate.search.default.elasticsearch.index_schema_management_strategy", IndexSchemaManagementStrategy.UPDATE.getExternalName());
        this.init((TestConfiguration)new ImmutableTestConfiguration(settings, (Class[])annotatedClasses));
    }

    @Test
    public void nothingToDo() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate("index.analysis", "{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': '1','max_gram': '10'}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}");
        this.init(AnalyzedEntity.class);
        JsonHelper.assertJsonEquals("{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': '1','max_gram': '10'}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}", this.elasticSearchClient.index(AnalyzedEntity.class).settings("index.analysis").get());
    }

    @Test
    public void analyzer_missing() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate("index.analysis", "{'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}");
        this.init(AnalyzedEntity.class);
        JsonHelper.assertJsonEquals("{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': '1','max_gram': '10'}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}", this.elasticSearchClient.index(AnalyzedEntity.class).settings("index.analysis").get());
    }

    @Test
    public void analyzer_componentDefinition_missing() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate("index.analysis", "{'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}");
        this.init(AnalyzedEntity.class);
        JsonHelper.assertJsonEquals("{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': '1','max_gram': '10'}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}", this.elasticSearchClient.index(AnalyzedEntity.class).settings("index.analysis").get());
    }

    @Test
    public void analyzer_componentReference_invalid() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate("index.analysis", "{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['html_strip'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}");
        this.init(AnalyzedEntity.class);
        JsonHelper.assertJsonEquals("{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': '1','max_gram': '10'}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}", this.elasticSearchClient.index(AnalyzedEntity.class).settings("index.analysis").get());
    }

    @Test
    public void analyzer_componentDefinition_invalid() throws Exception {
        this.elasticSearchClient.index(AnalyzedEntity.class).deleteAndCreate("index.analysis", "{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types']}},'char_filter': {'custom-pattern-replace': {'type': 'html_strip'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': 1,'max_gram': 10}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}");
        this.init(AnalyzedEntity.class);
        JsonHelper.assertJsonEquals("{'analyzer': {'analyzerWithElasticsearchFactories': {'char_filter': ['custom-pattern-replace'],'tokenizer': 'custom-edgeNGram','filter': ['custom-keep-types']}},'char_filter': {'custom-pattern-replace': {'type': 'pattern_replace','pattern': '[^0-9]','replacement': '0','tags': 'CASE_INSENSITIVE|COMMENTS'}},'tokenizer': {'custom-edgeNGram': {'type': 'edgeNGram','min_gram': '1','max_gram': '10'}},'filter': {'custom-keep-types': {'type': 'keep_types','types': ['<NUM>', '<DOUBLE>']}}}", this.elasticSearchClient.index(AnalyzedEntity.class).settings("index.analysis").get());
    }

    @Indexed
    @Entity
    @AnalyzerDef(name="analyzerWithElasticsearchFactories", charFilters={@CharFilterDef(name="custom-pattern-replace", factory=ElasticsearchCharFilterFactory.class, params={@Parameter(name="type", value="'pattern_replace'"), @Parameter(name="pattern", value="'[^0-9]'"), @Parameter(name="replacement", value="'0'"), @Parameter(name="tags", value="'CASE_INSENSITIVE|COMMENTS'")})}, tokenizer=@TokenizerDef(name="custom-edgeNGram", factory=EdgeNGramTokenizerFactory.class, params={@Parameter(name="minGramSize", value="1"), @Parameter(name="maxGramSize", value="10")}), filters={@TokenFilterDef(name="custom-keep-types", factory=ElasticsearchTokenFilterFactory.class, params={@Parameter(name="type", value="'keep_types'"), @Parameter(name="types", value="['<NUM>','<DOUBLE>']")})})
    public static class AnalyzedEntity {
        @DocumentId
        @Id
        Long id;
        @Field(analyzer=@Analyzer(definition="analyzerWithElasticsearchFactories"))
        String myField;
    }
}

