/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import com.google.gson.JsonParser;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.fest.assertions.Assertions;
import org.fest.assertions.ListAssert;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.test.SearchTestBase;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class ElasticsearchAnalyzerIT
extends SearchTestBase {
    @Rule
    public TestElasticsearchClient elasticsearchClient = new TestElasticsearchClient();

    @Before
    public void setUp() throws Exception {
        this.elasticsearchClient.template("server-defined-custom-analyzer").create("*", new JsonParser().parse("{'index': {'analysis': {'analyzer': {'server-defined-custom-analyzer': {'char_filter': ['html_strip'],'tokenizer': 'standard','filter': ['server-defined-custom-filter', 'lowercase']}},'filter': {'server-defined-custom-filter': {'type': 'stop','stopwords': ['test1', 'close']}}}}}").getAsJsonObject());
        super.setUp();
    }

    @Test
    public void testDefaultAnalyzer() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Tweet tweet = new Tweet();
            tweet.setDefaultTweet("the Foxes");
            this.tweet(session, tweet);
            TermQuery query = new TermQuery(new Term("defaultTweet", "fox"));
            List list = fullTextSession.createFullTextQuery((Query)query, new Class[0]).list();
            ((ListAssert)Assertions.assertThat((List)list).as("It should not find the tweet without a defined analyzer")).isEmpty();
        }
    }

    @Test
    public void testEnglishBuiltInAnalyzer() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Tweet tweet = new Tweet();
            tweet.setEnglishTweet("the Foxes");
            this.tweet(session, tweet);
            TermQuery query = new TermQuery(new Term("englishTweet", "fox"));
            List list = fullTextSession.createFullTextQuery((Query)query, new Class[0]).list();
            Assertions.assertThat((List)list).onProperty("englishTweet").containsExactly(new Object[]{tweet.getEnglishTweet()});
        }
    }

    @Test
    public void testWhitespaceBuiltInAnalyzer() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Tweet tweet = new Tweet();
            tweet.setWhitespaceTweet("What does the fox say?");
            this.tweet(session, tweet);
            TermQuery query = new TermQuery(new Term("whitespaceTweet", "fox"));
            List list = fullTextSession.createFullTextQuery((Query)query, new Class[]{Tweet.class}).list();
            Assertions.assertThat((List)list).onProperty("whitespaceTweet").containsExactly(new Object[]{tweet.getWhitespaceTweet()});
        }
    }

    @Test
    public void testCustomAnalyzer() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Tweet tweet = new Tweet();
            tweet.setCustomTweet("close OPEN SOURCE test1");
            this.tweet(session, tweet);
            List expectedResult = fullTextSession.createFullTextQuery((Query)this.termQuery("customTweet", "open"), new Class[]{Tweet.class}).list();
            Assertions.assertThat((List)expectedResult).onProperty("customTweet").containsExactly(new Object[]{tweet.getCustomTweet()});
            List expectedEmpty = fullTextSession.createFullTextQuery((Query)this.termQuery("customTweet", "CLOSE"), new Class[]{Tweet.class}).list();
            ((ListAssert)Assertions.assertThat((List)expectedEmpty).as("Custom analyzer or filter not applied")).isEmpty();
        }
    }

    @Test
    public void testMultipleFieldsCustomAnalyzer() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Tweet tweet = new Tweet();
            tweet.setMultipleTweets("close OPEN SOURCE test1");
            this.tweet(session, tweet);
            List expectedResult = fullTextSession.createFullTextQuery((Query)this.termQuery("tweetWithCustom", "open"), new Class[]{Tweet.class}).list();
            Assertions.assertThat((List)expectedResult).onProperty("multipleTweets").containsExactly(new Object[]{tweet.getMultipleTweets()});
            List expectedEmpty = fullTextSession.createFullTextQuery((Query)this.termQuery("tweetWithCustom", "CLOSE"), new Class[]{Tweet.class}).list();
            ((ListAssert)Assertions.assertThat((List)expectedEmpty).as("Custom analyzer or filter not applied")).isEmpty();
        }
    }

    @Test
    public void testMultipleFieldIgnoreAnalyzer() throws Exception {
        try (Session session = this.openSession();){
            FullTextSession fullTextSession = Search.getFullTextSession((Session)session);
            Tweet tweet = new Tweet();
            tweet.setMultipleTweets("close OPEN SOURCE test1");
            this.tweet(session, tweet);
            List expectedResult = fullTextSession.createFullTextQuery((Query)this.termQuery("tweetNotAnalyzed", "close OPEN SOURCE test1"), new Class[]{Tweet.class}).list();
            Assertions.assertThat((List)expectedResult).onProperty("multipleTweets").containsExactly(new Object[]{tweet.getMultipleTweets()});
        }
    }

    private TermQuery termQuery(String fld, String text) {
        TermQuery query = new TermQuery(new Term(fld, text));
        return query;
    }

    private void tweet(Session session, Tweet tweet) {
        Transaction tx = session.beginTransaction();
        session.persist((Object)tweet);
        tx.commit();
        session.clear();
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Tweet.class};
    }

    @Entity
    @Indexed(index="tweet")
    public static class Tweet {
        @Id
        @GeneratedValue
        private Integer id;
        @Field
        @Analyzer(definition="english")
        private String englishTweet;
        @Field
        @Analyzer(definition="whitespace")
        private String whitespaceTweet;
        @Field
        @Analyzer(definition="server-defined-custom-analyzer")
        private String customTweet;
        @Fields(value={@Field(name="tweetNotAnalyzed", analyze=Analyze.NO, store=Store.YES), @Field(name="tweetWithCustom", analyzer=@Analyzer(definition="server-defined-custom-analyzer"))})
        private String multipleTweets;
        private String defaultAnalyzer;

        public Integer getId() {
            return this.id;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public String getEnglishTweet() {
            return this.englishTweet;
        }

        public void setEnglishTweet(String englishTweet) {
            this.englishTweet = englishTweet;
        }

        public String getWhitespaceTweet() {
            return this.whitespaceTweet;
        }

        public void setWhitespaceTweet(String whitespaceTweet) {
            this.whitespaceTweet = whitespaceTweet;
        }

        public String getCustomTweet() {
            return this.customTweet;
        }

        public void setCustomTweet(String customTweet) {
            this.customTweet = customTweet;
        }

        public String getDefaultAnalyzer() {
            return this.defaultAnalyzer;
        }

        public void setDefaultTweet(String defaultAnalyzer) {
            this.defaultAnalyzer = defaultAnalyzer;
        }

        public String getMultipleTweets() {
            return this.multipleTweets;
        }

        public void setMultipleTweets(String multipleMessage) {
            this.multipleTweets = multipleMessage;
        }

        public String toString() {
            return "[" + this.englishTweet + ", " + this.whitespaceTweet + "]";
        }
    }
}

