/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.io.IOException;
import java.io.Serializable;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.elasticsearch.cfg.IndexSchemaManagementStrategy;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.hibernate.search.spi.DefaultInstanceInitializer;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.impl.IndexedTypeSets;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.hibernate.search.testsupport.TestForIssue;
import org.hibernate.search.testsupport.junit.SearchFactoryHolder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;

public class ElasticsearchFlushIT {
    @Rule
    public SearchFactoryHolder sfHolder = new SearchFactoryHolder(new Class[]{Entity1.class, Entity2.class}).withProperty("hibernate.search.default.indexmanager", (Object)"elasticsearch").withProperty("hibernate.search.default.elasticsearch.refresh_after_write", (Object)"false").withProperty("hibernate.search.default.elasticsearch.index_schema_management_strategy", (Object)IndexSchemaManagementStrategy.DROP_AND_CREATE_AND_DROP.getExternalName()).withIdProvidedImplicit(true);
    @Rule
    public TestElasticsearchClient elasticsearchClient = new TestElasticsearchClient();

    @Test
    @TestForIssue(jiraKey="HSEARCH-2491")
    public void testFlushByEntity() throws Exception {
        this.increaseRefreshTime(Entity1.class, Entity2.class);
        Entity1 entity1 = new Entity1(1);
        Entity2 entity2 = new Entity2(1);
        this.indexAsStream((Serializable)((Object)"E1:1"), entity1);
        this.indexAsStream((Serializable)((Object)"E2:1"), entity2);
        this.assertIndexed(Entity1.class, 0);
        this.assertIndexed(Entity2.class, 0);
        this.flush(Entity1.class);
        this.assertIndexed(Entity1.class, 1);
        this.assertIndexed(Entity2.class, 0);
        this.flush(Entity2.class);
        this.assertIndexed(Entity1.class, 1);
        this.assertIndexed(Entity2.class, 1);
    }

    private void increaseRefreshTime(Class<?> ... indexes) throws IOException {
        for (Class<?> index : indexes) {
            this.elasticsearchClient.index(index).settings("index.refresh_interval").putDynamic("'3600s'");
            this.elasticsearchClient.index(index).waitForRequiredIndexStatus();
        }
    }

    private void flush(Class<?> clazz) {
        this.sfHolder.getBatchBackend().flush(IndexedTypeSets.fromClass(clazz));
    }

    private void indexAsStream(Serializable id, Object entity) throws InterruptedException {
        LuceneWork work = this.createUpdateWork(id, entity);
        this.sfHolder.getBatchBackend().enqueueAsyncWork(work);
    }

    private LuceneWork createUpdateWork(Serializable id, Object entity) {
        Class<?> clazz = entity.getClass();
        PojoIndexedTypeIdentifier typeId = new PojoIndexedTypeIdentifier(clazz);
        ExtendedSearchIntegrator searchFactory = this.sfHolder.getSearchFactory();
        EntityIndexBinding entityIndexBinding = searchFactory.getIndexBinding((IndexedTypeIdentifier)typeId);
        DocumentBuilderIndexedEntity docBuilder = entityIndexBinding.getDocumentBuilder();
        return docBuilder.createUpdateWork(null, (IndexedTypeIdentifier)typeId, entity, id, id.toString(), DefaultInstanceInitializer.DEFAULT_INITIALIZER, (ConversionContext)new ContextualExceptionBridgeHelper());
    }

    private void assertIndexed(Class<?> entity, int count) {
        HSQuery hsQuery = this.sfHolder.getSearchFactory().createHSQuery((Query)new MatchAllDocsQuery(), new Class[]{entity});
        Assert.assertEquals((long)count, (long)hsQuery.queryResultSize());
    }

    @Indexed
    private static class Entity2 {
        @Field
        private int id;

        Entity2(int id) {
            this.id = id;
        }
    }

    @Indexed
    private static class Entity1 {
        @Field
        private int id;

        Entity1(int id) {
            this.id = id;
        }
    }
}

