/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexNameNormalizer;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.test.SearchInitializationTestBase;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ElasticsearchIndexNameConflictIT
extends SearchInitializationTestBase {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testNameCollisionDetection() {
        this.thrown.expect(SearchException.class);
        this.thrown.expectMessage("HSEARCH000326");
        this.thrown.expectMessage("MYFIRSTENTITY");
        this.thrown.expectMessage("myfirstentity");
        this.thrown.expectMessage(ElasticsearchIndexNameNormalizer.getElasticsearchIndexName((String)"myfirstentity").original);
        this.init(new Class[]{MyFirstEntityUpperCase.class, MyfirstEntityLowerCase.class});
    }

    @Test
    public void testWithoutConflictWhenIndexIsRenamed() {
        this.init(new Class[]{MySecondEntityUpperCase.class, MysecondEntityLowerCase.class});
    }

    @Indexed(index="mysecondentityWithPostfix")
    @Entity
    static class MysecondEntityLowerCase {
        @DocumentId
        @Id
        Long id;
        @Field
        boolean myField;

        MysecondEntityLowerCase() {
        }
    }

    @Indexed(index="MYSECONDENTITY")
    @Entity
    static class MySecondEntityUpperCase {
        @DocumentId
        @Id
        Long id;
        @Field
        boolean myField;

        MySecondEntityUpperCase() {
        }
    }

    @Indexed(index="myfirstentity")
    @Entity
    static class MyfirstEntityLowerCase {
        @DocumentId
        @Id
        Long id;
        @Field
        boolean myField;

        MyfirstEntityLowerCase() {
        }
    }

    @Indexed(index="MYFIRSTENTITY")
    @Entity
    static class MyFirstEntityUpperCase {
        @DocumentId
        @Id
        Long id;
        @Field
        boolean myField;

        MyFirstEntityUpperCase() {
        }
    }
}

