/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.SequenceGenerator;
import org.hibernate.search.annotations.CalendarBridge;
import org.hibernate.search.annotations.ClassBridge;
import org.hibernate.search.annotations.ClassBridges;
import org.hibernate.search.annotations.DateBridge;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Resolution;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.builtin.DoubleBridge;
import org.hibernate.search.elasticsearch.test.AgeBridge;
import org.hibernate.search.elasticsearch.test.GolfCourse;
import org.hibernate.search.elasticsearch.test.NameConcatenationBridge;
import org.hibernate.search.elasticsearch.test.Ranking;

@Entity
@Indexed(index="golfplayer")
@ClassBridges(value={@ClassBridge(name="fullName", impl=NameConcatenationBridge.class), @ClassBridge(name="fullNameStored", index=Index.NO, store=Store.YES, impl=NameConcatenationBridge.class), @ClassBridge(name="age", impl=AgeBridge.class)})
public class GolfPlayer {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="GOLF_PLAYER_SEQ")
    @SequenceGenerator(name="GOLF_PLAYER_SEQ", sequenceName="golfplayer_sequence", allocationSize=20)
    @DocumentId
    private Long id;
    @Field(indexNullAs="<NULL>")
    private String firstName;
    @Field
    private String lastName;
    @Field(indexNullAs="false")
    private Boolean active;
    @Field(indexNullAs="1970-01-01+00:00")
    @DateBridge(resolution=Resolution.DAY)
    private Date dateOfBirth;
    @Field(indexNullAs="1970-01-01+00:00")
    @CalendarBridge(resolution=Resolution.DAY)
    private Calendar subscriptionEndDate;
    @Field
    private double handicap;
    @Field(bridge=@FieldBridge(impl=DoubleBridge.class))
    private double puttingStrength;
    @Field(indexNullAs="-1")
    private Integer driveWidth;
    @IndexedEmbedded
    private Ranking ranking;
    @ElementCollection
    @Field
    @IndexedEmbedded
    private Set<String> strengths;
    @ManyToMany
    @JoinTable(name="golfPlayer_playedCourses")
    @IndexedEmbedded
    private Set<GolfCourse> playedCourses;
    @ManyToMany
    @JoinTable(name="golfPlayer_wonCourses")
    @IndexedEmbedded(prefix="won_")
    private Set<GolfCourse> wonCourses;

    GolfPlayer() {
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public Boolean isActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public Date getDateOfBirth() {
        return this.dateOfBirth;
    }

    public void setDateOfBirth(Date dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    public Calendar getSubscriptionEndDate() {
        return this.subscriptionEndDate;
    }

    public void setSubscriptionEndDate(Calendar subscriptionEndDate) {
        this.subscriptionEndDate = subscriptionEndDate;
    }

    public double getHandicap() {
        return this.handicap;
    }

    public void setHandicap(double handicap) {
        this.handicap = handicap;
    }

    public double getPuttingStrength() {
        return this.puttingStrength;
    }

    public void setPuttingStrength(double puttingStrength) {
        this.puttingStrength = puttingStrength;
    }

    public Integer getDriveWidth() {
        return this.driveWidth;
    }

    public void setDriveWidth(Integer driveWidth) {
        this.driveWidth = driveWidth;
    }

    public Ranking getRanking() {
        return this.ranking;
    }

    public void setRanking(Ranking ranking) {
        this.ranking = ranking;
    }

    public Set<String> getStrengths() {
        return this.strengths;
    }

    public void setStrengths(Set<String> strengths) {
        this.strengths = strengths;
    }

    public Set<GolfCourse> getPlayedCourses() {
        return this.playedCourses;
    }

    public void setPlayedCourses(Set<GolfCourse> playedCourses) {
        this.playedCourses = playedCourses;
    }

    public Set<GolfCourse> getWonCourses() {
        return this.wonCourses;
    }

    public void setWonCourses(Set<GolfCourse> wonCourses) {
        this.wonCourses = wonCourses;
    }

    public static class Builder {
        private String firstName;
        private String lastName;
        private Boolean active;
        private Date dateOfBirth;
        private Calendar subscriptionEndDate;
        private double handicap;
        private double puttingStrength;
        private Integer driveWidth;
        private Integer ranking;
        private Set<String> strengths = new HashSet<String>();
        private final Set<GolfCourse> playedCourses = new HashSet<GolfCourse>();
        private final Set<GolfCourse> wonCourses = new HashSet<GolfCourse>();

        public Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public Builder active(boolean active) {
            this.active = active;
            return this;
        }

        public Builder dateOfBirth(Date dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
            return this;
        }

        public Builder subscriptionEndDate(Calendar subscriptionEndDate) {
            this.subscriptionEndDate = subscriptionEndDate;
            return this;
        }

        public Builder handicap(double handicap) {
            this.handicap = handicap;
            return this;
        }

        public Builder driveWidth(int driveWidth) {
            this.driveWidth = driveWidth;
            return this;
        }

        public Builder ranking(int ranking) {
            this.ranking = ranking;
            return this;
        }

        public Builder puttingStrength(double puttingStrength) {
            this.puttingStrength = puttingStrength;
            return this;
        }

        public Builder strength(String strength) {
            this.strengths.add(strength);
            return this;
        }

        public Builder playedCourses(GolfCourse ... courses) {
            for (GolfCourse course : courses) {
                this.playedCourses.add(course);
            }
            return this;
        }

        public Builder wonCourses(GolfCourse ... courses) {
            for (GolfCourse course : courses) {
                this.wonCourses.add(course);
            }
            return this;
        }

        GolfPlayer build() {
            GolfPlayer player = new GolfPlayer();
            player.setFirstName(this.firstName);
            player.setLastName(this.lastName);
            player.setActive(this.active);
            player.setDateOfBirth(this.dateOfBirth);
            player.setSubscriptionEndDate(this.subscriptionEndDate);
            player.setHandicap(this.handicap);
            player.setPuttingStrength(this.puttingStrength);
            player.setDriveWidth(this.driveWidth);
            if (this.ranking != null) {
                player.setRanking(new Ranking(BigInteger.valueOf(this.ranking.intValue())));
            }
            player.setStrengths(this.strengths);
            if (!this.playedCourses.isEmpty()) {
                player.setPlayedCourses(this.playedCourses);
            }
            if (!this.wonCourses.isEmpty()) {
                player.setWonCourses(this.wonCourses);
            }
            return player;
        }
    }
}

