/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.Id;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.SpatialFieldBridgeByRange;

@Entity
@Indexed
public class POI {
    @Id
    Integer id;
    @Field(store=Store.YES)
    String name;
    @Field(store=Store.YES, index=Index.YES)
    String type;
    double latitude;
    double longitude;

    @Field(store=Store.YES, index=Index.YES, analyze=Analyze.NO)
    @FieldBridge(impl=SpatialFieldBridgeByRange.class)
    @Embedded
    public Coordinates getLocation() {
        return new Coordinates(){

            public Double getLatitude() {
                return POI.this.latitude;
            }

            public Double getLongitude() {
                return POI.this.longitude;
            }
        };
    }

    public POI(Integer id, String name, double latitude, double longitude, String type) {
        this.id = id;
        this.name = name;
        this.latitude = latitude;
        this.longitude = longitude;
        this.type = type;
    }

    public POI() {
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public String getType() {
        return this.type;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("POI [id=");
        builder.append(this.id);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", type=");
        builder.append(this.type);
        builder.append(", latitude=");
        builder.append(this.latitude);
        builder.append(", longitude=");
        builder.append(this.longitude);
        builder.append("]");
        return builder.toString();
    }
}

