/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.search.FullTextSession;
import org.hibernate.search.Search;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.FlushLuceneWork;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.testutil.TestElasticsearchClient;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.test.SearchTestBase;
import org.hibernate.search.test.util.impl.ExpectedLog4jLog;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class PurgeIT
extends SearchTestBase {
    @Rule
    public ExpectedLog4jLog logged = ExpectedLog4jLog.create();
    @Rule
    public TestElasticsearchClient elasticsearchClient = new TestElasticsearchClient();
    private FullTextSession fullTextSession;

    @Before
    public void setUp() throws Exception {
        this.elasticsearchClient.template("no_automatic_refresh").create("*", JsonBuilder.object().add("index", JsonBuilder.object().addProperty("refresh_interval", "-1")).build());
        super.setUp();
        this.createPersistAndIndexTestData();
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2761")
    public void multiplePurges() throws Exception {
        this.flush();
        List<Level1> all = this.getAll();
        Assert.assertEquals((String)"Wrong total number of entries", (long)3L, (long)all.size());
        this.logged.expectEventMissing((Matcher)new TypeSafeMatcher<LoggingEvent>(){

            public void describeTo(Description description) {
                description.appendText("a LoggingEvent with ERROR level or higher");
            }

            protected boolean matchesSafely(LoggingEvent item) {
                return item.getLevel().isGreaterOrEqual((Priority)Level.ERROR);
            }
        });
        Transaction tx = this.fullTextSession.beginTransaction();
        this.fullTextSession.purgeAll(Level2.class);
        this.fullTextSession.purgeAll(Level3.class);
        this.fullTextSession.purgeAll(Level1.class);
        tx.commit();
        this.flush();
        all = this.getAll();
        Assert.assertEquals((String)"Wrong total number of entries. Index should be empty after purge.", (long)0L, (long)all.size());
        tx = this.fullTextSession.beginTransaction();
        this.fullTextSession.createIndexer(new Class[0]).batchSizeToLoadObjects(25).threadsToLoadObjects(1).optimizeOnFinish(true).startAndWait();
        tx.commit();
        this.flush();
        all = this.getAll();
        Assert.assertEquals((String)"Wrong total number of entries.", (long)3L, (long)all.size());
    }

    @Test
    public void writeThenPurge() throws Exception {
        this.flush();
        List<Level1> all = this.getAll();
        Assert.assertEquals((String)"Wrong total number of entries", (long)3L, (long)all.size());
        this.logged.expectEventMissing((Matcher)new TypeSafeMatcher<LoggingEvent>(){

            public void describeTo(Description description) {
                description.appendText("a LoggingEvent with ERROR level or higher");
            }

            protected boolean matchesSafely(LoggingEvent item) {
                return item.getLevel().isGreaterOrEqual((Priority)Level.ERROR);
            }
        });
        Transaction tx = this.fullTextSession.beginTransaction();
        this.fullTextSession.index(this.fullTextSession.get(Level1.class, (Serializable)Long.valueOf(1L)));
        tx.commit();
        tx = this.fullTextSession.beginTransaction();
        this.fullTextSession.purgeAll(Level1.class);
        tx.commit();
        this.flush();
        all = this.getAll();
        Assert.assertEquals((String)"Wrong total number of entries. Index should be empty after purge.", (long)0L, (long)all.size());
        tx = this.fullTextSession.beginTransaction();
        this.fullTextSession.createIndexer(new Class[0]).batchSizeToLoadObjects(25).threadsToLoadObjects(1).optimizeOnFinish(true).startAndWait();
        tx.commit();
        this.flush();
        all = this.getAll();
        Assert.assertEquals((String)"Wrong total number of entries.", (long)3L, (long)all.size());
    }

    private void flush() {
        IndexManager indexManager = this.getExtendedSearchIntegrator().getIndexBinding(Level1.class).getIndexManagers()[0];
        indexManager.performOperations(Collections.singletonList(FlushLuceneWork.INSTANCE), null);
    }

    private void createPersistAndIndexTestData() {
        Level1 level1 = new Level1();
        level1.id = 1L;
        level1.text = "Level 1";
        Level2 level2 = new Level2();
        level2.id = 2L;
        level2.text = "Level 2";
        Level3 level3 = new Level3();
        level3.id = 3L;
        level3.text = "Level 3";
        this.fullTextSession = Search.getFullTextSession((Session)this.openSession());
        Transaction tx = this.fullTextSession.beginTransaction();
        this.fullTextSession.persist((Object)level1);
        this.fullTextSession.persist((Object)level2);
        this.fullTextSession.persist((Object)level3);
        tx.commit();
        this.fullTextSession.clear();
    }

    private List<Level1> getAll() {
        MatchAllDocsQuery query = new MatchAllDocsQuery();
        return this.fullTextSession.createFullTextQuery((Query)query, new Class[]{Level1.class}).list();
    }

    public void configure(Map<String, Object> settings) {
        settings.put("hibernate.search.default.elasticsearch.refresh_after_write", "false");
    }

    public Class<?>[] getAnnotatedClasses() {
        return new Class[]{Level1.class, Level2.class, Level3.class};
    }

    @Entity
    @Indexed
    private static class Level3
    extends Level2 {
        private Level3() {
        }
    }

    @Entity
    @Indexed
    private static class Level2
    extends Level1 {
        private Level2() {
        }
    }

    @Entity
    @Inheritance(strategy=InheritanceType.JOINED)
    @Indexed
    private static class Level1 {
        @Id
        protected Long id;
        @Field
        protected String text;

        private Level1() {
        }
    }
}

