/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.testutil;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.client.impl.Paths;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexManager;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexNameNormalizer;
import org.hibernate.search.elasticsearch.impl.ElasticsearchService;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.work.impl.DefaultElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.SimpleElasticsearchWork;
import org.hibernate.search.engine.service.spi.ServiceManager;
import org.hibernate.search.engine.service.spi.ServiceReference;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.test.TestResourceManager;
import org.hibernate.search.test.util.BackendTestHelper;

public class ElasticsearchBackendTestHelper
extends BackendTestHelper {
    private TestResourceManager resourceManager;

    public ElasticsearchBackendTestHelper(TestResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    public int getNumberOfDocumentsInIndex(IndexedTypeIdentifier entityType) {
        ServiceManager serviceManager = this.resourceManager.getExtendedSearchIntegrator().getServiceManager();
        IndexManager[] indexManagers = this.resourceManager.getExtendedSearchIntegrator().getIndexBinding(entityType).getIndexManagers();
        ArrayList<URLEncodedString> indexNames = new ArrayList<URLEncodedString>(indexManagers.length);
        for (IndexManager indexManager : indexManagers) {
            indexNames.add(URLEncodedString.fromString((String)((ElasticsearchIndexManager)indexManager).getActualIndexName()));
        }
        try (ServiceReference esService = serviceManager.requestReference(ElasticsearchService.class);){
            CountWork work = new CountWork.Builder(indexNames).type(URLEncodedString.fromString((String)entityType.getName())).build();
            int n = (Integer)((ElasticsearchService)esService.get()).getWorkProcessor().executeSyncUnsafe((ElasticsearchWork)work);
            return n;
        }
    }

    public int getNumberOfDocumentsInIndex(String indexName) {
        ServiceManager serviceManager = this.resourceManager.getExtendedSearchIntegrator().getServiceManager();
        try (ServiceReference esService = serviceManager.requestReference(ElasticsearchService.class);){
            CountWork work = new CountWork.Builder(ElasticsearchIndexNameNormalizer.getElasticsearchIndexName((String)indexName)).build();
            int n = (Integer)((ElasticsearchService)esService.get()).getWorkProcessor().executeSyncUnsafe((ElasticsearchWork)work);
            return n;
        }
    }

    public int getNumberOfDocumentsInIndexByQuery(String indexName, String fieldName, String value) {
        ServiceManager serviceManager = this.resourceManager.getExtendedSearchIntegrator().getServiceManager();
        String query = value.contains("*") ? "wildcard" : "term";
        try (ServiceReference esService = serviceManager.requestReference(ElasticsearchService.class);){
            CountWork work = new CountWork.Builder(ElasticsearchIndexNameNormalizer.getElasticsearchIndexName((String)indexName)).query(JsonBuilder.object().add("query", JsonBuilder.object().add(query, JsonBuilder.object().addProperty(fieldName, value))).build()).build();
            int n = (Integer)((ElasticsearchService)esService.get()).getWorkProcessor().executeSyncUnsafe((ElasticsearchWork)work);
            return n;
        }
    }

    private static class CountWork
    extends SimpleElasticsearchWork<Integer> {
        private static final JsonAccessor<Integer> COUNT_ACCESSOR = JsonAccessor.root().property("count").asInteger();

        protected CountWork(Builder builder) {
            super((SimpleElasticsearchWork.Builder)builder);
        }

        protected Integer generateResult(ElasticsearchWorkExecutionContext context, ElasticsearchResponse response) {
            JsonObject body = response.getBody();
            return (Integer)COUNT_ACCESSOR.get(body).get();
        }

        private static class Builder
        extends SimpleElasticsearchWork.Builder<Builder> {
            private final List<URLEncodedString> indexNames = new ArrayList<URLEncodedString>();
            private final List<URLEncodedString> typeNames = new ArrayList<URLEncodedString>();
            private JsonObject query;

            public Builder(URLEncodedString indexName) {
                this(Collections.singletonList(indexName));
            }

            public Builder(Collection<URLEncodedString> indexNames) {
                super(null, (ElasticsearchRequestSuccessAssessor)DefaultElasticsearchRequestSuccessAssessor.INSTANCE);
                this.indexNames.addAll(indexNames);
            }

            public Builder type(URLEncodedString type) {
                this.typeNames.add(type);
                return this;
            }

            public Builder query(JsonObject query) {
                this.query = query;
                return this;
            }

            protected ElasticsearchRequest buildRequest() {
                ElasticsearchRequest.Builder builder = ElasticsearchRequest.get().multiValuedPathComponent(this.indexNames);
                if (!this.typeNames.isEmpty()) {
                    builder.multiValuedPathComponent(this.typeNames);
                }
                builder.pathComponent(Paths._COUNT);
                if (this.query != null) {
                    builder.body(this.query);
                }
                return builder.build();
            }

            public CountWork build() {
                return new CountWork(this);
            }
        }
    }
}

