/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.testutil;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.elasticsearch.cfg.ElasticsearchIndexStatus;
import org.hibernate.search.elasticsearch.client.impl.DefaultElasticsearchClientFactory;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClient;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.client.impl.Paths;
import org.hibernate.search.elasticsearch.client.impl.URLEncodedString;
import org.hibernate.search.elasticsearch.dialect.impl.DialectIndependentGsonProvider;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.impl.ElasticsearchIndexNameNormalizer;
import org.hibernate.search.elasticsearch.impl.JsonBuilder;
import org.hibernate.search.elasticsearch.logging.impl.Log;
import org.hibernate.search.elasticsearch.util.impl.ElasticsearchClientUtils;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.testsupport.setup.BuildContextForTest;
import org.hibernate.search.testsupport.setup.SearchConfigurationForTest;
import org.hibernate.search.util.configuration.impl.MaskedProperty;
import org.hibernate.search.util.logging.impl.LoggerFactory;
import org.junit.rules.ExternalResource;

public class TestElasticsearchClient
extends ExternalResource {
    private static final Log LOG = (Log)LoggerFactory.make(Log.class);
    private final DefaultElasticsearchClientFactory clientFactory = new DefaultElasticsearchClientFactory();
    private ElasticsearchClient client;
    private final List<URLEncodedString> createdIndicesNames = Lists.newArrayList();
    private final List<String> createdTemplatesNames = Lists.newArrayList();

    public IndexClient index(Class<?> rootClass) {
        return new IndexClient(ElasticsearchIndexNameNormalizer.getElasticsearchIndexName((String)rootClass.getName()));
    }

    public IndexClient index(String indexName) {
        return new IndexClient(URLEncodedString.fromString((String)indexName));
    }

    public TypeClient type(Class<?> rootClass) {
        return this.index(rootClass).type(rootClass);
    }

    public TemplateClient template(String templateName) {
        return new TemplateClient(templateName);
    }

    private void deleteAndCreateIndex(URLEncodedString indexName) {
        this.doDeleteAndCreateIndex(indexName, ElasticsearchRequest.put().pathComponent(indexName).build());
    }

    private void deleteAndCreateIndex(URLEncodedString indexName, JsonObject settingsAsJsonObject) {
        this.doDeleteAndCreateIndex(indexName, ElasticsearchRequest.put().pathComponent(indexName).body(settingsAsJsonObject).build());
    }

    private void doDeleteAndCreateIndex(URLEncodedString indexName, ElasticsearchRequest createRequest) {
        this.tryDeleteESIndex(indexName);
        this.registerIndexForCleanup(indexName);
        this.performRequest(createRequest);
        this.waitForRequiredIndexStatus(indexName);
    }

    private void createTemplate(String templateName, String templateString, JsonObject settings) {
        JsonObject source = JsonBuilder.object().addProperty("template", templateString).add("settings", (JsonElement)settings).build();
        this.registerTemplateForCleanup(templateName);
        this.performRequest(ElasticsearchRequest.put().pathComponent(Paths._TEMPLATE).pathComponent(URLEncodedString.fromString((String)templateName)).body(source).build());
    }

    private void ensureIndexDoesNotExist(URLEncodedString indexName) {
        this.performRequestIgnore404(ElasticsearchRequest.delete().pathComponent(indexName).build());
    }

    private void registerIndexForCleanup(URLEncodedString indexName) {
        this.createdIndicesNames.add(indexName);
    }

    private void registerTemplateForCleanup(String templateName) {
        this.createdTemplatesNames.add(templateName);
    }

    private void waitForRequiredIndexStatus(URLEncodedString indexName) {
        this.performRequest(ElasticsearchRequest.get().pathComponent(Paths._CLUSTER).pathComponent(Paths.HEALTH).pathComponent(indexName).param("wait_for_status", ElasticsearchIndexStatus.YELLOW.getElasticsearchString()).param("timeout", "10000ms").build());
    }

    private void putMapping(URLEncodedString indexName, URLEncodedString mappingName, String mappingJson) {
        JsonObject mappingJsonObject = this.toJsonElement(mappingJson).getAsJsonObject();
        this.performRequest(ElasticsearchRequest.put().pathComponent(indexName).pathComponent(Paths._MAPPING).pathComponent(mappingName).body(mappingJsonObject).build());
    }

    private String getMapping(URLEncodedString indexName, URLEncodedString mappingName) {
        ElasticsearchResponse response = this.performRequest(ElasticsearchRequest.get().pathComponent(indexName).pathComponent(Paths._MAPPING).pathComponent(mappingName).build());
        JsonObject result = response.getBody();
        JsonElement index = result.get(indexName.original);
        if (index == null) {
            return new JsonObject().toString();
        }
        JsonElement mappings = index.getAsJsonObject().get("mappings");
        if (mappings == null) {
            return new JsonObject().toString();
        }
        JsonElement mapping = mappings.getAsJsonObject().get(mappingName.original);
        if (mapping == null) {
            return new JsonObject().toString();
        }
        return mapping.toString();
    }

    private void putDynamicSettings(URLEncodedString indexName, JsonObject settingsJsonObject) {
        this.performRequest(ElasticsearchRequest.put().pathComponent(indexName).pathComponent(Paths._SETTINGS).body(settingsJsonObject).build());
    }

    private void putNonDynamicSettings(URLEncodedString indexName, JsonObject settingsJsonObject) {
        this.performRequest(ElasticsearchRequest.post().pathComponent(indexName).pathComponent(Paths._CLOSE).build());
        this.performRequest(ElasticsearchRequest.put().pathComponent(indexName).pathComponent(Paths._SETTINGS).body(settingsJsonObject).build());
        this.performRequest(ElasticsearchRequest.post().pathComponent(indexName).pathComponent(Paths._OPEN).build());
    }

    private JsonObject buildSettings(String settingsPath, String settings) {
        JsonElement settingsJsonElement = this.toJsonElement(settings);
        for (String property : Lists.reverse(Arrays.asList(settingsPath.split("\\.")))) {
            settingsJsonElement = JsonBuilder.object().add(property, settingsJsonElement).build();
        }
        return settingsJsonElement.getAsJsonObject();
    }

    private String getSettings(URLEncodedString indexName, String path) {
        ElasticsearchResponse response = this.performRequest(ElasticsearchRequest.get().pathComponent(indexName).pathComponent(Paths._SETTINGS).build());
        JsonObject result = response.getBody();
        JsonElement index = result.get(indexName.original);
        if (index == null) {
            return new JsonObject().toString();
        }
        JsonElement settings = index.getAsJsonObject().get("settings");
        for (String property : path.split("\\.")) {
            if (settings == null) break;
            settings = settings.getAsJsonObject().get(property);
        }
        if (settings == null) {
            return new JsonObject().toString();
        }
        return settings.toString();
    }

    private void index(URLEncodedString indexName, URLEncodedString typeName, URLEncodedString id, String jsonDocument) {
        JsonObject documentJsonObject = this.toJsonElement(jsonDocument).getAsJsonObject();
        this.performRequest(ElasticsearchRequest.put().pathComponent(indexName).pathComponent(typeName).pathComponent(id).body(documentJsonObject).param("refresh", true).build());
    }

    private JsonObject getDocumentSource(URLEncodedString indexName, URLEncodedString typeName, URLEncodedString id) {
        ElasticsearchResponse response = this.performRequest(ElasticsearchRequest.get().pathComponent(indexName).pathComponent(typeName).pathComponent(id).build());
        JsonObject result = response.getBody();
        return result.get("_source").getAsJsonObject();
    }

    protected JsonElement getDocumentField(URLEncodedString indexName, URLEncodedString typeName, URLEncodedString id, String fieldName) {
        ElasticsearchResponse response = this.performRequest(ElasticsearchRequest.get().pathComponent(indexName).pathComponent(typeName).pathComponent(id).param("stored_fields", fieldName).build());
        JsonObject result = response.getBody();
        return result.get("fields").getAsJsonObject().get(fieldName);
    }

    protected void before() throws Throwable {
        SearchConfigurationForTest configuration = new SearchConfigurationForTest();
        Properties unkmaskedProperties = configuration.getProperties();
        this.clientFactory.start(unkmaskedProperties, (BuildContext)new BuildContextForTest((SearchConfiguration)configuration));
        MaskedProperty rootCfg = new MaskedProperty(unkmaskedProperties, "hibernate.search");
        MaskedProperty properties = new MaskedProperty((Properties)rootCfg, "default", (Properties)rootCfg);
        this.client = this.clientFactory.create((Properties)properties);
    }

    protected void after() {
        for (URLEncodedString indexName : this.createdIndicesNames) {
            this.tryDeleteESIndex(indexName);
        }
        this.createdIndicesNames.clear();
        for (String templateName : this.createdTemplatesNames) {
            this.tryDeleteESTemplate(templateName);
        }
        this.createdTemplatesNames.clear();
        try {
            this.client.close();
            this.client = null;
        }
        catch (IOException e) {
            throw new AssertionFailure("Unexpected exception when closing the ElasticsearchClient", (Throwable)e);
        }
    }

    private void tryDeleteESIndex(URLEncodedString indexName) {
        try {
            this.performRequestIgnore404(ElasticsearchRequest.delete().pathComponent(indexName).build());
        }
        catch (RuntimeException e) {
            LOG.warnf((Throwable)e, "Error while trying to delete index '%s' as part of test cleanup", (Object)indexName);
        }
    }

    private void tryDeleteESTemplate(String templateName) {
        try {
            this.performRequestIgnore404(ElasticsearchRequest.delete().pathComponent(Paths._TEMPLATE).pathComponent(URLEncodedString.fromString((String)templateName)).build());
        }
        catch (RuntimeException e) {
            LOG.warnf((Throwable)e, "Error while trying to delete template '%s' as part of test cleanup", (Object)templateName);
        }
    }

    protected ElasticsearchResponse performRequest(ElasticsearchRequest request) {
        ElasticsearchResponse response;
        try {
            response = this.client.execute(request);
        }
        catch (Exception e) {
            throw this.requestFailed(request, e);
        }
        int statusCode = response.getStatusCode();
        if (!ElasticsearchClientUtils.isSuccessCode((int)statusCode)) {
            throw this.requestFailed(request, response);
        }
        return response;
    }

    protected ElasticsearchResponse performRequestIgnore404(ElasticsearchRequest request) {
        ElasticsearchResponse response;
        try {
            response = this.client.execute(request);
        }
        catch (Exception e) {
            throw this.requestFailed(request, e);
        }
        int statusCode = response.getStatusCode();
        if (!ElasticsearchClientUtils.isSuccessCode((int)statusCode) && 404 != statusCode) {
            throw this.requestFailed(request, response);
        }
        return response;
    }

    private AssertionFailure requestFailed(ElasticsearchRequest request, Exception e) {
        return new AssertionFailure("Elasticsearch request in TestElasticsearchClient failed:Request:\n========\n" + ElasticsearchClientUtils.formatRequest((GsonProvider)DialectIndependentGsonProvider.INSTANCE, (ElasticsearchRequest)request), (Throwable)e);
    }

    private AssertionFailure requestFailed(ElasticsearchRequest request, ElasticsearchResponse response) {
        return new AssertionFailure("Elasticsearch request in TestElasticsearchClient failed:\nRequest:\n========\n" + ElasticsearchClientUtils.formatRequest((GsonProvider)DialectIndependentGsonProvider.INSTANCE, (ElasticsearchRequest)request) + "\nResponse:\n========\n" + ElasticsearchClientUtils.formatResponse((GsonProvider)DialectIndependentGsonProvider.INSTANCE, (ElasticsearchResponse)response));
    }

    private JsonElement toJsonElement(String jsonAsString) {
        return new JsonParser().parse(jsonAsString);
    }

    public class TemplateClient {
        private final String templateName;

        public TemplateClient(String templateName) {
            this.templateName = templateName;
        }

        public TemplateClient create(String templateString, JsonObject settings) {
            TestElasticsearchClient.this.createTemplate(this.templateName, templateString, settings);
            return this;
        }

        public TemplateClient registerForCleanup() {
            TestElasticsearchClient.this.registerTemplateForCleanup(this.templateName);
            return this;
        }
    }

    public class DocumentClient {
        private final TypeClient typeClient;
        private final URLEncodedString id;

        public DocumentClient(TypeClient typeClient, String id) {
            this.typeClient = typeClient;
            this.id = URLEncodedString.fromString((String)id);
        }

        public JsonObject getSource() {
            return TestElasticsearchClient.this.getDocumentSource(this.typeClient.indexClient.indexName, this.typeClient.typeName, this.id);
        }

        public JsonElement getStoredField(String fieldName) {
            return TestElasticsearchClient.this.getDocumentField(this.typeClient.indexClient.indexName, this.typeClient.typeName, this.id, fieldName);
        }
    }

    public class SettingsClient {
        private final IndexClient indexClient;
        private final String settingsPath;

        public SettingsClient(IndexClient indexClient, String settingsPath) {
            this.indexClient = indexClient;
            this.settingsPath = settingsPath;
        }

        public String get() {
            URLEncodedString indexName = this.indexClient.indexName;
            return TestElasticsearchClient.this.getSettings(indexName, this.settingsPath);
        }

        public void putDynamic(String settings) {
            URLEncodedString indexName = this.indexClient.indexName;
            JsonObject settingsAsJsonObject = TestElasticsearchClient.this.buildSettings(this.settingsPath, settings);
            TestElasticsearchClient.this.putDynamicSettings(indexName, settingsAsJsonObject);
        }

        public void putNonDynamic(String settings) {
            URLEncodedString indexName = this.indexClient.indexName;
            JsonObject settingsAsJsonObject = TestElasticsearchClient.this.buildSettings(this.settingsPath, settings);
            TestElasticsearchClient.this.putNonDynamicSettings(indexName, settingsAsJsonObject);
        }
    }

    public class TypeClient {
        private final IndexClient indexClient;
        private final URLEncodedString typeName;

        public TypeClient(IndexClient indexClient, String mappingName) {
            this.indexClient = indexClient;
            this.typeName = URLEncodedString.fromString((String)mappingName);
        }

        public TypeClient putMapping(String mappingJson) {
            TestElasticsearchClient.this.putMapping(this.indexClient.indexName, this.typeName, mappingJson);
            return this;
        }

        public String getMapping() {
            return TestElasticsearchClient.this.getMapping(this.indexClient.indexName, this.typeName);
        }

        public TypeClient index(URLEncodedString id, String jsonDocument) {
            URLEncodedString indexName = this.indexClient.indexName;
            TestElasticsearchClient.this.index(indexName, this.typeName, id, jsonDocument);
            return this;
        }

        public DocumentClient document(String id) {
            return new DocumentClient(this, id);
        }
    }

    public class IndexClient {
        private final URLEncodedString indexName;

        public IndexClient(URLEncodedString indexName) {
            this.indexName = indexName;
        }

        public void waitForRequiredIndexStatus() {
            TestElasticsearchClient.this.waitForRequiredIndexStatus(this.indexName);
        }

        public IndexClient deleteAndCreate() {
            TestElasticsearchClient.this.deleteAndCreateIndex(this.indexName);
            return this;
        }

        public IndexClient deleteAndCreate(String settingsPath, String settings) {
            JsonObject settingsAsJsonObject = TestElasticsearchClient.this.buildSettings(settingsPath, settings);
            TestElasticsearchClient.this.deleteAndCreateIndex(this.indexName, settingsAsJsonObject);
            return this;
        }

        public IndexClient ensureDoesNotExist() {
            TestElasticsearchClient.this.ensureIndexDoesNotExist(this.indexName);
            return this;
        }

        public IndexClient registerForCleanup() {
            TestElasticsearchClient.this.registerIndexForCleanup(this.indexName);
            return this;
        }

        public TypeClient type(Class<?> mappingClass) {
            return this.type(mappingClass.getName());
        }

        public TypeClient type(String mappingName) {
            return new TypeClient(this, mappingName);
        }

        public SettingsClient settings() {
            return this.settings("");
        }

        public SettingsClient settings(String settingsPath) {
            return new SettingsClient(this, settingsPath);
        }
    }
}

