/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.test;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.fest.assertions.Assertions;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchClient;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchRequest;
import org.hibernate.search.elasticsearch.client.impl.ElasticsearchResponse;
import org.hibernate.search.elasticsearch.gson.impl.GsonProvider;
import org.hibernate.search.elasticsearch.processor.impl.ElasticsearchWorkProcessor;
import org.hibernate.search.elasticsearch.work.impl.BulkRequestFailedException;
import org.hibernate.search.elasticsearch.work.impl.BulkWork;
import org.hibernate.search.elasticsearch.work.impl.BulkableElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWork;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkAggregator;
import org.hibernate.search.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.elasticsearch.work.impl.factory.ElasticsearchWorkFactory;
import org.hibernate.search.exception.ErrorContext;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.SearchException;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.testsupport.TestForIssue;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class ElasticsearchIndexWorkProcessorErrorHandlingTest {
    private ErrorHandler errorHandlerMock;
    private ElasticsearchWorkProcessor processor;
    private Map<Integer, LuceneWork> luceneWorks = new HashMap<Integer, LuceneWork>();

    @Before
    public void setup() throws Exception {
        this.errorHandlerMock = (ErrorHandler)EasyMock.createMock(ErrorHandler.class);
        BuildContext buildContextMock = (BuildContext)EasyMock.createMock(BuildContext.class);
        ElasticsearchClient clientMock = (ElasticsearchClient)EasyMock.createMock(ElasticsearchClient.class);
        GsonProvider gsonProviderMock = (GsonProvider)EasyMock.createMock(GsonProvider.class);
        ElasticsearchWorkFactory workFactoryMock = (ElasticsearchWorkFactory)EasyMock.createMock(ElasticsearchWorkFactory.class);
        EasyMock.expect((Object)buildContextMock.getErrorHandler()).andReturn((Object)this.errorHandlerMock);
        EasyMock.expect((Object)clientMock.execute((ElasticsearchRequest)EasyMock.anyObject())).andReturn((Object)new ElasticsearchResponse(200, "OK", new JsonObject())).anyTimes();
        EasyMock.expect((Object)workFactoryMock.bulk((List)EasyMock.anyObject())).andAnswer(() -> {
            List bulkableWorks = (List)EasyMock.getCurrentArguments()[0];
            return new BulkWork.Builder(bulkableWorks);
        }).anyTimes();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        EasyMock.expect((Object)gsonProviderMock.getGsonPrettyPrinting()).andReturn((Object)gson).anyTimes();
        EasyMock.replay((Object[])new Object[]{buildContextMock, clientMock, gsonProviderMock, workFactoryMock});
        this.processor = new ElasticsearchWorkProcessor(buildContextMock, clientMock, gsonProviderMock, workFactoryMock);
    }

    @After
    public void tearDown() {
        this.processor.close();
    }

    @Test
    public void syncSafe_single() throws Exception {
        Capture capture = new Capture();
        this.errorHandlerMock.handle((ErrorContext)EasyMock.capture((Capture)capture));
        EasyMock.expectLastCall().once();
        ElasticsearchWork<?> work = this.work(1);
        EasyMock.expect((Object)work.execute((ElasticsearchWorkExecutionContext)EasyMock.anyObject())).andThrow((Throwable)new SearchException());
        EasyMock.replay((Object[])new Object[]{this.errorHandlerMock, work});
        this.processor.executeSyncSafe(Arrays.asList(work));
        EasyMock.verify((Object[])new Object[]{this.errorHandlerMock, work});
        ErrorContext errorContext = (ErrorContext)capture.getValue();
        Assertions.assertThat((Throwable)errorContext.getThrowable()).isExactlyInstanceOf(SearchException.class);
        Assertions.assertThat((Object)errorContext.getOperationAtFault()).isSameAs((Object)this.luceneWork(1));
        Assertions.assertThat((List)errorContext.getFailingOperations()).containsOnly(new Object[]{this.luceneWork(1)});
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2652")
    public void syncSafe_multiple_noBulk() throws Exception {
        Capture capture = new Capture();
        this.errorHandlerMock.handle((ErrorContext)EasyMock.capture((Capture)capture));
        EasyMock.expectLastCall().once();
        ElasticsearchWork<?> work1 = this.work(1);
        ElasticsearchWork<?> work2 = this.work(2);
        ElasticsearchWork<?> work3 = this.work(3);
        ElasticsearchWork<?> work4 = this.work(4);
        EasyMock.expect((Object)work1.execute((ElasticsearchWorkExecutionContext)EasyMock.anyObject())).andReturn(null);
        EasyMock.expect((Object)work2.execute((ElasticsearchWorkExecutionContext)EasyMock.anyObject())).andThrow((Throwable)new SearchException());
        EasyMock.replay((Object[])new Object[]{this.errorHandlerMock, work1, work2, work3, work4});
        this.processor.executeSyncSafe(Arrays.asList(work1, work2, work3, work4));
        EasyMock.verify((Object[])new Object[]{this.errorHandlerMock, work1, work2, work3, work4});
        ErrorContext errorContext = (ErrorContext)capture.getValue();
        Assertions.assertThat((Throwable)errorContext.getThrowable()).isExactlyInstanceOf(SearchException.class);
        Assertions.assertThat((Object)errorContext.getOperationAtFault()).isSameAs((Object)this.luceneWork(2));
        Assertions.assertThat((List)errorContext.getFailingOperations()).containsOnly(new Object[]{this.luceneWork(2), this.luceneWork(3), this.luceneWork(4)});
    }

    @Test
    public void syncSafe_multiple_bulk() throws Exception {
        Capture capture = new Capture();
        this.errorHandlerMock.handle((ErrorContext)EasyMock.capture((Capture)capture));
        EasyMock.expectLastCall().once();
        BulkableElasticsearchWork<?> work1 = this.bulkableWork(1);
        BulkableElasticsearchWork<?> work2 = this.bulkableWork(2);
        BulkableElasticsearchWork<?> work3 = this.bulkableWork(3);
        BulkableElasticsearchWork<?> work4 = this.bulkableWork(4);
        EasyMock.expect((Object)work1.handleBulkResult((ElasticsearchWorkExecutionContext)EasyMock.anyObject(), (JsonObject)EasyMock.anyObject())).andReturn((Object)true);
        EasyMock.expect((Object)work2.handleBulkResult((ElasticsearchWorkExecutionContext)EasyMock.anyObject(), (JsonObject)EasyMock.anyObject())).andReturn((Object)true);
        EasyMock.expect((Object)work3.handleBulkResult((ElasticsearchWorkExecutionContext)EasyMock.anyObject(), (JsonObject)EasyMock.anyObject())).andReturn((Object)false);
        EasyMock.expect((Object)work4.handleBulkResult((ElasticsearchWorkExecutionContext)EasyMock.anyObject(), (JsonObject)EasyMock.anyObject())).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.errorHandlerMock, work1, work2, work3, work4});
        this.processor.executeSyncSafe(Arrays.asList(work1, work2, work3, work4));
        EasyMock.verify((Object[])new Object[]{this.errorHandlerMock, work1, work2, work3, work4});
        ErrorContext errorContext = (ErrorContext)capture.getValue();
        Assertions.assertThat((Throwable)errorContext.getThrowable()).isExactlyInstanceOf(BulkRequestFailedException.class);
        Assertions.assertThat((Object)errorContext.getOperationAtFault()).isSameAs((Object)this.luceneWork(3));
        Assertions.assertThat((List)errorContext.getFailingOperations()).containsOnly(new Object[]{this.luceneWork(3)});
    }

    @Test
    public void asyncItem() throws Exception {
        Capture capture = new Capture();
        this.errorHandlerMock.handle((ErrorContext)EasyMock.capture((Capture)capture));
        EasyMock.expectLastCall().once();
        ElasticsearchWork<?> work = this.work(1);
        EasyMock.expect((Object)work.execute((ElasticsearchWorkExecutionContext)EasyMock.anyObject())).andThrow((Throwable)new SearchException());
        EasyMock.replay((Object[])new Object[]{this.errorHandlerMock, work});
        this.processor.executeAsync(work);
        this.processor.awaitAsyncProcessingCompletion();
        EasyMock.verify((Object[])new Object[]{this.errorHandlerMock, work});
        ErrorContext errorContext = (ErrorContext)capture.getValue();
        Assertions.assertThat((Throwable)errorContext.getThrowable()).isExactlyInstanceOf(SearchException.class);
        Assertions.assertThat((Object)errorContext.getOperationAtFault()).isSameAs((Object)this.luceneWork(1));
        Assertions.assertThat((List)errorContext.getFailingOperations()).containsOnly(new Object[]{this.luceneWork(1)});
    }

    @Test
    public void asyncList_single() throws Exception {
        Capture capture = new Capture();
        this.errorHandlerMock.handle((ErrorContext)EasyMock.capture((Capture)capture));
        EasyMock.expectLastCall().once();
        ElasticsearchWork<?> work = this.work(1);
        EasyMock.expect((Object)work.execute((ElasticsearchWorkExecutionContext)EasyMock.anyObject())).andThrow((Throwable)new SearchException());
        EasyMock.replay((Object[])new Object[]{this.errorHandlerMock, work});
        this.processor.executeAsync(Arrays.asList(work));
        this.processor.awaitAsyncProcessingCompletion();
        EasyMock.verify((Object[])new Object[]{this.errorHandlerMock, work});
        ErrorContext errorContext = (ErrorContext)capture.getValue();
        Assertions.assertThat((Throwable)errorContext.getThrowable()).isExactlyInstanceOf(SearchException.class);
        Assertions.assertThat((Object)errorContext.getOperationAtFault()).isSameAs((Object)this.luceneWork(1));
        Assertions.assertThat((List)errorContext.getFailingOperations()).containsOnly(new Object[]{this.luceneWork(1)});
    }

    @Test
    @TestForIssue(jiraKey="HSEARCH-2652")
    public void asyncList_multiple_noBulk() throws Exception {
        Capture capture = new Capture();
        this.errorHandlerMock.handle((ErrorContext)EasyMock.capture((Capture)capture));
        EasyMock.expectLastCall().once();
        ElasticsearchWork<?> work1 = this.work(1);
        ElasticsearchWork<?> work2 = this.work(2);
        ElasticsearchWork<?> work3 = this.work(3);
        ElasticsearchWork<?> work4 = this.work(4);
        EasyMock.expect((Object)work1.execute((ElasticsearchWorkExecutionContext)EasyMock.anyObject())).andReturn(null);
        EasyMock.expect((Object)work2.execute((ElasticsearchWorkExecutionContext)EasyMock.anyObject())).andThrow((Throwable)new SearchException());
        EasyMock.replay((Object[])new Object[]{this.errorHandlerMock, work1, work2, work3, work4});
        this.processor.executeAsync(Arrays.asList(work1, work2, work3, work4));
        this.processor.awaitAsyncProcessingCompletion();
        EasyMock.verify((Object[])new Object[]{this.errorHandlerMock, work1, work2, work3, work4});
        ErrorContext errorContext = (ErrorContext)capture.getValue();
        Assertions.assertThat((Throwable)errorContext.getThrowable()).isExactlyInstanceOf(SearchException.class);
        Assertions.assertThat((Object)errorContext.getOperationAtFault()).isSameAs((Object)this.luceneWork(2));
        Assertions.assertThat((List)errorContext.getFailingOperations()).containsOnly(new Object[]{this.luceneWork(2), this.luceneWork(3), this.luceneWork(4)});
    }

    @Test
    public void asyncList_multiple_bulk() throws Exception {
        Capture capture = new Capture();
        this.errorHandlerMock.handle((ErrorContext)EasyMock.capture((Capture)capture));
        EasyMock.expectLastCall().once();
        BulkableElasticsearchWork<?> work1 = this.bulkableWork(1);
        BulkableElasticsearchWork<?> work2 = this.bulkableWork(2);
        BulkableElasticsearchWork<?> work3 = this.bulkableWork(3);
        BulkableElasticsearchWork<?> work4 = this.bulkableWork(4);
        ElasticsearchWork<?> work5 = this.work(5);
        EasyMock.expect((Object)work1.handleBulkResult((ElasticsearchWorkExecutionContext)EasyMock.anyObject(), (JsonObject)EasyMock.anyObject())).andReturn((Object)true);
        EasyMock.expect((Object)work2.handleBulkResult((ElasticsearchWorkExecutionContext)EasyMock.anyObject(), (JsonObject)EasyMock.anyObject())).andReturn((Object)true);
        EasyMock.expect((Object)work3.handleBulkResult((ElasticsearchWorkExecutionContext)EasyMock.anyObject(), (JsonObject)EasyMock.anyObject())).andReturn((Object)false);
        EasyMock.expect((Object)work4.handleBulkResult((ElasticsearchWorkExecutionContext)EasyMock.anyObject(), (JsonObject)EasyMock.anyObject())).andReturn((Object)true);
        EasyMock.replay((Object[])new Object[]{this.errorHandlerMock, work1, work2, work3, work4, work5});
        this.processor.executeAsync(Arrays.asList(work1, work2, work3, work4, work5));
        this.processor.awaitAsyncProcessingCompletion();
        EasyMock.verify((Object[])new Object[]{this.errorHandlerMock, work1, work2, work3, work4, work5});
        ErrorContext errorContext = (ErrorContext)capture.getValue();
        Assertions.assertThat((Throwable)errorContext.getThrowable()).isExactlyInstanceOf(BulkRequestFailedException.class);
        Assertions.assertThat((Object)errorContext.getOperationAtFault()).isSameAs((Object)this.luceneWork(3));
        Assertions.assertThat((List)errorContext.getFailingOperations()).containsOnly(new Object[]{this.luceneWork(3), this.luceneWork(5)});
    }

    private ElasticsearchWork<?> work(int index) {
        ElasticsearchWork mock = (ElasticsearchWork)EasyMock.createMock((String)("work" + index), ElasticsearchWork.class);
        mock.aggregate((ElasticsearchWorkAggregator)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer(() -> {
            ElasticsearchWorkAggregator aggregator = (ElasticsearchWorkAggregator)EasyMock.getCurrentArguments()[0];
            aggregator.addNonBulkable(mock);
            return null;
        });
        EasyMock.expect((Object)mock.getLuceneWorks()).andAnswer(() -> Stream.of(this.luceneWork(index))).atLeastOnce();
        return mock;
    }

    private BulkableElasticsearchWork<?> bulkableWork(int index) {
        BulkableElasticsearchWork mock = (BulkableElasticsearchWork)EasyMock.createMock((String)("bulkableWork" + index), BulkableElasticsearchWork.class);
        mock.aggregate((ElasticsearchWorkAggregator)EasyMock.anyObject());
        EasyMock.expectLastCall().andAnswer(() -> {
            ElasticsearchWorkAggregator aggregator = (ElasticsearchWorkAggregator)EasyMock.getCurrentArguments()[0];
            aggregator.addBulkable(mock);
            return null;
        });
        EasyMock.expect((Object)mock.getBulkableActionMetadata()).andReturn(null);
        EasyMock.expect((Object)mock.getBulkableActionBody()).andReturn(null);
        EasyMock.expect((Object)mock.getLuceneWorks()).andAnswer(() -> Stream.of(this.luceneWork(index))).atLeastOnce();
        return mock;
    }

    private LuceneWork luceneWork(int index) {
        LuceneWork work = this.luceneWorks.get(index);
        if (work == null) {
            work = (LuceneWork)EasyMock.createMock((String)("luceneWork" + index), LuceneWork.class);
            this.luceneWorks.put(index, work);
        }
        return work;
    }
}

