/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.hibernate.search.analyzer.impl.RemoteAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ElasticsearchAnalysisDefinitionRegistryPopulator;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.SimpleElasticsearchAnalysisDefinitionRegistryPopulator;
import org.hibernate.search.elasticsearch.settings.impl.model.AnalyzerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.CharFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenizerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.translation.ElasticsearchAnalyzerDefinitionTranslator;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class NamedElasticsearchAnalyzerReference
extends ElasticsearchAnalyzerReference {
    private static final Log LOG = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());
    protected final String name;
    private ElasticsearchAnalysisDefinitionRegistryPopulator definitionRegistryPopulator;

    public NamedElasticsearchAnalyzerReference(String name) {
        this.name = name;
    }

    public String getAnalyzerName(String fieldName) {
        return this.name;
    }

    public boolean isNormalizer(String fieldName) {
        return false;
    }

    @Override
    public void registerDefinitions(String fieldName, ElasticsearchAnalysisDefinitionRegistry definitionRegistry) {
        if (this.definitionRegistryPopulator == null) {
            throw LOG.lazyRemoteAnalyzerReferenceNotInitialized((RemoteAnalyzerReference)this);
        }
        this.definitionRegistryPopulator.populate(definitionRegistry);
    }

    @Override
    public boolean isInitialized() {
        return this.definitionRegistryPopulator != null;
    }

    @Override
    public void initialize(ElasticsearchAnalysisDefinitionRegistry definitionRegistry, ElasticsearchAnalyzerDefinitionTranslator translator) {
        if (this.definitionRegistryPopulator != null) {
            throw new AssertionFailure("A named analyzer reference has been initialized more than once: " + (Object)((Object)this));
        }
        this.definitionRegistryPopulator = this.createRegistryPopulator(definitionRegistry);
    }

    protected ElasticsearchAnalysisDefinitionRegistryPopulator createRegistryPopulator(ElasticsearchAnalysisDefinitionRegistry definitionRegistry) {
        AnalyzerDefinition analyzerDefinition = definitionRegistry.getAnalyzerDefinition(this.name);
        if (analyzerDefinition == null) {
            return r -> {};
        }
        String tokenizerName = analyzerDefinition.getTokenizer();
        TokenizerDefinition tokenizerDefinition = definitionRegistry.getTokenizerDefinition(tokenizerName);
        Map<String, TokenFilterDefinition> tokenFilters = this.collectDefinitions(definitionRegistry::getTokenFilterDefinition, analyzerDefinition.getTokenFilters());
        Map<String, CharFilterDefinition> charFilters = this.collectDefinitions(definitionRegistry::getCharFilterDefinition, analyzerDefinition.getCharFilters());
        return new SimpleElasticsearchAnalysisDefinitionRegistryPopulator(this.name, analyzerDefinition, tokenizerName, tokenizerDefinition, charFilters, tokenFilters);
    }

    protected final <T> Map<String, T> collectDefinitions(Function<String, T> registry, Collection<String> names) {
        TreeMap<String, T> result = new TreeMap<String, T>();
        if (names != null) {
            for (String name : names) {
                T definition = registry.apply(name);
                if (definition == null) continue;
                result.put(name, definition);
            }
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((Object)((Object)this)).getClass().getSimpleName());
        sb.append("<");
        sb.append(this.name);
        sb.append(",");
        sb.append(this.definitionRegistryPopulator);
        sb.append(">");
        return sb.toString();
    }
}

