/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.analyzer.spi.AnalyzerReference;
import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.analyzer.impl.ElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.settings.impl.translation.ElasticsearchAnalyzerDefinitionTranslator;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ScopedElasticsearchAnalyzerReference
extends ElasticsearchAnalyzerReference
implements ScopedAnalyzerReference {
    private static final Log LOG = LoggerFactory.make((MethodHandles.Lookup)MethodHandles.lookup());
    private final ElasticsearchAnalyzerReference globalAnalyzerReference;
    private final Map<String, ElasticsearchAnalyzerReference> scopedAnalyzerReferences;

    public ScopedElasticsearchAnalyzerReference(Builder builder) {
        this.globalAnalyzerReference = builder.globalAnalyzerReference;
        this.scopedAnalyzerReferences = Collections.unmodifiableMap(new HashMap(builder.scopedAnalyzerReferences));
    }

    public String getAnalyzerName(String fieldName) {
        return this.getDelegate(fieldName).getAnalyzerName(fieldName);
    }

    public boolean isNormalizer(String fieldName) {
        return this.getDelegate(fieldName).isNormalizer(fieldName);
    }

    @Override
    public void registerDefinitions(String fieldName, ElasticsearchAnalysisDefinitionRegistry definitionRegistry) {
        this.getDelegate(fieldName).registerDefinitions(fieldName, definitionRegistry);
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    @Override
    public void initialize(ElasticsearchAnalysisDefinitionRegistry definitionRegistry, ElasticsearchAnalyzerDefinitionTranslator translator) {
    }

    public ScopedAnalyzerReference.CopyBuilder startCopy() {
        return new Builder(this.globalAnalyzerReference, this.scopedAnalyzerReferences);
    }

    private ElasticsearchAnalyzerReference getDelegate(String fieldName) {
        ElasticsearchAnalyzerReference analyzerReference = this.scopedAnalyzerReferences.get(fieldName);
        if (analyzerReference == null) {
            analyzerReference = this.globalAnalyzerReference;
        }
        return analyzerReference;
    }

    private static ElasticsearchAnalyzerReference getElasticsearchAnalyzerReference(AnalyzerReference analyzerReference) {
        if (!analyzerReference.is(ElasticsearchAnalyzerReference.class)) {
            throw LOG.analyzerReferenceIsNotRemote(analyzerReference);
        }
        return (ElasticsearchAnalyzerReference)analyzerReference.unwrap(ElasticsearchAnalyzerReference.class);
    }

    public static class Builder
    implements ScopedAnalyzerReference.Builder,
    ScopedAnalyzerReference.CopyBuilder {
        private ElasticsearchAnalyzerReference globalAnalyzerReference;
        private final Map<String, ElasticsearchAnalyzerReference> scopedAnalyzerReferences = new HashMap<String, ElasticsearchAnalyzerReference>();

        public Builder(ElasticsearchAnalyzerReference globalAnalyzerReference, Map<String, ElasticsearchAnalyzerReference> scopedAnalyzers) {
            this.globalAnalyzerReference = globalAnalyzerReference;
            this.scopedAnalyzerReferences.putAll(scopedAnalyzers);
        }

        public ElasticsearchAnalyzerReference getGlobalAnalyzerReference() {
            return this.globalAnalyzerReference;
        }

        public void setGlobalAnalyzerReference(AnalyzerReference globalAnalyzerReference) {
            this.globalAnalyzerReference = ScopedElasticsearchAnalyzerReference.getElasticsearchAnalyzerReference(globalAnalyzerReference);
        }

        public void addAnalyzerReference(String scope, AnalyzerReference analyzerReference) {
            this.scopedAnalyzerReferences.put(scope, ScopedElasticsearchAnalyzerReference.getElasticsearchAnalyzerReference(analyzerReference));
        }

        public ScopedElasticsearchAnalyzerReference build() {
            return new ScopedElasticsearchAnalyzerReference(this);
        }
    }
}

