/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.elasticsearch.analyzer.impl;

import java.util.Map;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ElasticsearchAnalysisDefinitionRegistry;
import org.hibernate.search.elasticsearch.analyzer.definition.impl.ElasticsearchAnalysisDefinitionRegistryPopulator;
import org.hibernate.search.elasticsearch.analyzer.impl.NamedElasticsearchAnalyzerReference;
import org.hibernate.search.elasticsearch.analyzer.impl.SimpleElasticsearchAnalysisDefinitionRegistryPopulator;
import org.hibernate.search.elasticsearch.settings.impl.model.CharFilterDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.NormalizerDefinition;
import org.hibernate.search.elasticsearch.settings.impl.model.TokenFilterDefinition;

public class NamedElasticsearch52NormalizerReference
extends NamedElasticsearchAnalyzerReference {
    public NamedElasticsearch52NormalizerReference(String name) {
        super(name);
    }

    @Override
    public boolean isNormalizer(String fieldName) {
        return true;
    }

    @Override
    protected ElasticsearchAnalysisDefinitionRegistryPopulator createRegistryPopulator(ElasticsearchAnalysisDefinitionRegistry definitionRegistry) {
        NormalizerDefinition normalizerDefinition = definitionRegistry.getNormalizerDefinition(this.name);
        if (normalizerDefinition == null) {
            return r -> {};
        }
        Map<String, TokenFilterDefinition> tokenFilters = this.collectDefinitions(definitionRegistry::getTokenFilterDefinition, normalizerDefinition.getTokenFilters());
        Map<String, CharFilterDefinition> charFilters = this.collectDefinitions(definitionRegistry::getCharFilterDefinition, normalizerDefinition.getCharFilters());
        return new SimpleElasticsearchAnalysisDefinitionRegistryPopulator(this.name, normalizerDefinition, charFilters, tokenFilters);
    }
}

