/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.impl;

import java.util.Properties;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.spi.LuceneIndexingParameters;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.impl.NotSharedReaderProvider;
import org.hibernate.search.indexes.impl.SharingBufferReaderProvider;
import org.hibernate.search.indexes.spi.DirectoryBasedReaderProvider;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.store.optimization.impl.ExplicitOnlyOptimizerStrategy;
import org.hibernate.search.store.optimization.impl.IncrementalOptimizerStrategy;
import org.hibernate.search.util.configuration.impl.ConfigurationParseHelper;
import org.hibernate.search.util.configuration.impl.MaskedProperty;
import org.hibernate.search.util.impl.ClassLoaderHelper;

public class CommonPropertiesParse {
    private CommonPropertiesParse() {
    }

    public static boolean isExclusiveIndexUsageEnabled(String indexName, Properties indexProps) {
        return ConfigurationParseHelper.getBooleanValue(indexProps, "exclusive_index_use", true);
    }

    public static int extractMaxQueueSize(String indexName, Properties indexProps) {
        String maxQueueSize = indexProps.getProperty("max_queue_length");
        if (maxQueueSize != null) {
            int parsedInt = ConfigurationParseHelper.parseInt(maxQueueSize, 1000, "Illegal value for property max_queue_length on index " + indexName);
            if (parsedInt < 1) {
                throw new SearchException("Property max_queue_length on index " + indexName + "must be strictly positive");
            }
            return parsedInt;
        }
        return 1000;
    }

    public static OptimizerStrategy getOptimizerStrategy(IndexManager callback, Properties indexProps) {
        ExplicitOnlyOptimizerStrategy optimizerStrategy;
        boolean incremental;
        boolean bl = incremental = indexProps.containsKey("optimizer.operation_limit.max") || indexProps.containsKey("optimizer.transaction_limit.max");
        if (incremental) {
            optimizerStrategy = new IncrementalOptimizerStrategy();
            optimizerStrategy.initialize(callback, indexProps);
        } else {
            optimizerStrategy = new ExplicitOnlyOptimizerStrategy();
        }
        return optimizerStrategy;
    }

    public static LuceneIndexingParameters extractIndexingPerformanceOptions(Properties indexProps) {
        LuceneIndexingParameters indexingParams = new LuceneIndexingParameters(indexProps);
        return indexingParams;
    }

    public static DirectoryBasedReaderProvider createDirectoryBasedReaderProvider(DirectoryBasedIndexManager indexManager, Properties cfg) {
        MaskedProperty props = new MaskedProperty(cfg, "reader");
        String impl = ((Properties)props).getProperty("strategy");
        DirectoryBasedReaderProvider readerProvider = StringHelper.isEmpty((String)impl) ? new SharingBufferReaderProvider() : ("not-shared".equalsIgnoreCase(impl) ? new NotSharedReaderProvider() : ("shared".equalsIgnoreCase(impl) ? new SharingBufferReaderProvider() : ClassLoaderHelper.instanceFromName(DirectoryBasedReaderProvider.class, impl, CommonPropertiesParse.class, "readerProvider")));
        readerProvider.initialize(indexManager, props);
        return readerProvider;
    }
}

