/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.impl.SimpleInitializer;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.spi.ServiceProvider;

public class ManualConfiguration
implements SearchConfiguration {
    private final Map<String, Class<?>> classes;
    private final Properties properties;
    private final HashMap<Class<? extends ServiceProvider<?>>, Object> providedServices;
    private final InstanceInitializer initializer;
    private SearchMapping programmaticMapping;

    public ManualConfiguration() {
        this((InstanceInitializer)SimpleInitializer.INSTANCE);
    }

    public ManualConfiguration(InstanceInitializer init) {
        this.initializer = init;
        this.classes = new HashMap();
        this.properties = new Properties();
        this.providedServices = new HashMap();
    }

    public ManualConfiguration addProperty(String key, String value) {
        this.properties.setProperty(key, value);
        return this;
    }

    public ManualConfiguration addClass(Class<?> indexed) {
        this.classes.put(indexed.getName(), indexed);
        return this;
    }

    public Iterator<Class<?>> getClassMappings() {
        return this.classes.values().iterator();
    }

    public Class<?> getClassMapping(String name) {
        return this.classes.get(name);
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ReflectionManager getReflectionManager() {
        return null;
    }

    public SearchMapping getProgrammaticMapping() {
        return this.programmaticMapping;
    }

    public void setProgrammaticMapping(SearchMapping programmaticMapping) {
        this.programmaticMapping = programmaticMapping;
    }

    public Map<Class<? extends ServiceProvider<?>>, Object> getProvidedServices() {
        return this.providedServices;
    }

    public boolean isTransactionManagerExpected() {
        return true;
    }

    public InstanceInitializer getInstanceInitializer() {
        return this.initializer;
    }
}

