/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene.works;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.IndexingMonitor;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.impl.lucene.works.LuceneWorkDelegate;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.store.Workspace;
import org.hibernate.search.util.impl.ScopedAnalyzer;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class AddWorkDelegate
implements LuceneWorkDelegate {
    private static final Log log = LoggerFactory.make();
    protected final Workspace workspace;

    AddWorkDelegate(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public void performWork(LuceneWork work, IndexWriter writer, IndexingMonitor monitor) {
        Class<?> entityType = work.getEntityClass();
        DocumentBuilderIndexedEntity<?> documentBuilder = this.workspace.getDocumentBuilder(entityType);
        Map<String, String> fieldToAnalyzerMap = work.getFieldToAnalyzerMap();
        ScopedAnalyzer analyzer = documentBuilder.getAnalyzer();
        analyzer = this.updateAnalyzerMappings(analyzer, fieldToAnalyzerMap);
        if (log.isTraceEnabled()) {
            log.trace("add to Lucene index: " + entityType + "#" + work.getId() + ":" + work.getDocument());
        }
        try {
            writer.addDocument(work.getDocument(), (Analyzer)analyzer);
            this.workspace.incrementModificationCounter(1);
        }
        catch (IOException e) {
            throw new SearchException("Unable to add to Lucene index: " + entityType + "#" + work.getId(), e);
        }
        if (monitor != null) {
            monitor.documentsAdded(1L);
        }
    }

    private ScopedAnalyzer updateAnalyzerMappings(ScopedAnalyzer scopedAnalyzer, Map<String, String> fieldToAnalyzerMap) {
        if (fieldToAnalyzerMap == null || fieldToAnalyzerMap.isEmpty()) {
            return scopedAnalyzer;
        }
        ScopedAnalyzer analyzerClone = scopedAnalyzer.clone();
        for (Map.Entry<String, String> entry : fieldToAnalyzerMap.entrySet()) {
            Analyzer analyzer = this.workspace.getAnalyzer(entry.getValue());
            if (analyzer == null) {
                log.unableToRetrieveNamedAnalyzer(entry.getValue());
                continue;
            }
            analyzerClone.addScopedAnalyzer(entry.getKey(), analyzer);
        }
        return analyzerClone;
    }
}

