/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.spi;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Similarity;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.annotations.common.util.ReflectHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.CacheFromIndex;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.FieldCacheType;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Norms;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.ProvidedId;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.UpdateLuceneWork;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.StringBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.bridge.builtin.NumericFieldBridge;
import org.hibernate.search.bridge.builtin.impl.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.bridge.impl.BridgeFactory;
import org.hibernate.search.bridge.spi.ConversionContext;
import org.hibernate.search.bridge.util.impl.ContextualExceptionBridgeHelper;
import org.hibernate.search.engine.impl.AnnotationProcessingHelper;
import org.hibernate.search.engine.impl.LuceneOptionsImpl;
import org.hibernate.search.engine.spi.AbstractDocumentBuilder;
import org.hibernate.search.engine.spi.EntityState;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.query.collector.impl.FieldCacheCollectorFactory;
import org.hibernate.search.query.fieldcache.impl.ClassLoadingStrategySelector;
import org.hibernate.search.query.fieldcache.impl.FieldCacheLoadingType;
import org.hibernate.search.spi.InstanceInitializer;
import org.hibernate.search.util.impl.ReflectionHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class DocumentBuilderIndexedEntity<T>
extends AbstractDocumentBuilder<T> {
    private static final Log log = LoggerFactory.make();
    private static final LuceneOptions NULL_EMBEDDED_MARKER_OPTIONS = new LuceneOptionsImpl(Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO, 1.0f);
    private boolean explicitDocumentId = false;
    private boolean allowFieldSelectionInProjection = false;
    private XMember idGetter;
    private String idKeywordName;
    private float idBoost = 1.0f;
    private TwoWayFieldBridge idBridge;
    private boolean idProvided;
    private XProperty documentIdAnnotatedMember;
    private XProperty jpaIdAnnotatedMember;
    private final Set<FieldCacheType> fieldCacheUsage;
    private final String identifierName;
    private final FieldCacheCollectorFactory idFieldCacheCollectorFactory;

    public DocumentBuilderIndexedEntity(XClass clazz, ConfigContext context, Similarity similarity, ReflectionManager reflectionManager, Set<XClass> optimizationBlackList, InstanceInitializer instanceInitializer) {
        super(clazz, context, similarity, reflectionManager, optimizationBlackList, instanceInitializer);
        ProvidedId provided = this.findProvidedId(clazz, reflectionManager);
        if (provided != null) {
            this.idBridge = BridgeFactory.extractTwoWayType(provided.bridge(), clazz, reflectionManager);
            this.idKeywordName = provided.name();
            this.idProvided = true;
        }
        if (this.idKeywordName == null) {
            throw new SearchException("No document id in: " + clazz);
        }
        CacheFromIndex fieldCacheOptions = (CacheFromIndex)clazz.getAnnotation(CacheFromIndex.class);
        if (fieldCacheOptions == null) {
            this.fieldCacheUsage = Collections.unmodifiableSet(EnumSet.of(FieldCacheType.CLASS));
        } else {
            EnumSet<FieldCacheType> enabledTypes = EnumSet.noneOf(FieldCacheType.class);
            Collections.addAll(enabledTypes, fieldCacheOptions.value());
            if (enabledTypes.size() != 1 && enabledTypes.contains((Object)FieldCacheType.NOTHING)) {
                throw new SearchException("CacheFromIndex configured with conflicting parameters: if FieldCacheType.NOTHING is enabled, no other options can be added");
            }
            this.fieldCacheUsage = Collections.unmodifiableSet(enabledTypes);
        }
        this.checkAllowFieldSelection();
        this.idFieldCacheCollectorFactory = this.figureIdFieldCacheUsage();
        if (log.isDebugEnabled()) {
            log.debugf("Field selection in projections is set to %b for entity %s.", this.allowFieldSelectionInProjection, clazz);
        }
        this.entityState = EntityState.INDEXED;
        this.identifierName = this.idProvided ? null : this.idGetter.getName();
    }

    private FieldCacheCollectorFactory figureIdFieldCacheUsage() {
        if (this.fieldCacheUsage.contains((Object)FieldCacheType.ID)) {
            FieldCacheLoadingType collectorTypeForId = ClassLoadingStrategySelector.guessAppropriateCollectorType(this.idBridge);
            if (collectorTypeForId == null) {
                log.cannotExtractValueForIdentifier(this.beanClass);
                return null;
            }
            TwoWayStringBridge twoWayIdStringBridge = ClassLoadingStrategySelector.getTwoWayStringBridge(this.idBridge);
            return new FieldCacheCollectorFactory(this.getIdKeywordName(), collectorTypeForId, twoWayIdStringBridge);
        }
        return null;
    }

    public XMember getIdGetter() {
        return this.idGetter;
    }

    public FieldCacheCollectorFactory getIdFieldCacheCollectionFactory() {
        return this.idFieldCacheCollectorFactory;
    }

    @Override
    protected void documentBuilderSpecificChecks(XProperty member, AbstractDocumentBuilder.PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, ConfigContext context) {
        this.checkDocumentId(member, propertiesMetadata, isRoot, prefix, context);
    }

    protected void checkDocumentId(XProperty member, AbstractDocumentBuilder.PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, ConfigContext context) {
        Annotation idAnnotation = this.getIdAnnotation(member, context);
        NumericField numericFieldAnn = (NumericField)member.getAnnotation(NumericField.class);
        if (idAnnotation != null) {
            String attributeName = this.getIdAttributeName(member, idAnnotation);
            if (isRoot) {
                if (this.explicitDocumentId) {
                    throw new SearchException("More than one @DocumentId specified on entity " + this.getBeanClass().getName());
                }
                if (idAnnotation instanceof DocumentId) {
                    this.explicitDocumentId = true;
                }
                this.idKeywordName = prefix + attributeName;
                FieldBridge fieldBridge = BridgeFactory.guessType(null, numericFieldAnn, (XMember)member, this.reflectionManager);
                if (!(fieldBridge instanceof TwoWayFieldBridge)) {
                    throw new SearchException("Bridge for document id does not implement TwoWayFieldBridge: " + member.getName());
                }
                this.idBridge = (TwoWayFieldBridge)fieldBridge;
                Float boost = AnnotationProcessingHelper.getBoost(member, null);
                if (boost != null) {
                    this.idBoost = boost.floatValue();
                }
                ReflectionHelper.setAccessible((XMember)member);
                this.idGetter = member;
            } else {
                ReflectionHelper.setAccessible((XMember)member);
                propertiesMetadata.fieldGetters.add((XMember)member);
                propertiesMetadata.fieldGetterNames.add(member.getName());
                String fieldName = prefix + attributeName;
                propertiesMetadata.fieldNames.add(fieldName);
                propertiesMetadata.fieldStore.add(Store.YES);
                Field.Index index = AnnotationProcessingHelper.getIndex(Index.YES, Analyze.NO, Norms.YES);
                propertiesMetadata.fieldIndex.add(index);
                propertiesMetadata.fieldTermVectors.add(AnnotationProcessingHelper.getTermVector(TermVector.NO));
                propertiesMetadata.fieldNullTokens.add(null);
                propertiesMetadata.fieldBridges.add(BridgeFactory.guessType(null, null, (XMember)member, this.reflectionManager));
                propertiesMetadata.fieldBoosts.add(AnnotationProcessingHelper.getBoost(member, null));
                propertiesMetadata.precisionSteps.add(this.getPrecisionStep(null));
                propertiesMetadata.dynamicFieldBoosts.add(AnnotationProcessingHelper.getDynamicBoost(member));
                Analyzer analyzer = AnnotationProcessingHelper.getAnalyzer((org.hibernate.search.annotations.Analyzer)member.getAnnotation(org.hibernate.search.annotations.Analyzer.class), context);
                if (analyzer == null) {
                    analyzer = propertiesMetadata.analyzer;
                }
                if (analyzer == null) {
                    throw new AssertionFailure("Analyzer should not be undefined");
                }
                this.addToScopedAnalyzer(fieldName, analyzer, index);
            }
        }
    }

    private Annotation getIdAnnotation(XProperty member, ConfigContext context) {
        Annotation idAnnotation = null;
        DocumentId documentIdAnn = (DocumentId)member.getAnnotation(DocumentId.class);
        if (documentIdAnn != null) {
            idAnnotation = documentIdAnn;
            this.documentIdAnnotatedMember = member;
        }
        if (context.isJpaPresent()) {
            Annotation jpaId;
            try {
                Class jpaIdClass = ReflectHelper.classForName((String)"javax.persistence.Id", ConfigContext.class);
                jpaId = member.getAnnotation(jpaIdClass);
            }
            catch (ClassNotFoundException e) {
                throw new SearchException("Unable to load @Id.class even though it should be present ?!");
            }
            if (jpaId != null) {
                this.jpaIdAnnotatedMember = member;
                if (documentIdAnn == null) {
                    log.debug("Found JPA id and using it as document id");
                    idAnnotation = jpaId;
                }
            }
        }
        return idAnnotation;
    }

    private ProvidedId findProvidedId(XClass clazz, ReflectionManager reflectionManager) {
        ProvidedId id = null;
        XClass currentClass = clazz;
        while (id == null && !reflectionManager.equals(currentClass, Object.class)) {
            id = (ProvidedId)currentClass.getAnnotation(ProvidedId.class);
            currentClass = currentClass.getSuperclass();
        }
        return id;
    }

    @Override
    public void addWorkToQueue(Class<T> entityClass, T entity, Serializable id, boolean delete, boolean add, List<LuceneWork> queue, ConversionContext contextualBridge) {
        String idInString = this.objectToString(this.idBridge, this.idKeywordName, (Object)id, contextualBridge);
        if (delete && !add) {
            queue.add(new DeleteLuceneWork(id, idInString, entityClass));
        } else if (add && !delete) {
            queue.add(this.createAddWork(entityClass, entity, id, idInString, this.instanceInitalizer, contextualBridge));
        } else if (add && delete) {
            queue.add(this.createUpdateWork(entityClass, entity, id, idInString, this.instanceInitalizer, contextualBridge));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String objectToString(TwoWayFieldBridge bridge, String fieldName, Object value, ConversionContext conversionContext) {
        String stringValue;
        conversionContext.pushProperty(fieldName);
        try {
            stringValue = conversionContext.setClass(this.getBeanClass()).twoWayConversionContext(bridge).objectToString(value);
        }
        finally {
            conversionContext.popProperty();
        }
        return stringValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String objectToString(StringBridge bridge, String fieldName, Object value, ConversionContext conversionContext) {
        String stringValue;
        conversionContext.pushProperty(fieldName);
        try {
            stringValue = conversionContext.setClass(this.getBeanClass()).stringConversionContext(bridge).objectToString(value);
        }
        finally {
            conversionContext.popProperty();
        }
        return stringValue;
    }

    public AddLuceneWork createAddWork(Class<T> entityClass, T entity, Serializable id, String idInString, InstanceInitializer sessionInitializer, ConversionContext conversionContext) {
        HashMap<String, String> fieldToAnalyzerMap = new HashMap<String, String>();
        Document doc = this.getDocument(entity, id, fieldToAnalyzerMap, sessionInitializer, conversionContext);
        AddLuceneWork addWork = fieldToAnalyzerMap.isEmpty() ? new AddLuceneWork(id, idInString, entityClass, doc) : new AddLuceneWork(id, idInString, entityClass, doc, fieldToAnalyzerMap);
        return addWork;
    }

    public UpdateLuceneWork createUpdateWork(Class<T> entityClass, T entity, Serializable id, String idInString, InstanceInitializer sessionInitializer, ConversionContext contextualBridge) {
        HashMap<String, String> fieldToAnalyzerMap = new HashMap<String, String>();
        Document doc = this.getDocument(entity, id, fieldToAnalyzerMap, sessionInitializer, contextualBridge);
        UpdateLuceneWork addWork = fieldToAnalyzerMap.isEmpty() ? new UpdateLuceneWork(id, idInString, entityClass, doc) : new UpdateLuceneWork(id, idInString, entityClass, doc, fieldToAnalyzerMap);
        return addWork;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getDocument(T instance, Serializable id, Map<String, String> fieldToAnalyzerMap, InstanceInitializer objectInitializer, ConversionContext conversionContext) {
        if (fieldToAnalyzerMap == null) {
            throw new IllegalArgumentException("fieldToAnalyzerMap cannot be null");
        }
        Document doc = new Document();
        this.instanceInitalizer.getClass(instance);
        Class<T> entityType = objectInitializer.getClass(instance);
        doc.setBoost(this.getMetadata().getClassBoost(instance));
        Field classField = new Field("_hibernate_class", entityType.getName(), Field.Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO);
        doc.add((Fieldable)classField);
        LuceneOptionsImpl luceneOptions = new LuceneOptionsImpl(Store.YES, Field.Index.NOT_ANALYZED_NO_NORMS, Field.TermVector.NO, this.idBoost);
        FieldBridge contextualizedBridge = conversionContext.oneWayConversionContext(this.idBridge);
        conversionContext.setClass(entityType);
        conversionContext.pushProperty(this.idKeywordName);
        try {
            contextualizedBridge.set(this.idKeywordName, id, doc, luceneOptions);
        }
        finally {
            conversionContext.popProperty();
        }
        HashSet<String> processedFieldNames = new HashSet<String>();
        this.buildDocumentFields(instance, doc, this.getMetadata(), fieldToAnalyzerMap, processedFieldNames, conversionContext, objectInitializer);
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void buildDocumentFields(Object instance, Document doc, AbstractDocumentBuilder.PropertiesMetadata propertiesMetadata, Map<String, String> fieldToAnalyzerMap, Set<String> processedFieldNames, ConversionContext conversionContext, InstanceInitializer objectInitializer) {
        unproxiedInstance = this.unproxy(instance, objectInitializer);
        for (i = 0; i < propertiesMetadata.classBridges.size(); ++i) {
            fb = propertiesMetadata.classBridges.get(i);
            fieldName = propertiesMetadata.classNames.get(i);
            oneWayConversionContext = conversionContext.oneWayConversionContext(fb);
            conversionContext.pushProperty(fieldName);
            try {
                oneWayConversionContext.set(fieldName, unproxiedInstance, doc, propertiesMetadata.getClassLuceneOptions(i));
                continue;
            }
            finally {
                conversionContext.popProperty();
            }
        }
        previousMember = null;
        currentFieldValue = null;
        for (i = 0; i < propertiesMetadata.fieldNames.size(); ++i) {
            member = propertiesMetadata.fieldGetters.get(i);
            if (previousMember != member) {
                currentFieldValue = ReflectionHelper.getMemberValue(unproxiedInstance, member);
                previousMember = member;
                if (member.isCollection()) {
                    if (currentFieldValue instanceof Collection) {
                        objectInitializer.initializeCollection((Collection)currentFieldValue);
                    } else if (currentFieldValue instanceof Map) {
                        objectInitializer.initializeMap((Map)currentFieldValue);
                    }
                }
            }
            fieldBridge = propertiesMetadata.fieldBridges.get(i);
            fieldName = propertiesMetadata.fieldNames.get(i);
            oneWayConversionContext = conversionContext.oneWayConversionContext(fieldBridge);
            conversionContext.pushProperty(propertiesMetadata.fieldGetterNames.get(i));
            try {
                oneWayConversionContext.set(fieldName, currentFieldValue, doc, propertiesMetadata.getFieldLuceneOptions(i, currentFieldValue));
                continue;
            }
            finally {
                conversionContext.popProperty();
            }
        }
        this.allowAnalyzerDiscriminatorOverride(doc, propertiesMetadata, fieldToAnalyzerMap, processedFieldNames, unproxiedInstance);
        block18: for (i = 0; i < propertiesMetadata.embeddedGetters.size(); ++i) {
            member = propertiesMetadata.embeddedGetters.get(i);
            conversionContext.pushProperty(propertiesMetadata.embeddedFieldNames.get(i));
            try {
                value = ReflectionHelper.getMemberValue(unproxiedInstance, member);
                if (value == null) {
                    this.processEmbeddedNullValue(doc, propertiesMetadata, conversionContext, i, member);
                    continue;
                }
                embeddedMetadata = propertiesMetadata.embeddedPropertiesMetadata.get(i);
                switch (1.$SwitchMap$org$hibernate$search$engine$spi$AbstractDocumentBuilder$PropertiesMetadata$Container[propertiesMetadata.embeddedContainers.get(i).ordinal()]) {
                    case 1: {
                        for (Object arrayValue : array = objectInitializer.initializeArray((Object[])value)) {
                            this.buildDocumentFields(arrayValue, doc, embeddedMetadata, fieldToAnalyzerMap, processedFieldNames, conversionContext, objectInitializer);
                        }
                        continue block18;
                    }
                    case 2: {
                        collection = objectInitializer.initializeCollection((Collection)value);
                        for (T collectionValue : collection) {
                            this.buildDocumentFields(collectionValue, doc, embeddedMetadata, fieldToAnalyzerMap, processedFieldNames, conversionContext, objectInitializer);
                        }
                        continue block18;
                    }
                    case 3: {
                        map = objectInitializer.initializeMap((Map)value);
                        for (V collectionValue : map.values()) {
                            this.buildDocumentFields(collectionValue, doc, embeddedMetadata, fieldToAnalyzerMap, processedFieldNames, conversionContext, objectInitializer);
                        }
                        continue block18;
                    }
                    case 4: {
                        this.buildDocumentFields(value, doc, embeddedMetadata, fieldToAnalyzerMap, processedFieldNames, conversionContext, objectInitializer);
                        ** break;
lbl74:
                        // 1 sources

                        continue block18;
                    }
                    default: {
                        throw new AssertionFailure("Unknown embedded container: " + (Object)propertiesMetadata.embeddedContainers.get(i));
                    }
                }
            }
            finally {
                conversionContext.popProperty();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEmbeddedNullValue(Document doc, AbstractDocumentBuilder.PropertiesMetadata propertiesMetadata, ConversionContext conversionContext, int i, XMember member) {
        String nullMarker = propertiesMetadata.embeddedNullTokens.get(i);
        if (nullMarker != null) {
            String fieldName = propertiesMetadata.embeddedNullFields.get(i);
            FieldBridge fieldBridge = propertiesMetadata.embeddedNullFieldBridges.get(i);
            FieldBridge contextualizedBridge = conversionContext.oneWayConversionContext(fieldBridge);
            conversionContext.pushProperty(fieldName);
            try {
                contextualizedBridge.set(fieldName, null, doc, NULL_EMBEDDED_MARKER_OPTIONS);
            }
            finally {
                conversionContext.popProperty();
            }
        }
    }

    private Object unproxy(Object instance, InstanceInitializer objectInitializer) {
        if (instance == null) {
            return null;
        }
        return objectInitializer.unproxy(instance);
    }

    private void allowAnalyzerDiscriminatorOverride(Document doc, AbstractDocumentBuilder.PropertiesMetadata propertiesMetadata, Map<String, String> fieldToAnalyzerMap, Set<String> processedFieldNames, Object unproxiedInstance) {
        Discriminator discriminator = propertiesMetadata.discriminator;
        if (discriminator == null) {
            return;
        }
        Object value = null;
        if (propertiesMetadata.discriminatorGetter != null) {
            value = ReflectionHelper.getMemberValue(unproxiedInstance, propertiesMetadata.discriminatorGetter);
        }
        for (Fieldable o : doc.getFields()) {
            Fieldable field = o;
            if (processedFieldNames.contains(field.name())) continue;
            String analyzerName = discriminator.getAnalyzerDefinitionName(value, unproxiedInstance, field.name());
            if (analyzerName != null) {
                fieldToAnalyzerMap.put(field.name(), analyzerName);
            }
            processedFieldNames.add(field.name());
        }
    }

    public String getIdentifierName() {
        return this.identifierName;
    }

    public boolean allowFieldSelectionInProjection() {
        return this.allowFieldSelectionInProjection;
    }

    public Set<FieldCacheType> getFieldCacheOption() {
        return this.fieldCacheUsage;
    }

    @Deprecated
    public Term getTerm(Serializable id) {
        ContextualExceptionBridgeHelper conversionContext = new ContextualExceptionBridgeHelper();
        return new Term(this.idKeywordName, this.objectToString(this.idBridge, this.idKeywordName, (Object)id, (ConversionContext)conversionContext));
    }

    public TwoWayFieldBridge getIdBridge() {
        return this.idBridge;
    }

    public String getIdKeywordName() {
        return this.idKeywordName;
    }

    @Override
    public Serializable getId(Object entity) {
        if (entity == null || this.idGetter == null || this.idProvided) {
            throw new IllegalStateException("Cannot guess id from entity");
        }
        Object unproxiedEntity = this.instanceInitalizer.unproxy(entity);
        return (Serializable)ReflectionHelper.getMemberValue(unproxiedEntity, this.idGetter);
    }

    public String objectToString(String fieldName, Object value, ConversionContext conversionContext) {
        if (fieldName == null) {
            throw new AssertionFailure("Field name should not be null");
        }
        if (fieldName.equals(this.idKeywordName)) {
            return this.objectToString(this.idBridge, this.idKeywordName, value, conversionContext);
        }
        FieldBridge bridge = this.getBridge(this.getMetadata(), fieldName);
        if (bridge != null) {
            Class<?> bridgeClass = bridge.getClass();
            if (TwoWayFieldBridge.class.isAssignableFrom(bridgeClass)) {
                return this.objectToString((TwoWayFieldBridge)bridge, fieldName, value, conversionContext);
            }
            if (StringBridge.class.isAssignableFrom(bridgeClass)) {
                return this.objectToString((StringBridge)((Object)bridge), fieldName, value, conversionContext);
            }
            throw new SearchException("FieldBridge " + bridgeClass + " does not have a objectToString method: field " + fieldName + " in " + this.getBeanXClass());
        }
        throw new SearchException("Unable to find field " + fieldName + " in " + this.getBeanXClass());
    }

    private FieldBridge getBridge(List<String> names, List<FieldBridge> bridges, String fieldName) {
        int index = names.indexOf(fieldName);
        if (index != -1) {
            return bridges.get(index);
        }
        return null;
    }

    public FieldBridge getBridge(String fieldName) {
        return this.getBridge(this.getMetadata(), fieldName);
    }

    private FieldBridge getBridge(AbstractDocumentBuilder.PropertiesMetadata metadata, String fieldName) {
        FieldBridge fieldBridge = this.getBridge(metadata.fieldNames, metadata.fieldBridges, fieldName);
        if (fieldBridge != null) {
            return fieldBridge;
        }
        int nbrOfEmbeddedObjects = metadata.embeddedPropertiesMetadata.size();
        for (int index = 0; index < nbrOfEmbeddedObjects; ++index) {
            fieldBridge = this.getBridge(metadata.embeddedPropertiesMetadata.get(index), fieldName);
            if (fieldBridge == null) continue;
            return fieldBridge;
        }
        fieldBridge = this.getBridge(metadata.embeddedNullFields, metadata.embeddedNullFieldBridges, fieldName);
        if (fieldBridge != null) {
            return fieldBridge;
        }
        fieldBridge = this.getBridge(metadata.classNames, metadata.classBridges, fieldName);
        if (fieldBridge != null) {
            return fieldBridge;
        }
        return null;
    }

    private void checkAllowFieldSelection() {
        this.allowFieldSelectionInProjection = true;
        if (!(this.idBridge instanceof TwoWayStringBridge || this.idBridge instanceof TwoWayString2FieldBridgeAdaptor || this.idBridge instanceof NumericFieldBridge)) {
            this.allowFieldSelectionInProjection = false;
            return;
        }
        for (FieldBridge bridge : this.getMetadata().fieldBridges) {
            if (bridge instanceof TwoWayStringBridge || bridge instanceof TwoWayString2FieldBridgeAdaptor || bridge instanceof NumericFieldBridge) continue;
            this.allowFieldSelectionInProjection = false;
            return;
        }
        for (FieldBridge bridge : this.getMetadata().classBridges) {
            if (bridge instanceof TwoWayStringBridge || bridge instanceof TwoWayString2FieldBridgeAdaptor || bridge instanceof NumericFieldBridge) continue;
            this.allowFieldSelectionInProjection = false;
            return;
        }
    }

    private String getIdAttributeName(XProperty member, Annotation idAnnotation) {
        String name = null;
        try {
            Method m = idAnnotation.getClass().getMethod("name", new Class[0]);
            name = (String)m.invoke((Object)idAnnotation, new Object[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        return ReflectionHelper.getAttributeName((XMember)member, name);
    }

    @Override
    public boolean requiresProvidedId() {
        return this.idProvided;
    }

    @Override
    public boolean isIdMatchingJpaId() {
        return !this.idProvided && (this.documentIdAnnotatedMember == null || this.documentIdAnnotatedMember.equals(this.jpaIdAnnotatedMember));
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$hibernate$search$engine$spi$AbstractDocumentBuilder$PropertiesMetadata$Container;

        static {
            $SwitchMap$org$hibernate$search$engine$spi$AbstractDocumentBuilder$PropertiesMetadata$Container = new int[AbstractDocumentBuilder.PropertiesMetadata.Container.values().length];
            try {
                1.$SwitchMap$org$hibernate$search$engine$spi$AbstractDocumentBuilder$PropertiesMetadata$Container[AbstractDocumentBuilder.PropertiesMetadata.Container.ARRAY.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$hibernate$search$engine$spi$AbstractDocumentBuilder$PropertiesMetadata$Container[AbstractDocumentBuilder.PropertiesMetadata.Container.COLLECTION.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$hibernate$search$engine$spi$AbstractDocumentBuilder$PropertiesMetadata$Container[AbstractDocumentBuilder.PropertiesMetadata.Container.MAP.ordinal()] = 3;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$hibernate$search$engine$spi$AbstractDocumentBuilder$PropertiesMetadata$Container[AbstractDocumentBuilder.PropertiesMetadata.Container.OBJECT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

