/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.impl.lucene;

import java.io.IOException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.IndexReader;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.backend.impl.lucene.AbstractWorkspaceImpl;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.DirectoryBasedReaderProvider;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class NRTWorkspaceImpl
extends AbstractWorkspaceImpl
implements DirectoryBasedReaderProvider {
    private static final Log log = LoggerFactory.make();
    private final ReentrantLock writeLock = new ReentrantLock();
    private final AtomicReference<IndexReader> currentReader = new AtomicReference();
    private boolean shutdown = false;

    public NRTWorkspaceImpl(DirectoryBasedIndexManager indexManager, WorkerBuildContext buildContext, Properties cfg) {
        super(indexManager, buildContext, cfg);
    }

    @Override
    public void afterTransactionApplied(boolean someFailureHappened, boolean streaming) {
        if (someFailureHappened) {
            this.writerHolder.forceLockRelease();
        } else if (!streaming) {
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IndexReader openIndexReader() {
        IndexReader indexReader = this.currentReader.get();
        if (indexReader == null) {
            this.writeLock.lock();
            try {
                if (this.shutdown) {
                    throw new AssertionFailure("IndexReader requested after ReaderProvider is shutdown");
                }
                indexReader = this.currentReader.get();
                if (indexReader == null) {
                    indexReader = this.writerHolder.openDirectoryIndexReader();
                    this.currentReader.set(indexReader);
                }
            }
            finally {
                this.writeLock.unlock();
            }
        }
        indexReader.incRef();
        return indexReader;
    }

    @Override
    public void closeIndexReader(IndexReader reader) {
        if (reader == null) {
            return;
        }
        try {
            reader.decRef();
        }
        catch (IOException e) {
            log.unableToCloseLuceneIndexReader(e);
        }
    }

    @Override
    public void initialize(DirectoryBasedIndexManager indexManager, Properties props) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.writeLock.lock();
        try {
            IndexReader oldReader = this.currentReader.getAndSet(null);
            this.closeIndexReader(oldReader);
            this.shutdown = true;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void flush() {
        IndexReader newIndexReader = this.writerHolder.openNRTIndexReader(true);
        IndexReader oldReader = this.currentReader.getAndSet(newIndexReader);
        try {
            if (oldReader != null) {
                oldReader.close();
            }
        }
        catch (IOException e) {
            log.unableToCloseLuceneIndexReader(e);
        }
    }
}

