/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.spi.BuildContext;
import org.hibernate.search.spi.ServiceProvider;
import org.hibernate.search.util.impl.ClassLoaderHelper;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class ServiceManager {
    private static final String SERVICES_FILE = "META-INF/services/" + ServiceProvider.class.getName();
    private static final Log log = LoggerFactory.make();
    private final HashSet<Class<?>> availableProviders = new HashSet();
    private final ConcurrentHashMap<Class<?>, ServiceProviderWrapper<?>> managedProviders = new ConcurrentHashMap();
    private final Map<Class<? extends ServiceProvider<?>>, Object> providedProviders = new HashMap();
    private final Properties properties;

    public ServiceManager(SearchConfiguration cfg) {
        this.properties = cfg.getProperties();
        this.providedProviders.putAll(cfg.getProvidedServices());
        this.listAndInstantiateServiceProviders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listAndInstantiateServiceProviders() {
        Enumeration<URL> resources = ClassLoaderHelper.getResources(SERVICES_FILE, ServiceManager.class);
        try {
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream stream = url.openStream();
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(stream), 100);
                    String name = reader.readLine();
                    while (name != null) {
                        if (!(name = name.trim()).startsWith("#")) {
                            Class<?> serviceProviderClass = ClassLoaderHelper.classForName(name, ServiceManager.class.getClassLoader(), "service provider");
                            this.availableProviders.add(serviceProviderClass);
                        }
                        name = reader.readLine();
                    }
                }
                finally {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new SearchException("Unable to read " + SERVICES_FILE, e);
        }
    }

    public <T> T requestService(Class<? extends ServiceProvider<T>> serviceProviderClass, BuildContext context) {
        if (this.providedProviders.containsKey(serviceProviderClass)) {
            return (T)this.providedProviders.get(serviceProviderClass);
        }
        ServiceProviderWrapper<Object> wrapper = this.managedProviders.get(serviceProviderClass);
        if (wrapper == null) {
            if (this.availableProviders.contains(serviceProviderClass)) {
                ServiceProvider serviceProvider = ClassLoaderHelper.instanceFromClass(ServiceProvider.class, serviceProviderClass, "service provider");
                wrapper = new ServiceProviderWrapper(serviceProvider, context, serviceProviderClass);
                this.managedProviders.putIfAbsent(serviceProviderClass, wrapper);
            } else {
                throw new SearchException("Unable to find service related to " + serviceProviderClass);
            }
        }
        wrapper = this.managedProviders.get(serviceProviderClass);
        wrapper.startVirtual();
        return (T)wrapper.getService();
    }

    public void releaseService(Class<? extends ServiceProvider<?>> serviceProviderClass) {
        if (this.providedProviders.containsKey(serviceProviderClass)) {
            return;
        }
        ServiceProviderWrapper<?> wrapper = this.managedProviders.get(serviceProviderClass);
        if (wrapper == null) {
            throw new AssertionFailure("Unable to find service related to " + serviceProviderClass);
        }
        wrapper.stopVirtual();
    }

    public void stopServices() {
        for (ServiceProviderWrapper<?> wrapper : this.managedProviders.values()) {
            wrapper.ensureStopped();
        }
    }

    private static enum ServiceStatus {
        RUNNING,
        STOPPED,
        STARTING,
        STOPPING;

    }

    private class ServiceProviderWrapper<S> {
        private final ServiceProvider<S> serviceProvider;
        private final BuildContext context;
        private final Class<? extends ServiceProvider<S>> serviceProviderClass;
        private int userCounter = 0;
        private ServiceStatus status = ServiceStatus.STOPPED;

        ServiceProviderWrapper(ServiceProvider<S> serviceProvider, BuildContext context, Class<? extends ServiceProvider<S>> serviceProviderClass) {
            this.serviceProvider = serviceProvider;
            this.context = context;
            this.serviceProviderClass = serviceProviderClass;
        }

        synchronized S getService() {
            if (this.status != ServiceStatus.RUNNING) {
                this.stateExpectedFailure();
            }
            return this.serviceProvider.getService();
        }

        synchronized void startVirtual() {
            int previousValue;
            if ((previousValue = this.userCounter++) == 0) {
                if (this.status != ServiceStatus.STOPPED) {
                    this.stateExpectedFailure();
                }
                this.status = ServiceStatus.STARTING;
                this.serviceProvider.start(ServiceManager.this.properties, this.context);
                this.status = ServiceStatus.RUNNING;
            }
            if (this.status != ServiceStatus.RUNNING) {
                this.stateExpectedFailure();
            }
        }

        synchronized void stopVirtual() {
            --this.userCounter;
            if (this.userCounter == 0) {
                if (this.status != ServiceStatus.RUNNING) {
                    this.stateExpectedFailure();
                }
                this.status = ServiceStatus.STOPPING;
                this.forceStop();
                this.status = ServiceStatus.STOPPED;
                ServiceManager.this.managedProviders.remove(this.serviceProviderClass);
            } else if (this.status != ServiceStatus.RUNNING) {
                this.stateExpectedFailure();
            }
        }

        synchronized void ensureStopped() {
            if (this.status != ServiceStatus.STOPPED) {
                log.serviceProviderNotReleased(this.serviceProviderClass);
                this.forceStop();
            }
        }

        private void forceStop() {
            try {
                this.serviceProvider.stop();
            }
            catch (Exception e) {
                log.stopServiceFailed(this.serviceProviderClass, e);
            }
        }

        private void stateExpectedFailure() {
            throw new AssertionFailure("Unexpected status '" + (Object)((Object)this.status) + "' for serviceProvider '" + this.serviceProvider + "'." + " Check for circular dependencies or unreleased resources in your services.");
        }
    }
}

