/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial;

import java.util.Map;
import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.ParameterizedBridge;
import org.hibernate.search.spatial.Coordinates;
import org.hibernate.search.spatial.impl.GridHelper;
import org.hibernate.search.spatial.impl.Point;

public class SpatialFieldBridgeByGrid
implements FieldBridge,
ParameterizedBridge {
    public static final int DEFAULT_TOP_GRID_LEVEL = 0;
    public static final int DEFAULT_BOTTOM_GRID_LEVEL = 16;
    private int topGridLevel = 0;
    private int bottomGridLevel = 16;
    private boolean gridIndex = true;
    private boolean numericFieldsIndex = true;

    public SpatialFieldBridgeByGrid() {
    }

    public SpatialFieldBridgeByGrid(int topGridLevel, int bottomGridLevel) {
        this.topGridLevel = topGridLevel;
        this.bottomGridLevel = bottomGridLevel;
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value != null) {
            Coordinates coordinates = (Coordinates)value;
            Double latitude = coordinates.getLatitude();
            Double longitude = coordinates.getLongitude();
            if (latitude != null && longitude != null) {
                if (this.gridIndex) {
                    Point point = Point.fromDegrees(latitude, longitude);
                    for (int i = this.topGridLevel; i <= this.bottomGridLevel; ++i) {
                        luceneOptions.addFieldToDocument(GridHelper.formatFieldName(i, name), GridHelper.getGridCellId(point, i), document);
                    }
                }
                if (this.numericFieldsIndex) {
                    luceneOptions.addNumericFieldToDocument(GridHelper.formatLatitude(name), latitude, document);
                    luceneOptions.addNumericFieldToDocument(GridHelper.formatLongitude(name), longitude, document);
                }
            }
        }
    }

    public void setParameterValues(Map parameters) {
        Object numericFieldsIndex;
        Object gridIndex;
        Object bottomGridLevel;
        Object topGridLevel = parameters.get("topGridLevel");
        if (topGridLevel instanceof Integer) {
            this.topGridLevel = (Integer)topGridLevel;
        }
        if ((bottomGridLevel = parameters.get("bottomGridLevel")) instanceof Integer) {
            this.bottomGridLevel = (Integer)bottomGridLevel;
        }
        if ((gridIndex = parameters.get("gridIndex")) instanceof Boolean) {
            this.gridIndex = (Boolean)gridIndex;
        }
        if ((numericFieldsIndex = parameters.get("numericFieldsIndex")) instanceof Boolean) {
            this.numericFieldsIndex = (Boolean)numericFieldsIndex;
        }
    }
}

