/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial;

import org.apache.lucene.document.Document;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.spatial.Coordinates;

public class SpatialFieldBridgeByRange
implements FieldBridge {
    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value != null) {
            Coordinates coordinates = (Coordinates)value;
            Double latitude = coordinates.getLatitude();
            Double longitude = coordinates.getLongitude();
            if (latitude != null && longitude != null) {
                luceneOptions.addNumericFieldToDocument(name + "_HSSI_Latitude", latitude, document);
                luceneOptions.addNumericFieldToDocument(name + "_HSSI_Longitude", longitude, document);
            }
        }
    }
}

