/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.Filter;
import org.apache.lucene.util.OpenBitSet;

public final class GridFilter
extends Filter {
    private final List<String> gridCellsIds;
    private final String fieldName;

    public GridFilter(List<String> gridCellsIds, String fieldName) {
        this.gridCellsIds = gridCellsIds;
        this.fieldName = fieldName;
    }

    public DocIdSet getDocIdSet(IndexReader reader) throws IOException {
        if (this.gridCellsIds.size() == 0) {
            return null;
        }
        OpenBitSet matchedDocumentsIds = new OpenBitSet((long)reader.maxDoc());
        Boolean found = false;
        for (int i = 0; i < this.gridCellsIds.size(); ++i) {
            Term gridCellTerm = new Term(this.fieldName, this.gridCellsIds.get(i));
            TermDocs gridCellsDocs = reader.termDocs(gridCellTerm);
            if (gridCellsDocs == null) continue;
            while (gridCellsDocs.next()) {
                matchedDocumentsIds.fastSet(gridCellsDocs.doc());
                found = true;
            }
        }
        if (found.booleanValue()) {
            return matchedDocumentsIds;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("GridFilter");
        sb.append("{gridCellsIds=").append(this.gridCellsIds);
        sb.append(", fieldName='").append(this.fieldName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

