/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.lang.annotation.ElementType;
import junit.framework.Assert;
import org.hibernate.search.SearchException;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.store.optimization.impl.ExplicitOnlyOptimizerStrategy;
import org.hibernate.search.store.optimization.impl.IncrementalOptimizerStrategy;
import org.hibernate.search.test.util.ManualConfiguration;
import org.junit.Test;

public class OptimizerStrategyLoadTest {
    @Test
    public void testDefaultImplementation() {
        ManualConfiguration cfg = new ManualConfiguration();
        cfg.addProperty("hibernate.search.default.optimizer.implementation", "default");
        this.verifyOptimizerImplementationIs(ExplicitOnlyOptimizerStrategy.class, cfg);
    }

    @Test
    public void testUnsetImplementation() {
        ManualConfiguration cfg = new ManualConfiguration();
        this.verifyOptimizerImplementationIs(ExplicitOnlyOptimizerStrategy.class, cfg);
    }

    @Test
    public void testIncrementalImplementation() {
        ManualConfiguration cfg = new ManualConfiguration();
        cfg.addProperty("hibernate.search.default.optimizer.transaction_limit.max", "5");
        this.verifyOptimizerImplementationIs(IncrementalOptimizerStrategy.class, cfg);
    }

    @Test(expected=SearchException.class)
    public void testIllegalImplementation() {
        ManualConfiguration cfg = new ManualConfiguration();
        cfg.addProperty("hibernate.search.default.optimizer.implementation", "5");
        this.verifyOptimizerImplementationIs(IncrementalOptimizerStrategy.class, cfg);
    }

    @Test
    public void testValidExtension() {
        ManualConfiguration cfg = new ManualConfiguration();
        cfg.addProperty("hibernate.search.default.optimizer.implementation", CustomOptimizer.class.getName());
        this.verifyOptimizerImplementationIs(CustomOptimizer.class, cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyOptimizerImplementationIs(Class type, ManualConfiguration cfg) {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Document.class).indexed().property("id", ElementType.FIELD).documentId().property("title", ElementType.FIELD).field();
        cfg.setProgrammaticMapping(mapping);
        cfg.addProperty("hibernate.search.default.directory_provider", "ram");
        cfg.addClass(Document.class);
        SearchFactoryImplementor sf = new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();
        try {
            EntityIndexBinder indexBindingForEntity = sf.getIndexBindingForEntity(Document.class);
            DirectoryBasedIndexManager indexManager = (DirectoryBasedIndexManager)indexBindingForEntity.getIndexManagers()[0];
            OptimizerStrategy optimizerStrategy = indexManager.getOptimizerStrategy();
            Assert.assertTrue((boolean)type.isAssignableFrom(optimizerStrategy.getClass()));
        }
        finally {
            sf.close();
        }
    }

    public static final class CustomOptimizer
    extends IncrementalOptimizerStrategy {
    }

    public static final class Document {
        private long id;
        private String title;
    }
}

