/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.jmx;

import java.io.File;
import java.lang.management.ManagementFactory;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import junit.framework.Assert;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.jmx.StatisticsInfo;
import org.hibernate.search.jmx.impl.JMXRegistrar;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.test.TestConstants;
import org.hibernate.search.test.util.ManualConfiguration;
import org.hibernate.search.test.util.TestForIssue;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1026")
public class MultipleStatisticsMBeanTest {
    private static File simpleJndiDir;
    private static MBeanServer mbeanServer;

    @BeforeClass
    public static void beforeClass() {
        File targetDir = TestConstants.getTargetDir();
        simpleJndiDir = new File(targetDir, "simpleJndi");
        simpleJndiDir.mkdir();
        mbeanServer = ManagementFactory.getPlatformMBeanServer();
    }

    @AfterClass
    public static void afterClass() {
        simpleJndiDir.delete();
    }

    @Test
    public void testDefaultRegistration() throws Exception {
        String suffix = null;
        SearchFactoryImplementor searchFactory = this.createSearchFactoryUsingJndiPrefix(suffix);
        this.testStatisticsMBeanRegistered(suffix);
        searchFactory.close();
    }

    @Test
    public void testRegistrationWithSuffix() throws Exception {
        String suffix = "myapp";
        SearchFactoryImplementor searchFactory = this.createSearchFactoryUsingJndiPrefix(suffix);
        this.testStatisticsMBeanRegistered(suffix);
        searchFactory.close();
    }

    @Test
    public void testMultipleMbeanRegistration() throws Exception {
        String suffixApp1 = "app-1";
        SearchFactoryImplementor factory1 = this.createSearchFactoryUsingJndiPrefix(suffixApp1);
        this.testStatisticsMBeanRegistered(suffixApp1);
        String suffixApp2 = "app-2";
        SearchFactoryImplementor factory2 = this.createSearchFactoryUsingJndiPrefix(suffixApp2);
        this.testStatisticsMBeanRegistered(suffixApp2);
        factory1.close();
        factory2.close();
    }

    @Test
    public void testStatisticMBeanGetsUnregistered() throws Exception {
        String suffix = "myapp";
        SearchFactoryImplementor searchFactory = this.createSearchFactoryUsingJndiPrefix(suffix);
        this.testStatisticsMBeanRegistered(suffix);
        searchFactory.close();
        this.testStatisticsMBeanUnregistered(suffix);
    }

    private void testStatisticsMBeanUnregistered(String suffix) throws Exception {
        String objectName = JMXRegistrar.buildMBeanName((String)"org.hibernate.search.jmx:type=StatisticsInfoMBean", (String)suffix);
        ObjectName statisticsBeanObjectName = new ObjectName(objectName);
        Assert.assertFalse((String)"The MBean should be unregistered", (boolean)mbeanServer.isRegistered(statisticsBeanObjectName));
    }

    private void testStatisticsMBeanRegistered(String suffix) throws Exception {
        String objectName = JMXRegistrar.buildMBeanName((String)"org.hibernate.search.jmx:type=StatisticsInfoMBean", (String)suffix);
        ObjectName statisticsBeanObjectName = new ObjectName(objectName);
        ObjectInstance mBean = null;
        try {
            mBean = mbeanServer.getObjectInstance(statisticsBeanObjectName);
        }
        catch (InstanceNotFoundException e) {
            Assert.fail((String)("The mbean " + statisticsBeanObjectName.getCanonicalName() + " should be registered with the MBean server "));
        }
        Assert.assertEquals((String)StatisticsInfo.class.getName(), (String)mBean.getClassName());
    }

    private SearchFactoryImplementor createSearchFactoryUsingJndiPrefix(String suffix) {
        ManualConfiguration configuration = new ManualConfiguration().addProperty("hibernate.search.default.directory_provider", "ram").addProperty("hibernate.session_factory_name", "java:comp/SessionFactory").addProperty("hibernate.jndi.class", "org.osjava.sj.SimpleContextFactory").addProperty("hibernate.jndi.org.osjava.sj.root", simpleJndiDir.getAbsolutePath()).addProperty("hibernate.jndi.org.osjava.sj.jndi.shared", "true").addProperty("hibernate.search.jmx_enabled", "true");
        if (suffix != null) {
            configuration.addProperty("hibernate.search.jmx_bean_suffix", suffix);
        }
        return new SearchFactoryBuilder().configuration((SearchConfiguration)configuration).buildSearchFactory();
    }
}

