/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.programmaticmapping;

import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.test.util.ManualConfiguration;
import org.junit.rules.ExternalResource;

public class TestingSearchFactoryHolder
extends ExternalResource {
    private final SearchMapping buildMappingDefinition;
    private SearchFactoryImplementor sf;
    private final Class<?>[] entities;

    public TestingSearchFactoryHolder(Class<?> ... entities) {
        this((SearchMapping)null, entities);
    }

    public TestingSearchFactoryHolder(SearchMapping buildMappingDefinition, Class<?> ... entities) {
        this.buildMappingDefinition = buildMappingDefinition;
        this.entities = entities;
    }

    public SearchFactoryImplementor getSearchFactory() {
        return this.sf;
    }

    protected void before() throws Throwable {
        ManualConfiguration cfg = new ManualConfiguration();
        cfg.setProgrammaticMapping(this.buildMappingDefinition);
        cfg.addProperty("hibernate.search.default.directory_provider", "ram");
        for (Class<?> c : this.entities) {
            cfg.addClass(c);
        }
        this.sf = new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();
    }

    protected void after() {
        this.sf.close();
    }
}

