/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.logging.impl;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import org.apache.lucene.index.CorruptIndexException;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.errors.EmptyQueryException;
import org.hibernate.search.util.logging.impl.Log;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Serializable,
Log,
BasicLogger {
    private static final long serialVersionUID = 1L;
    private static final String projectCode = "HSEARCH";
    private static final String FQCN = Log_$logger.class.getName();
    private static final String cannotHaveTwoSpatialsWithDefaultOrSameName = "Class %1$s cannot have two @Spatial using default/same name";
    private static final String unableToSerializeInAvro = "Unable to serialize Lucene works in Avro";
    private static final String indexingDocumentsCompleted = "%1$d documents indexed in %2$d ms";
    private static final String failedSlaveDirectoryProviderInitialization = "Failed to initialize SlaveDirectoryProvider %1$s";
    private static final String unableToSendJMSWork = "Unable to send Search work to JMS queue '%2$s' for index '%1$s'";
    private static final String targetedFieldNotSpatial = "The field used for the spatial query is not using SpatialFieldBridge: %1$s.%2$s";
    private static final String unableToSerializeLuceneWorks = "Unable to serialize List<LuceneWork>";
    private static final String messageReceivedForUndefinedIndex = "Received a remote message about an unknown index '%1$s': discarding message!";
    private static final String unableToConfigureTikaBridge = "Unable to configure %1$s";
    private static final String forceSkipIndexOperationViaInterception = "Interceptor enforces skip index operation %2$s on instance of class %1$s";
    private static final String needAtLeastOneIndexedEntityType = "At least one entity type must be provided: can't open an IndexReader on nothing";
    private static final String jGroupsConfigurationNotFoundInProperties = "Unable to use any JGroups configuration mechanisms provided in properties %1$s. Using default JGroups configuration file!";
    private static final String unableToConvertSerializableTermVectorToLuceneTermVector = "Unable to convert serializable TermVector to Lucene TermVector: %1$s";
    private static final String exceptionDuringIndexMergeOperation = "Exception during index Merge operation";
    private static final String ambiguousLongitudeDefinition = "@Longitude definition for class '%1$s' is ambiguous: specified on both fields '%2$s' and '%3$s'";
    private static final String unexpectedErrorInLuceneBackend = "Unexpected error in Lucene Backend:";
    private static final String unableToCloseSearcherDuringQuery = "Unable to properly close searcher during lucene query: %1$s";
    private static final String fieldBridgeNotAnInstanceof = "FieldBridge passed in is not an instance of %1$s";
    private static final String shuttingDownBackend = "Shutting down backend for IndexManager '%1$s'";
    private static final String unableToSynchronizeSource = "Unable to synchronize source of %1$s";
    private static final String failToDeserializeObject = "Fail to deserialize object";
    private static final String massIndexerUnexpectedErrorMessage = "Unexpected error during MassIndexer operation";
    private static final String noFieldBridgeInterfaceImplementedByFieldBridge = "@FieldBridge implementation implements none of the field bridge interfaces: %1$s in %2$s";
    private static final String unableToRemovePreviousMarket = "Unable to remove previous marker file from source of %1$s";
    private static final String unexpectedValueMissingFromFieldCache = "Unexpected: value is missing from FieldCache. This is likely a bug in the FieldCache implementation, Hibernate Search might have to workaround this by slightly inaccurate faceting values or reduced performance.";
    private static final String jGroupsFlushNotPresentInStack = "FLUSH is not present in your JGroups stack!  FLUSH is needed to ensure messages are not dropped while new nodes join the cluster.  Will proceed, but inconsistencies may arise!";
    private static final String incorrectMessageType = "Incorrect message type: %1$s";
    private static final String jGroupsConnectedToCluster = "Connected to cluster [ %1$s ]. The node address is %2$s";
    private static final String recommendConfiguringLuceneVersion = "Configuration setting hibernate.search.lucene_version was not specified, using LUCENE_CURRENT.";
    private static final String serializationProtocol = "Serialization protocol version %1$d.%2$d initialized";
    private static final String nullIsInvalidIndexedType = "'null' is not a valid indexed type";
    private static final String initializedBlackholeBackend = "initialized \"blackhole\" backend. Index changes will be prepared but discarded!";
    private static final String spatialFieldNameNotDefined = "Spatial field name not defined for class level annotation on class %1$s";
    private static final String noCurrentMarkerInSourceDirectory = "No current marker in source directory. Has the master being started already?";
    private static final String cannotSerializeCustomField = "Cannot serialize custom Fieldable '%1$s'. Must be NumericField, Field or a Serializable Fieldable implementation.";
    private static final String unableToReadTokenStream = "Unable to read TokenStream";
    private static final String unableToConvertSerializableStoreToLuceneStore = "Unable to convert serializable Store to Lucene Store: %1$s";
    private static final String illegalObjectRetrievedFromMessage = "Illegal object retrieved from message";
    private static final String attributeNotRecognizedNorSerializable = "Attribute type is not recognized and not serializable: %1$s";
    private static final String terminatingBatchWorkCanCauseInconsistentState = "Terminating batch work! Index might end up in inconsistent state.";
    private static final String notChangeTimestamp = "Could not change timestamp for %1$s. Index synchronization may be slow.";
    private static final String cannotExtractCoordinateFromObject = "Class %1$s does not implement the Coordinates interface";
    private static final String optimizationSkippedStillBusy = "Skipping optimization on index %1$s as it is already being optimized";
    private static final String cannotInstantiateClassBridgeOfType = "Unable to instantiate ClassBridge of type %1$s defined on %2$s";
    private static final String unableConnectingToJGroupsCluster = "Unable to connect to: [%1$s] JGroups channel";
    private static final String noFieldBridgeInterfaceImplementedByClassBridge = "@ClassBridge implementation '%1$s' should implement either org.hibernate.search.bridge.FieldBridge, org.hibernate.search.bridge.TwoWayStringBridge or org.hibernate.search.bridge.StringBridge";
    private static final String unableToStartSerializationLayer = "Unable to start serialization layer";
    private static final String missingJGroupsMuxId = "Configured JGroups channel is a Muxer! MuxId option is required: define 'hibernate.search.services.jgroups.mux_id'.";
    private static final String updatedDirectoryProviders = "update DirectoryProviders \"blackhole\" backend. Index changes will be prepared but discarded!";
    private static final String errorDuringBatchIndexing = "Error during batch indexing: ";
    private static final String backendError = "Error in backend";
    private static final String receivedEmptyLuceneWorksInMessage = "Received null or empty Lucene works list in message.";
    private static final String cannotOpenIndexWriterCausePreviousError = "Couldn't open the IndexWriter because of previous error: operation skipped, index ouf of sync!";
    private static final String noImplementationClassInFieldBridge = "@FieldBridge with no implementation class defined in: %1$s";
    private static final String incompatibleProtocolVersion = "Unable to parse message from protocol version %1$d.%2$d. Current protocol version: %3$d.%4$d";
    private static final String ambiguousLatitudeDefinition = "@Latitude definition for class '%1$s' is ambiguous: specified on both fields '%2$s' and '%3$s'";
    private static final String fileIsADirectory = "%1$s is a directory and not a file";
    private static final String forcingReleaseIndexWriterLock = "Going to force release of the IndexWriter lock";
    private static final String duplicateDocumentIdFound = "More than one @DocumentId specified on entity '%1$s'";
    private static final String serviceProviderNotReleased = "Service provider has been used but not released: %1$s";
    private static final String cannotGuessTransactionStatus = "Cannot guess the Transaction Status: not starting a JTA transaction";
    private static final String version = "Hibernate Search %1$s";
    private static final String directoryProviderExceptionOnStop = "DirectoryProvider raises an exception on stop() ";
    private static final String unableToCloseLuceneDirectory = "Unable to properly close Lucene directory %1$s";
    private static final String indexingSpeed = "Indexing speed: %1$f documents/second; progress: %2$.2f%%";
    private static final String jGroupsDefaultConfigurationFileNotFound = "Default JGroups configuration file was not found. Attempt to start JGroups channel with default configuration!";
    private static final String unableToRetrieveNamedAnalyzer = "Unable to retrieve named analyzer: %1$s";
    private static final String pushedChangesOutOfTransaction = "It appears changes are being pushed to the index out of a transaction. Register the IndexWorkFlushEventListener listener on flush to correctly manage Collections!";
    private static final String ioExceptionOnIndex = "An IOException happened while accessing the Lucene index '%1$s'";
    private static final String unableToUnregisterExistingMBean = "Unable to un-register existing MBean: %1$s";
    private static final String failToSerializeObject = "Fail to serialize object of type %1$s";
    private static final String unknownNumericFieldType = "Unknown NumericField type: %1$s";
    private static final String indexingCompletedAndMBeanUnregistered = "Indexing completed. Reindexed %1$d entities. Unregistering MBean from server";
    private static final String jGroupsMuxIdAlreadyTaken = "MuxId '%1$d' configured on the JGroups was already taken. Can't register handler!";
    private static final String indexingEntitiesCompleted = "Reindexed %1$d entities";
    private static final String unableToSendWorkViaJGroups = "Unable to send Lucene update work via JGroups cluster";
    private static final String readerProviderExceptionOnDestroy = "ReaderProvider raises an exception on destroy()";
    private static final String fieldLooksBinaryButDecompressionFailed = "Field %1$s looks like binary but couldn't be decompressed";
    private static final String unableToStartJGroupsChannel = "Unable to start JGroups channel";
    private static final String forceUpdateOnIndexOperationViaInterception = "Interceptor enforces update of index data instead of index operation %2$s on instance of class %1$s";
    private static final String ioExceptionOnIndexWriter = "IOException on the IndexWriter";
    private static final String requestedIndexNotDefined = "Index names %1$s is not defined";
    private static final String nullIsInvalidIndexName = "'null' is not a valid index name";
    private static final String unableToInitializeIndexManager = "Unable to initialize IndexManager %1$s";
    private static final String unknownMapBridgeForResolution = "Unknown MapBridge for resolution: %1$s";
    private static final String cannotGetResultSizeWithCriteriaAndRestriction = "Cannot safely compute getResultSize() when a Criteria with restriction is used. Use query.list().size() or query.getResultList().size(). Criteria at stake: %1$s";
    private static final String unableToInstantiateFieldBridge = "Unable to instantiate FieldBridge for %1$s of class %2$s";
    private static final String unableToConvertSerializableIndexToLuceneIndex = "Unable to convert serializable Index to Lucene Index: %1$s";
    private static final String fileDoesNotExist = "File %1$s does not exist";
    private static final String cantOpenCorruptedIndex = "Could not open Lucene index: index data is corrupted. index name: '%1$s'";
    private static final String foundCurrentMarker = "Found current marker in source directory - initialization succeeded";
    private static final String unableToCloseSearcherInScrollableResult = "Unable to properly close searcher in ScrollableResults";
    private static final String jGroupsChannelCreationFromStringError = "Error while trying to create a channel using config string: %1$s";
    private static final String unknownFullTextFilter = "Unknown @FullTextFilter: '%1$s'";
    private static final String eventListenerWontBeRegistered = "Property hibernate.search.autoregister_listeners is set to false. No attempt will be made to register Hibernate Search event listeners.";
    private static final String unableToCloseJmsConnection = "Unable to close JMS connection for %1$s";
    private static final String unableToLoadResource = "Could not load resource: '%1$s'";
    private static final String warnSuspiciousBackendDirectoryCombination = "The index '%1$s' is using a non-recommended combination of backend and directoryProvider implementations";
    private static final String unknownResolution = "Unknown Resolution: %1$s";
    private static final String jGroupsStartingChannel = "Starting JGroups Channel";
    private static final String cannotExtractValueForIdentifier = "FieldCache was enabled on class %1$s but for this type of identifier we can't extract values from the FieldCache: cache disabled";
    private static final String jGroupsChannelInjectionError = "Object injected for JGroups channel in hibernate.search.services.jgroups.providedChannel is of an unexpected type %1$s (expecting org.jgroups.JChannel)";
    private static final String unableToDeserializeAvroStream = "Unable to deserialize Avro stream";
    private static final String unableToDetermineCurrentInSourceDirectory = "Unable to determine current in source directory, will try again during the next synchronization";
    private static final String containedInPointsToProvidedId = "@ContainedIn is pointing to an entity having @ProvidedId: %1$s. This is not supported, indexing of contained in entities will be skipped. Indexed data of the embedded object might become out of date in objects of type ";
    private static final String couldNotCloseResource = "Could not close resource.";
    private static final String exceptionOccurred = "%1$s";
    private static final String queryWithNoTermsAfterAnalysis = "The query string '%2$s' applied on field '%1$s' has no meaningfull tokens to be matched. Validate the query input against the Analyzer applied on this field.";
    private static final String illegalServiceBuildPhase = "Illegal state for service initialization";
    private static final String cannotReadFieldForClass = "Cannot read %1$s field from a %2$s object : does getter exists and is it public ?";
    private static final String unableToCloseLuceneIndexReader = "Unable to close Lucene IndexReader";
    private static final String notDeleted = "Could not delete %1$s";
    private static final String unableToDetermineClassBridge = "Unable to determine ClassBridge for %1$s";
    private static final String jmsLookupException = "Unable to lookup Search queue '%1$s' and connection factory '%2$s' for index '%3$s'";
    private static final String jGroupsChannelCreationUsingFileError = "Error while trying to create a channel using config file: %1$s";
    private static final String unknownIterableBridgeForResolution = "Unknown IterableBridge for resolution: %1$s";
    private static final String fileIsNotReadable = "File %1$s is not readable";
    private static final String needAtLeastOneIndexName = "At least one index name must be provided: can't open an IndexReader on nothing";
    private static final String cannotFindCoordinatesNorLatLongForSpatial = "Cannot find a Coordinates Interface nor Lat/Long annotations bound to %1$s @Spatial for class %2$s";
    private static final String interruptedBatchIndexing = "Batch indexing was interrupted";
    private static final String unableToGuessFieldBridge = "Unable to guess FieldBridge for %2$s in %1$s";
    private static final String idCannotBeExtracted = "Unable to reindex entity on collection change, id cannot be extracted: %1$s";
    private static final String unableToOpenJMSConnection = "Unable to open JMS connection on queue '%2$s' for index '%1$s'";
    private static final String unableToReadFile = "Unable to read file %1$s";
    private static final String interruptedWorkError = "Work discarded, thread was interrupted while waiting for space to schedule: %1$s";
    private static final String indexManagerAliasResolved = "IndexManager factory resolved alias '%1$s' to '%2$s'.";
    private static final String massIndexerIndexWriterThreadsIgnored = "The option 'threadsForIndexWriter' of the MassIndexer is deprecated and is being ignored! Control the size of worker.thread_pool.size for each index instead.";
    private static final String indexDirectoryNotFoundCreatingNewOne = "Index directory not found, creating: '%1$s'";
    private static final String interruptedWhileWaitingForIndexActivity = "Was interrupted while waiting for index activity to finish. Index might be inconsistent or have a stale lock";
    private static final String cannotDeserializeField = "Cannot deserialize field type %1$s, unknown field type.";
    private static final String unableToCompareSourceWithDestinationDirectory = "Unable to compare %1$s with %2$s.";
    private static final String stopServiceFailed = "Fail to properly stop service: %1$s";
    private static final String indexingEntities = "Going to reindex %d entities";
    private static final String inconsistentFieldConfiguration = "There are multiple properties indexed against the same field name '%1$s', but with different indexing settings. The behaviour is undefined.";
    private static final String jGroupsReceivedNewClusterView = "Received new cluster view: %1$s";
    private static final String conversionFromReaderToStringNotYetImplemented = "Conversion from Reader to String not yet implemented";
    private static final String forceRemoveOnIndexOperationViaInterception = "Interceptor enforces removal of index data instead of index operation %2$s on instance of class %1$s";
    private static final String errorExecutingRunnableInTransaction = "Error while executing runnable wrapped in a JTA transaction";
    private static final String legacyJGroupsConfigurationDefined = "JGroups channel configuration should be specified in the global section [hibernate.search.services.jgroups.], not as an IndexManager property for index '%1$s'. See http://docs.jboss.org/hibernate/search/4.1/reference/en-US/html_single/#jgroups-backend";
    private static final String skippingDirectorySynchronization = "Skipping directory synchronization, previous work still in progress: %1$s";
    private static final String unknownAttributeSerializedRepresentation = "Unknown attribute serialized representation: %1$s";
    private static final String unsupportedTikaBridgeType = "Unable to get input stream from blob data";
    private static final String unableToShutdownAsynchronousIndexing = "Unable to properly shut down asynchronous indexing work";
    private static final String workerException = "Worker raises an exception on close()";
    private static final String unknownFieldType = "Unknown Field type: %1$s";
    private static final String closedBlackholeBackend = "closed \"blackhole\" backend.";
    private static final String unableToGetInputStreamFromBlob = "Unable to get input stream from blob data";
    private static final String unableToInstantiateSpatial = "Unable to instantiate Spatial defined on %1$s";
    private static final String errorRollingBackTransaction = "Error while rolling back transaction after %1$s";
    private static final String jGroupsChannelCreationUsingXmlError = "Error while trying to create a channel using config XML: %1$s";
    private static final String unableToReadSerializedLuceneWorks = "Unable to read serialized List<LuceneWork>";
    private static final String similarityInstantiationException = "Exception attempting to instantiate Similarity '%1$s' set for %2$s";
    private static final String readersNotProperlyClosedInReaderProvider = "ReaderProvider contains readers not properly closed at destroy time";
    private static final String ignoringBackendOptionForIndex = "Ignoring backend option for index '%1$s', configured IndexManager requires using '%2$s' instead.";
    private static final String forceToUseDocumentExtraction = "Forced to use Document extraction to workaround FieldCache bug in Lucene";
    private static final String jGroupsDisconnectingAndClosingChannel = "Disconnecting and closing JGroups Channel to cluster '%1$s'";
    private static final String unknownArrayBridgeForResolution = "Unknown ArrayBridge for resolution: %1$s";
    private static final String unableToShutdownAsynchronousIndexingByTimeout = "Timed out waiting to flush all operations to the backend of index %1$s";
    private static final String unableToRetrieveObjectFromMessage = "Unable to retrieve object from message: %1$s";
    private static final String cannotDeserializeOperation = "Cannot deserialize operation %1$s, unknown operation.";
    private static final String jGroupsClosingChannelError = "Problem closing channel; setting it to null";
    private static final String checkSizeMustBePositive = "Chunk size must be positive: using default value.";
    private static final String abstractClassesCannotInsertDocuments = "Abstract classes can never insert index documents. Remove @Indexed.";
    private static final String notAnIndexedType = "%1$s is not an indexed type";
    private static final String unableToCreateCurrentMarker = "Unable to create current marker in source of %1$s";

    public Log_$logger(Logger log) {
        super(log);
    }

    @Override
    public final SearchException cannotHaveTwoSpatialsWithDefaultOrSameName(String className) {
        SearchException result = new SearchException(String.format("HSEARCH000158: " + this.cannotHaveTwoSpatialsWithDefaultOrSameName$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotHaveTwoSpatialsWithDefaultOrSameName$str() {
        return cannotHaveTwoSpatialsWithDefaultOrSameName;
    }

    @Override
    public final SearchException unableToSerializeInAvro(Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000102: " + this.unableToSerializeInAvro$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSerializeInAvro$str() {
        return unableToSerializeInAvro;
    }

    @Override
    public final void indexingDocumentsCompleted(long doneCount, long elapsedMs) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HSEARCH000030: " + this.indexingDocumentsCompleted$str(), (Object)doneCount, (Object)elapsedMs);
    }

    protected String indexingDocumentsCompleted$str() {
        return indexingDocumentsCompleted;
    }

    @Override
    public final void failedSlaveDirectoryProviderInitialization(String indexName, Exception re) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)re, "HSEARCH000066: " + this.failedSlaveDirectoryProviderInitialization$str(), (Object)indexName);
    }

    protected String failedSlaveDirectoryProviderInitialization$str() {
        return failedSlaveDirectoryProviderInitialization;
    }

    @Override
    public final SearchException unableToSendJMSWork(String indexName, String jmsQueueName, Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000163: " + this.unableToSendJMSWork$str(), indexName, jmsQueueName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSendJMSWork$str() {
        return unableToSendJMSWork;
    }

    @Override
    public final SearchException targetedFieldNotSpatial(String className, String fieldName) {
        SearchException result = new SearchException(String.format("HSEARCH000131: " + this.targetedFieldNotSpatial$str(), className, fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String targetedFieldNotSpatial$str() {
        return targetedFieldNotSpatial;
    }

    @Override
    public final SearchException unableToSerializeLuceneWorks(Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000083: " + this.unableToSerializeLuceneWorks$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSerializeLuceneWorks$str() {
        return unableToSerializeLuceneWorks;
    }

    @Override
    public final void messageReceivedForUndefinedIndex(String indexName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, "HSEARCH000080: " + this.messageReceivedForUndefinedIndex$str(), (Object)indexName);
    }

    protected String messageReceivedForUndefinedIndex$str() {
        return messageReceivedForUndefinedIndex;
    }

    @Override
    public final SearchException unableToConfigureTikaBridge(String bridgeName, Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000155: " + this.unableToConfigureTikaBridge$str(), bridgeName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConfigureTikaBridge$str() {
        return unableToConfigureTikaBridge;
    }

    public final void forceSkipIndexOperationViaInterception(Class entityClass, WorkType type) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, "HSEARCH000125: " + this.forceSkipIndexOperationViaInterception$str(), (Object)entityClass, (Object)type);
    }

    protected String forceSkipIndexOperationViaInterception$str() {
        return forceSkipIndexOperationViaInterception;
    }

    @Override
    public final IllegalArgumentException needAtLeastOneIndexedEntityType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HSEARCH000112: " + this.needAtLeastOneIndexedEntityType$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needAtLeastOneIndexedEntityType$str() {
        return needAtLeastOneIndexedEntityType;
    }

    @Override
    public final void jGroupsConfigurationNotFoundInProperties(Properties props) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HSEARCH000011: " + this.jGroupsConfigurationNotFoundInProperties$str(), (Object)props);
    }

    protected String jGroupsConfigurationNotFoundInProperties$str() {
        return jGroupsConfigurationNotFoundInProperties;
    }

    @Override
    public final SearchException unableToConvertSerializableTermVectorToLuceneTermVector(String termVector) {
        SearchException result = new SearchException(String.format("HSEARCH000088: " + this.unableToConvertSerializableTermVectorToLuceneTermVector$str(), termVector));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConvertSerializableTermVectorToLuceneTermVector$str() {
        return unableToConvertSerializableTermVectorToLuceneTermVector;
    }

    @Override
    public final String exceptionDuringIndexMergeOperation() {
        String result = String.format("HSEARCH000118: " + this.exceptionDuringIndexMergeOperation$str(), new Object[0]);
        return result;
    }

    protected String exceptionDuringIndexMergeOperation$str() {
        return exceptionDuringIndexMergeOperation;
    }

    @Override
    public final SearchException ambiguousLongitudeDefinition(String beanXClassName, String firstField, String secondField) {
        SearchException result = new SearchException(String.format("HSEARCH000161: " + this.ambiguousLongitudeDefinition$str(), beanXClassName, firstField, secondField));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ambiguousLongitudeDefinition$str() {
        return ambiguousLongitudeDefinition;
    }

    @Override
    public final void unexpectedErrorInLuceneBackend(Throwable tw) {
        this.log.logf(FQCN, Logger.Level.ERROR, tw, "HSEARCH000074: " + this.unexpectedErrorInLuceneBackend$str(), new Object[0]);
    }

    protected String unexpectedErrorInLuceneBackend$str() {
        return unexpectedErrorInLuceneBackend;
    }

    @Override
    public final void unableToCloseSearcherDuringQuery(String query, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, "HSEARCH000037: " + this.unableToCloseSearcherDuringQuery$str(), (Object)query);
    }

    protected String unableToCloseSearcherDuringQuery$str() {
        return unableToCloseSearcherDuringQuery;
    }

    @Override
    public final SearchException fieldBridgeNotAnInstanceof(String className) {
        SearchException result = new SearchException(String.format("HSEARCH000144: " + this.fieldBridgeNotAnInstanceof$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldBridgeNotAnInstanceof$str() {
        return fieldBridgeNotAnInstanceof;
    }

    @Override
    public final void shuttingDownBackend(String indexName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, "HSEARCH000108: " + this.shuttingDownBackend$str(), (Object)indexName);
    }

    protected String shuttingDownBackend$str() {
        return shuttingDownBackend;
    }

    @Override
    public final void unableToSynchronizeSource(String indexName, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, "HSEARCH000021: " + this.unableToSynchronizeSource$str(), (Object)indexName);
    }

    protected String unableToSynchronizeSource$str() {
        return unableToSynchronizeSource;
    }

    @Override
    public final SearchException failToDeserializeObject(Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000096: " + this.failToDeserializeObject$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failToDeserializeObject$str() {
        return failToDeserializeObject;
    }

    @Override
    public final String massIndexerUnexpectedErrorMessage() {
        String result = String.format("HSEARCH000116: " + this.massIndexerUnexpectedErrorMessage$str(), new Object[0]);
        return result;
    }

    protected String massIndexerUnexpectedErrorMessage$str() {
        return massIndexerUnexpectedErrorMessage;
    }

    @Override
    public final SearchException noFieldBridgeInterfaceImplementedByFieldBridge(String implName, String appliedOnName) {
        SearchException result = new SearchException(String.format("HSEARCH000138: " + this.noFieldBridgeInterfaceImplementedByFieldBridge$str(), implName, appliedOnName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noFieldBridgeInterfaceImplementedByFieldBridge$str() {
        return noFieldBridgeInterfaceImplementedByFieldBridge;
    }

    @Override
    public final void unableToRemovePreviousMarket(String indexName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000019: " + this.unableToRemovePreviousMarket$str(), (Object)indexName);
    }

    protected String unableToRemovePreviousMarket$str() {
        return unableToRemovePreviousMarket;
    }

    @Override
    public final void unexpectedValueMissingFromFieldCache() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000040: " + this.unexpectedValueMissingFromFieldCache$str(), new Object[0]);
    }

    protected String unexpectedValueMissingFromFieldCache$str() {
        return unexpectedValueMissingFromFieldCache;
    }

    @Override
    public final void jGroupsFlushNotPresentInStack() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000007: " + this.jGroupsFlushNotPresentInStack$str(), new Object[0]);
    }

    protected String jGroupsFlushNotPresentInStack$str() {
        return jGroupsFlushNotPresentInStack;
    }

    public final void incorrectMessageType(Class messageType) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, "HSEARCH000016: " + this.incorrectMessageType$str(), (Object)messageType);
    }

    protected String incorrectMessageType$str() {
        return incorrectMessageType;
    }

    @Override
    public final void jGroupsConnectedToCluster(String clusterName, Object address) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HSEARCH000006: " + this.jGroupsConnectedToCluster$str(), (Object)clusterName, address);
    }

    protected String jGroupsConnectedToCluster$str() {
        return jGroupsConnectedToCluster;
    }

    @Override
    public final void recommendConfiguringLuceneVersion() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000075: " + this.recommendConfiguringLuceneVersion$str(), new Object[0]);
    }

    protected String recommendConfiguringLuceneVersion$str() {
        return recommendConfiguringLuceneVersion;
    }

    @Override
    public final void serializationProtocol(int major, int minor) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HSEARCH000079: " + this.serializationProtocol$str(), (Object)major, (Object)minor);
    }

    protected String serializationProtocol$str() {
        return serializationProtocol;
    }

    @Override
    public final IllegalArgumentException nullIsInvalidIndexedType() {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HSEARCH000110: " + this.nullIsInvalidIndexedType$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullIsInvalidIndexedType$str() {
        return nullIsInvalidIndexedType;
    }

    @Override
    public final void initializedBlackholeBackend() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000001: " + this.initializedBlackholeBackend$str(), new Object[0]);
    }

    protected String initializedBlackholeBackend$str() {
        return initializedBlackholeBackend;
    }

    @Override
    public final SearchException spatialFieldNameNotDefined(String className) {
        SearchException result = new SearchException(String.format("HSEARCH000145: " + this.spatialFieldNameNotDefined$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String spatialFieldNameNotDefined$str() {
        return spatialFieldNameNotDefined;
    }

    @Override
    public final void noCurrentMarkerInSourceDirectory() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000042: " + this.noCurrentMarkerInSourceDirectory$str(), new Object[0]);
    }

    protected String noCurrentMarkerInSourceDirectory$str() {
        return noCurrentMarkerInSourceDirectory;
    }

    public final SearchException cannotSerializeCustomField(Class fieldType) {
        SearchException result = new SearchException(String.format("HSEARCH000094: " + this.cannotSerializeCustomField$str(), fieldType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotSerializeCustomField$str() {
        return cannotSerializeCustomField;
    }

    @Override
    public final SearchException unableToReadTokenStream() {
        SearchException result = new SearchException(String.format("HSEARCH000087: " + this.unableToReadTokenStream$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToReadTokenStream$str() {
        return unableToReadTokenStream;
    }

    @Override
    public final SearchException unableToConvertSerializableStoreToLuceneStore(String store) {
        SearchException result = new SearchException(String.format("HSEARCH000090: " + this.unableToConvertSerializableStoreToLuceneStore$str(), store));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConvertSerializableStoreToLuceneStore$str() {
        return unableToConvertSerializableStoreToLuceneStore;
    }

    @Override
    public final void illegalObjectRetrievedFromMessage(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, "HSEARCH000069: " + this.illegalObjectRetrievedFromMessage$str(), new Object[0]);
    }

    protected String illegalObjectRetrievedFromMessage$str() {
        return illegalObjectRetrievedFromMessage;
    }

    public final SearchException attributeNotRecognizedNorSerializable(Class attributeType) {
        SearchException result = new SearchException(String.format("HSEARCH000085: " + this.attributeNotRecognizedNorSerializable$str(), attributeType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String attributeNotRecognizedNorSerializable$str() {
        return attributeNotRecognizedNorSerializable;
    }

    @Override
    public final void terminatingBatchWorkCanCauseInconsistentState() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, "HSEARCH000070: " + this.terminatingBatchWorkCanCauseInconsistentState$str(), new Object[0]);
    }

    protected String terminatingBatchWorkCanCauseInconsistentState$str() {
        return terminatingBatchWorkCanCauseInconsistentState;
    }

    @Override
    public final void notChangeTimestamp(File destFile) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000033: " + this.notChangeTimestamp$str(), (Object)destFile);
    }

    protected String notChangeTimestamp$str() {
        return notChangeTimestamp;
    }

    @Override
    public final SearchException cannotExtractCoordinateFromObject(String className) {
        SearchException result = new SearchException(String.format("HSEARCH000157: " + this.cannotExtractCoordinateFromObject$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotExtractCoordinateFromObject$str() {
        return cannotExtractCoordinateFromObject;
    }

    @Override
    public final void optimizationSkippedStillBusy(String indexName) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, "HSEARCH000119: " + this.optimizationSkippedStillBusy$str(), (Object)indexName);
    }

    protected String optimizationSkippedStillBusy$str() {
        return optimizationSkippedStillBusy;
    }

    @Override
    public final SearchException cannotInstantiateClassBridgeOfType(String implName, String className, Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000134: " + this.cannotInstantiateClassBridgeOfType$str(), implName, className), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotInstantiateClassBridgeOfType$str() {
        return cannotInstantiateClassBridgeOfType;
    }

    @Override
    public final SearchException unableConnectingToJGroupsCluster(String clusterName, Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000121: " + this.unableConnectingToJGroupsCluster$str(), clusterName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableConnectingToJGroupsCluster$str() {
        return unableConnectingToJGroupsCluster;
    }

    @Override
    public final SearchException noFieldBridgeInterfaceImplementedByClassBridge(String implName) {
        SearchException result = new SearchException(String.format("HSEARCH000133: " + this.noFieldBridgeInterfaceImplementedByClassBridge$str(), implName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noFieldBridgeInterfaceImplementedByClassBridge$str() {
        return noFieldBridgeInterfaceImplementedByClassBridge;
    }

    @Override
    public final SearchException unableToStartSerializationLayer(Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000082: " + this.unableToStartSerializationLayer$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToStartSerializationLayer$str() {
        return unableToStartSerializationLayer;
    }

    @Override
    public final SearchException missingJGroupsMuxId() {
        SearchException result = new SearchException(String.format("HSEARCH000147: " + this.missingJGroupsMuxId$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingJGroupsMuxId$str() {
        return missingJGroupsMuxId;
    }

    @Override
    public final void updatedDirectoryProviders() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000003: " + this.updatedDirectoryProviders$str(), new Object[0]);
    }

    protected String updatedDirectoryProviders$str() {
        return updatedDirectoryProviders;
    }

    @Override
    public final void errorDuringBatchIndexing(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, "HSEARCH000063: " + this.errorDuringBatchIndexing$str(), new Object[0]);
    }

    protected String errorDuringBatchIndexing$str() {
        return errorDuringBatchIndexing;
    }

    @Override
    public final void backendError(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, "HSEARCH000073: " + this.backendError$str(), new Object[0]);
    }

    protected String backendError$str() {
        return backendError;
    }

    @Override
    public final void receivedEmptyLuceneWorksInMessage() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000051: " + this.receivedEmptyLuceneWorksInMessage$str(), new Object[0]);
    }

    protected String receivedEmptyLuceneWorksInMessage$str() {
        return receivedEmptyLuceneWorksInMessage;
    }

    @Override
    public final void cannotOpenIndexWriterCausePreviousError() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, "HSEARCH000072: " + this.cannotOpenIndexWriterCausePreviousError$str(), new Object[0]);
    }

    protected String cannotOpenIndexWriterCausePreviousError$str() {
        return cannotOpenIndexWriterCausePreviousError;
    }

    @Override
    public final SearchException noImplementationClassInFieldBridge(String className) {
        SearchException result = new SearchException(String.format("HSEARCH000137: " + this.noImplementationClassInFieldBridge$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noImplementationClassInFieldBridge$str() {
        return noImplementationClassInFieldBridge;
    }

    @Override
    public final SearchException incompatibleProtocolVersion(int messageMajor, int messageMinor, int currentMajor, int currentMinor) {
        SearchException result = new SearchException(String.format("HSEARCH000098: " + this.incompatibleProtocolVersion$str(), messageMajor, messageMinor, currentMajor, currentMinor));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String incompatibleProtocolVersion$str() {
        return incompatibleProtocolVersion;
    }

    @Override
    public final SearchException ambiguousLatitudeDefinition(String beanXClassName, String firstField, String secondField) {
        SearchException result = new SearchException(String.format("HSEARCH000160: " + this.ambiguousLatitudeDefinition$str(), beanXClassName, firstField, secondField));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ambiguousLatitudeDefinition$str() {
        return ambiguousLatitudeDefinition;
    }

    @Override
    public final SearchException fileIsADirectory(String fileName) {
        SearchException result = new SearchException(String.format("HSEARCH000153: " + this.fileIsADirectory$str(), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileIsADirectory$str() {
        return fileIsADirectory;
    }

    @Override
    public final void forcingReleaseIndexWriterLock() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000052: " + this.forcingReleaseIndexWriterLock$str(), new Object[0]);
    }

    protected String forcingReleaseIndexWriterLock$str() {
        return forcingReleaseIndexWriterLock;
    }

    @Override
    public final SearchException duplicateDocumentIdFound(String beanXClassName) {
        SearchException result = new SearchException(String.format("HSEARCH000167: " + this.duplicateDocumentIdFound$str(), beanXClassName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String duplicateDocumentIdFound$str() {
        return duplicateDocumentIdFound;
    }

    public final void serviceProviderNotReleased(Class class1) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000025: " + this.serviceProviderNotReleased$str(), (Object)class1);
    }

    protected String serviceProviderNotReleased$str() {
        return serviceProviderNotReleased;
    }

    @Override
    public final void cannotGuessTransactionStatus(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, "HSEARCH000036: " + this.cannotGuessTransactionStatus$str(), new Object[0]);
    }

    protected String cannotGuessTransactionStatus$str() {
        return cannotGuessTransactionStatus;
    }

    @Override
    public final void version(String versionString) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HSEARCH000034: " + this.version$str(), (Object)versionString);
    }

    protected String version$str() {
        return version;
    }

    @Override
    public final void directoryProviderExceptionOnStop(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, "HSEARCH000061: " + this.directoryProviderExceptionOnStop$str(), new Object[0]);
    }

    protected String directoryProviderExceptionOnStop$str() {
        return directoryProviderExceptionOnStop;
    }

    @Override
    public final void unableToCloseLuceneDirectory(Object directory, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, "HSEARCH000067: " + this.unableToCloseLuceneDirectory$str(), directory);
    }

    protected String unableToCloseLuceneDirectory$str() {
        return unableToCloseLuceneDirectory;
    }

    @Override
    public final void indexingSpeed(float estimateSpeed, float estimatePercentileComplete) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HSEARCH000031: " + this.indexingSpeed$str(), (Object)Float.valueOf(estimateSpeed), (Object)Float.valueOf(estimatePercentileComplete));
    }

    protected String indexingSpeed$str() {
        return indexingSpeed;
    }

    @Override
    public final void jGroupsDefaultConfigurationFileNotFound() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000012: " + this.jGroupsDefaultConfigurationFileNotFound$str(), new Object[0]);
    }

    protected String jGroupsDefaultConfigurationFileNotFound$str() {
        return jGroupsDefaultConfigurationFileNotFound;
    }

    @Override
    public final void unableToRetrieveNamedAnalyzer(String value) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000048: " + this.unableToRetrieveNamedAnalyzer$str(), (Object)value);
    }

    protected String unableToRetrieveNamedAnalyzer$str() {
        return unableToRetrieveNamedAnalyzer;
    }

    @Override
    public final void pushedChangesOutOfTransaction() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000050: " + this.pushedChangesOutOfTransaction$str(), new Object[0]);
    }

    protected String pushedChangesOutOfTransaction$str() {
        return pushedChangesOutOfTransaction;
    }

    @Override
    public final SearchException ioExceptionOnIndex(IOException e, String indexName) {
        SearchException result = new SearchException(String.format("HSEARCH000077: " + this.ioExceptionOnIndex$str(), indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String ioExceptionOnIndex$str() {
        return ioExceptionOnIndex;
    }

    @Override
    public final void unableToUnregisterExistingMBean(String name, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, "HSEARCH000056: " + this.unableToUnregisterExistingMBean$str(), (Object)name);
    }

    protected String unableToUnregisterExistingMBean$str() {
        return unableToUnregisterExistingMBean;
    }

    public final SearchException failToSerializeObject(Class type, Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000095: " + this.failToSerializeObject$str(), type), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String failToSerializeObject$str() {
        return failToSerializeObject;
    }

    @Override
    public final SearchException unknownNumericFieldType(String dataType) {
        SearchException result = new SearchException(String.format("HSEARCH000091: " + this.unknownNumericFieldType$str(), dataType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownNumericFieldType$str() {
        return unknownNumericFieldType;
    }

    @Override
    public final void indexingCompletedAndMBeanUnregistered(long nbrOfEntities) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HSEARCH000029: " + this.indexingCompletedAndMBeanUnregistered$str(), (Object)nbrOfEntities);
    }

    protected String indexingCompletedAndMBeanUnregistered$str() {
        return indexingCompletedAndMBeanUnregistered;
    }

    @Override
    public final SearchException jGroupsMuxIdAlreadyTaken(short n) {
        SearchException result = new SearchException(String.format("HSEARCH000148: " + this.jGroupsMuxIdAlreadyTaken$str(), n));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jGroupsMuxIdAlreadyTaken$str() {
        return jGroupsMuxIdAlreadyTaken;
    }

    @Override
    public final void indexingEntitiesCompleted(long nbrOfEntities) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HSEARCH000028: " + this.indexingEntitiesCompleted$str(), (Object)nbrOfEntities);
    }

    protected String indexingEntitiesCompleted$str() {
        return indexingEntitiesCompleted;
    }

    @Override
    public final SearchException unableToSendWorkViaJGroups(Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000123: " + this.unableToSendWorkViaJGroups$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToSendWorkViaJGroups$str() {
        return unableToSendWorkViaJGroups;
    }

    @Override
    public final void readerProviderExceptionOnDestroy(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, "HSEARCH000060: " + this.readerProviderExceptionOnDestroy$str(), new Object[0]);
    }

    protected String readerProviderExceptionOnDestroy$str() {
        return readerProviderExceptionOnDestroy;
    }

    @Override
    public final SearchException fieldLooksBinaryButDecompressionFailed(String fieldName) {
        SearchException result = new SearchException(String.format("HSEARCH000106: " + this.fieldLooksBinaryButDecompressionFailed$str(), fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fieldLooksBinaryButDecompressionFailed$str() {
        return fieldLooksBinaryButDecompressionFailed;
    }

    @Override
    public final SearchException unableToStartJGroupsChannel(Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000122: " + this.unableToStartJGroupsChannel$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToStartJGroupsChannel$str() {
        return unableToStartJGroupsChannel;
    }

    public final void forceUpdateOnIndexOperationViaInterception(Class entityClass, WorkType type) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, "HSEARCH000128: " + this.forceUpdateOnIndexOperationViaInterception$str(), (Object)entityClass, (Object)type);
    }

    protected String forceUpdateOnIndexOperationViaInterception$str() {
        return forceUpdateOnIndexOperationViaInterception;
    }

    @Override
    public final String ioExceptionOnIndexWriter() {
        String result = String.format("HSEARCH000117: " + this.ioExceptionOnIndexWriter$str(), new Object[0]);
        return result;
    }

    protected String ioExceptionOnIndexWriter$str() {
        return ioExceptionOnIndexWriter;
    }

    @Override
    public final SearchException requestedIndexNotDefined(String indexName) {
        SearchException result = new SearchException(String.format("HSEARCH000107: " + this.requestedIndexNotDefined$str(), indexName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requestedIndexNotDefined$str() {
        return requestedIndexNotDefined;
    }

    @Override
    public final IllegalArgumentException nullIsInvalidIndexName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HSEARCH000113: " + this.nullIsInvalidIndexName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String nullIsInvalidIndexName$str() {
        return nullIsInvalidIndexName;
    }

    @Override
    public final SearchException unableToInitializeIndexManager(String indexName, Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000103: " + this.unableToInitializeIndexManager$str(), indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInitializeIndexManager$str() {
        return unableToInitializeIndexManager;
    }

    @Override
    public final AssertionFailure unknownMapBridgeForResolution(String resolution) {
        AssertionFailure result = new AssertionFailure(String.format("HSEARCH000142: " + this.unknownMapBridgeForResolution$str(), resolution));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownMapBridgeForResolution$str() {
        return unknownMapBridgeForResolution;
    }

    @Override
    public final SearchException cannotGetResultSizeWithCriteriaAndRestriction(String criteria) {
        SearchException result = new SearchException(String.format("HSEARCH000105: " + this.cannotGetResultSizeWithCriteriaAndRestriction$str(), criteria));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotGetResultSizeWithCriteriaAndRestriction$str() {
        return cannotGetResultSizeWithCriteriaAndRestriction;
    }

    @Override
    public final SearchException unableToInstantiateFieldBridge(String appliedOnName, String appliedOnTypeName, Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000139: " + this.unableToInstantiateFieldBridge$str(), appliedOnName, appliedOnTypeName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateFieldBridge$str() {
        return unableToInstantiateFieldBridge;
    }

    @Override
    public final SearchException unableToConvertSerializableIndexToLuceneIndex(String index) {
        SearchException result = new SearchException(String.format("HSEARCH000089: " + this.unableToConvertSerializableIndexToLuceneIndex$str(), index));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConvertSerializableIndexToLuceneIndex$str() {
        return unableToConvertSerializableIndexToLuceneIndex;
    }

    @Override
    public final SearchException fileDoesNotExist(String fileName) {
        SearchException result = new SearchException(String.format("HSEARCH000152: " + this.fileDoesNotExist$str(), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileDoesNotExist$str() {
        return fileDoesNotExist;
    }

    @Override
    public final SearchException cantOpenCorruptedIndex(CorruptIndexException e, String indexName) {
        SearchException result = new SearchException(String.format("HSEARCH000076: " + this.cantOpenCorruptedIndex$str(), indexName), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cantOpenCorruptedIndex$str() {
        return cantOpenCorruptedIndex;
    }

    @Override
    public final void foundCurrentMarker() {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HSEARCH000043: " + this.foundCurrentMarker$str(), new Object[0]);
    }

    protected String foundCurrentMarker$str() {
        return foundCurrentMarker;
    }

    @Override
    public final void unableToCloseSearcherInScrollableResult(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, "HSEARCH000039: " + this.unableToCloseSearcherInScrollableResult$str(), new Object[0]);
    }

    protected String unableToCloseSearcherInScrollableResult$str() {
        return unableToCloseSearcherInScrollableResult;
    }

    @Override
    public final SearchException jGroupsChannelCreationFromStringError(String configuration, Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000010: " + this.jGroupsChannelCreationFromStringError$str(), configuration), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jGroupsChannelCreationFromStringError$str() {
        return jGroupsChannelCreationFromStringError;
    }

    @Override
    public final SearchException unknownFullTextFilter(String filterName) {
        SearchException result = new SearchException(String.format("HSEARCH000115: " + this.unknownFullTextFilter$str(), filterName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFullTextFilter$str() {
        return unknownFullTextFilter;
    }

    @Override
    public final void eventListenerWontBeRegistered() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000057: " + this.eventListenerWontBeRegistered$str(), new Object[0]);
    }

    protected String eventListenerWontBeRegistered$str() {
        return eventListenerWontBeRegistered;
    }

    @Override
    public final void unableToCloseJmsConnection(String jmsQueueName, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, "HSEARCH000047: " + this.unableToCloseJmsConnection$str(), (Object)jmsQueueName);
    }

    protected String unableToCloseJmsConnection$str() {
        return unableToCloseJmsConnection;
    }

    @Override
    public final SearchException unableToLoadResource(String fileName) {
        SearchException result = new SearchException(String.format("HSEARCH000114: " + this.unableToLoadResource$str(), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadResource$str() {
        return unableToLoadResource;
    }

    @Override
    public final void warnSuspiciousBackendDirectoryCombination(String indexName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000081: " + this.warnSuspiciousBackendDirectoryCombination$str(), (Object)indexName);
    }

    protected String warnSuspiciousBackendDirectoryCombination$str() {
        return warnSuspiciousBackendDirectoryCombination;
    }

    @Override
    public final AssertionFailure unknownResolution(String resolution) {
        AssertionFailure result = new AssertionFailure(String.format("HSEARCH000140: " + this.unknownResolution$str(), resolution));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownResolution$str() {
        return unknownResolution;
    }

    @Override
    public final void jGroupsStartingChannel() {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HSEARCH000005: " + this.jGroupsStartingChannel$str(), new Object[0]);
    }

    protected String jGroupsStartingChannel$str() {
        return jGroupsStartingChannel;
    }

    public final void cannotExtractValueForIdentifier(Class beanClass) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000046: " + this.cannotExtractValueForIdentifier$str(), (Object)beanClass);
    }

    protected String cannotExtractValueForIdentifier$str() {
        return cannotExtractValueForIdentifier;
    }

    public final SearchException jGroupsChannelInjectionError(Exception e, Class actualType) {
        SearchException result = new SearchException(String.format("HSEARCH000129: " + this.jGroupsChannelInjectionError$str(), actualType), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jGroupsChannelInjectionError$str() {
        return jGroupsChannelInjectionError;
    }

    @Override
    public final SearchException unableToDeserializeAvroStream(Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000099: " + this.unableToDeserializeAvroStream$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDeserializeAvroStream$str() {
        return unableToDeserializeAvroStream;
    }

    @Override
    public final void unableToDetermineCurrentInSourceDirectory() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000022: " + this.unableToDetermineCurrentInSourceDirectory$str(), new Object[0]);
    }

    protected String unableToDetermineCurrentInSourceDirectory$str() {
        return unableToDetermineCurrentInSourceDirectory;
    }

    public final void containedInPointsToProvidedId(Class objectClass) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000045: " + this.containedInPointsToProvidedId$str(), (Object)objectClass);
    }

    protected String containedInPointsToProvidedId$str() {
        return containedInPointsToProvidedId;
    }

    @Override
    public final void couldNotCloseResource(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, "HSEARCH000035: " + this.couldNotCloseResource$str(), new Object[0]);
    }

    protected String couldNotCloseResource$str() {
        return couldNotCloseResource;
    }

    @Override
    public final void exceptionOccurred(String errorMsg, Throwable exceptionThatOccurred) {
        this.log.logf(FQCN, Logger.Level.ERROR, exceptionThatOccurred, "HSEARCH000058: " + this.exceptionOccurred$str(), (Object)errorMsg);
    }

    protected String exceptionOccurred$str() {
        return exceptionOccurred;
    }

    @Override
    public final EmptyQueryException queryWithNoTermsAfterAnalysis(String field, String searchTerm) {
        EmptyQueryException result = new EmptyQueryException(String.format("HSEARCH000146: " + this.queryWithNoTermsAfterAnalysis$str(), field, searchTerm));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String queryWithNoTermsAfterAnalysis$str() {
        return queryWithNoTermsAfterAnalysis;
    }

    @Override
    public final SearchException illegalServiceBuildPhase() {
        SearchException result = new SearchException(String.format("HSEARCH000165: " + this.illegalServiceBuildPhase$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String illegalServiceBuildPhase$str() {
        return illegalServiceBuildPhase;
    }

    @Override
    public final SearchException cannotReadFieldForClass(String fieldName, String className) {
        SearchException result = new SearchException(String.format("HSEARCH000156: " + this.cannotReadFieldForClass$str(), fieldName, className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotReadFieldForClass$str() {
        return cannotReadFieldForClass;
    }

    @Override
    public final void unableToCloseLuceneIndexReader(Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, "HSEARCH000055: " + this.unableToCloseLuceneIndexReader$str(), new Object[0]);
    }

    protected String unableToCloseLuceneIndexReader$str() {
        return unableToCloseLuceneIndexReader;
    }

    @Override
    public final void notDeleted(File file) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000032: " + this.notDeleted$str(), (Object)file);
    }

    protected String notDeleted$str() {
        return notDeleted;
    }

    @Override
    public final SearchException unableToDetermineClassBridge(String className) {
        SearchException result = new SearchException(String.format("HSEARCH000149: " + this.unableToDetermineClassBridge$str(), className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToDetermineClassBridge$str() {
        return unableToDetermineClassBridge;
    }

    @Override
    public final SearchException jmsLookupException(String jmsQueueName, String jmsConnectionFactoryName, String indexName, Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000164: " + this.jmsLookupException$str(), jmsQueueName, jmsConnectionFactoryName, indexName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jmsLookupException$str() {
        return jmsLookupException;
    }

    @Override
    public final SearchException jGroupsChannelCreationUsingFileError(String configuration, Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000008: " + this.jGroupsChannelCreationUsingFileError$str(), configuration), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jGroupsChannelCreationUsingFileError$str() {
        return jGroupsChannelCreationUsingFileError;
    }

    @Override
    public final AssertionFailure unknownIterableBridgeForResolution(String resolution) {
        AssertionFailure result = new AssertionFailure(String.format("HSEARCH000143: " + this.unknownIterableBridgeForResolution$str(), resolution));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownIterableBridgeForResolution$str() {
        return unknownIterableBridgeForResolution;
    }

    @Override
    public final SearchException fileIsNotReadable(String fileName) {
        SearchException result = new SearchException(String.format("HSEARCH000154: " + this.fileIsNotReadable$str(), fileName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String fileIsNotReadable$str() {
        return fileIsNotReadable;
    }

    @Override
    public final IllegalArgumentException needAtLeastOneIndexName() {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HSEARCH000111: " + this.needAtLeastOneIndexName$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String needAtLeastOneIndexName$str() {
        return needAtLeastOneIndexName;
    }

    @Override
    public final SearchException cannotFindCoordinatesNorLatLongForSpatial(String spatialName, String className) {
        SearchException result = new SearchException(String.format("HSEARCH000159: " + this.cannotFindCoordinatesNorLatLongForSpatial$str(), spatialName, className));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotFindCoordinatesNorLatLongForSpatial$str() {
        return cannotFindCoordinatesNorLatLongForSpatial;
    }

    @Override
    public final void interruptedBatchIndexing() {
        this.log.logf(FQCN, Logger.Level.ERROR, null, "HSEARCH000062: " + this.interruptedBatchIndexing$str(), new Object[0]);
    }

    protected String interruptedBatchIndexing$str() {
        return interruptedBatchIndexing;
    }

    @Override
    public final SearchException unableToGuessFieldBridge(String className, String fieldName) {
        SearchException result = new SearchException(String.format("HSEARCH000135: " + this.unableToGuessFieldBridge$str(), className, fieldName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToGuessFieldBridge$str() {
        return unableToGuessFieldBridge;
    }

    @Override
    public final void idCannotBeExtracted(String affectedOwnerEntityName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000024: " + this.idCannotBeExtracted$str(), (Object)affectedOwnerEntityName);
    }

    protected String idCannotBeExtracted$str() {
        return idCannotBeExtracted;
    }

    @Override
    public final SearchException unableToOpenJMSConnection(String indexName, String jmsQueueName, Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000162: " + this.unableToOpenJMSConnection$str(), indexName, jmsQueueName), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToOpenJMSConnection$str() {
        return unableToOpenJMSConnection;
    }

    @Override
    public final SearchException unableToReadFile(String filename, Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000097: " + this.unableToReadFile$str(), filename), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToReadFile$str() {
        return unableToReadFile;
    }

    @Override
    public final void interruptedWorkError(Runnable r) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, "HSEARCH000017: " + this.interruptedWorkError$str(), (Object)r);
    }

    protected String interruptedWorkError$str() {
        return interruptedWorkError;
    }

    @Override
    public final void indexManagerAliasResolved(String alias, Class im) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, "HSEARCH000166: " + this.indexManagerAliasResolved$str(), (Object)alias, (Object)im);
    }

    protected String indexManagerAliasResolved$str() {
        return indexManagerAliasResolved;
    }

    @Override
    public final void massIndexerIndexWriterThreadsIgnored() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000124: " + this.massIndexerIndexWriterThreadsIgnored$str(), new Object[0]);
    }

    protected String massIndexerIndexWriterThreadsIgnored$str() {
        return massIndexerIndexWriterThreadsIgnored;
    }

    @Override
    public final void indexDirectoryNotFoundCreatingNewOne(String absolutePath) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HSEARCH000041: " + this.indexDirectoryNotFoundCreatingNewOne$str(), (Object)absolutePath);
    }

    protected String indexDirectoryNotFoundCreatingNewOne$str() {
        return indexDirectoryNotFoundCreatingNewOne;
    }

    @Override
    public final void interruptedWhileWaitingForIndexActivity(InterruptedException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, "HSEARCH000049: " + this.interruptedWhileWaitingForIndexActivity$str(), new Object[0]);
    }

    protected String interruptedWhileWaitingForIndexActivity$str() {
        return interruptedWhileWaitingForIndexActivity;
    }

    @Override
    public final SearchException cannotDeserializeField(String schema) {
        SearchException result = new SearchException(String.format("HSEARCH000101: " + this.cannotDeserializeField$str(), schema));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDeserializeField$str() {
        return cannotDeserializeField;
    }

    @Override
    public final void unableToCompareSourceWithDestinationDirectory(String source, String destination) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, "HSEARCH000023: " + this.unableToCompareSourceWithDestinationDirectory$str(), (Object)source, (Object)destination);
    }

    protected String unableToCompareSourceWithDestinationDirectory$str() {
        return unableToCompareSourceWithDestinationDirectory;
    }

    public final void stopServiceFailed(Class class1, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, "HSEARCH000026: " + this.stopServiceFailed$str(), (Object)class1);
    }

    protected String stopServiceFailed$str() {
        return stopServiceFailed;
    }

    @Override
    public final void indexingEntities(long count) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HSEARCH000027: " + this.indexingEntities$str(), (Object)count);
    }

    protected String indexingEntities$str() {
        return indexingEntities;
    }

    @Override
    public final void inconsistentFieldConfiguration(String fieldName) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000120: " + this.inconsistentFieldConfiguration$str(), (Object)fieldName);
    }

    protected String inconsistentFieldConfiguration$str() {
        return inconsistentFieldConfiguration;
    }

    @Override
    public final void jGroupsReceivedNewClusterView(Object view) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HSEARCH000015: " + this.jGroupsReceivedNewClusterView$str(), view);
    }

    protected String jGroupsReceivedNewClusterView$str() {
        return jGroupsReceivedNewClusterView;
    }

    @Override
    public final SearchException conversionFromReaderToStringNotYetImplemented() {
        SearchException result = new SearchException(String.format("HSEARCH000092: " + this.conversionFromReaderToStringNotYetImplemented$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String conversionFromReaderToStringNotYetImplemented$str() {
        return conversionFromReaderToStringNotYetImplemented;
    }

    public final void forceRemoveOnIndexOperationViaInterception(Class entityClass, WorkType type) {
        this.log.logf(FQCN, Logger.Level.TRACE, null, "HSEARCH000126: " + this.forceRemoveOnIndexOperationViaInterception$str(), (Object)entityClass, (Object)type);
    }

    protected String forceRemoveOnIndexOperationViaInterception$str() {
        return forceRemoveOnIndexOperationViaInterception;
    }

    @Override
    public final void errorExecutingRunnableInTransaction(Throwable e) {
        this.log.logf(FQCN, Logger.Level.ERROR, e, "HSEARCH000064: " + this.errorExecutingRunnableInTransaction$str(), new Object[0]);
    }

    protected String errorExecutingRunnableInTransaction$str() {
        return errorExecutingRunnableInTransaction;
    }

    @Override
    public final SearchException legacyJGroupsConfigurationDefined(String indexName) {
        SearchException result = new SearchException(String.format("HSEARCH000130: " + this.legacyJGroupsConfigurationDefined$str(), indexName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String legacyJGroupsConfigurationDefined$str() {
        return legacyJGroupsConfigurationDefined;
    }

    @Override
    public final void skippingDirectorySynchronization(String indexName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HSEARCH000018: " + this.skippingDirectorySynchronization$str(), (Object)indexName);
    }

    protected String skippingDirectorySynchronization$str() {
        return skippingDirectorySynchronization;
    }

    @Override
    public final SearchException unknownAttributeSerializedRepresentation(String name) {
        SearchException result = new SearchException(String.format("HSEARCH000086: " + this.unknownAttributeSerializedRepresentation$str(), name));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownAttributeSerializedRepresentation$str() {
        return unknownAttributeSerializedRepresentation;
    }

    @Override
    public final SearchException unsupportedTikaBridgeType() {
        SearchException result = new SearchException(String.format("HSEARCH000151: " + this.unsupportedTikaBridgeType$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unsupportedTikaBridgeType$str() {
        return "Unable to get input stream from blob data";
    }

    @Override
    public final void unableToShutdownAsynchronousIndexing(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, "HSEARCH000071: " + this.unableToShutdownAsynchronousIndexing$str(), new Object[0]);
    }

    protected String unableToShutdownAsynchronousIndexing$str() {
        return unableToShutdownAsynchronousIndexing;
    }

    @Override
    public final void workerException(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, "HSEARCH000059: " + this.workerException$str(), new Object[0]);
    }

    protected String workerException$str() {
        return workerException;
    }

    public final SearchException unknownFieldType(Class fieldType) {
        SearchException result = new SearchException(String.format("HSEARCH000093: " + this.unknownFieldType$str(), fieldType));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownFieldType$str() {
        return unknownFieldType;
    }

    @Override
    public final void closedBlackholeBackend() {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HSEARCH000002: " + this.closedBlackholeBackend$str(), new Object[0]);
    }

    protected String closedBlackholeBackend$str() {
        return closedBlackholeBackend;
    }

    @Override
    public final SearchException unableToGetInputStreamFromBlob(Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000150: " + this.unableToGetInputStreamFromBlob$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToGetInputStreamFromBlob$str() {
        return "Unable to get input stream from blob data";
    }

    @Override
    public final SearchException unableToInstantiateSpatial(String className, Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000136: " + this.unableToInstantiateSpatial$str(), className), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateSpatial$str() {
        return unableToInstantiateSpatial;
    }

    @Override
    public final void errorRollingBackTransaction(String message, Exception e1) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e1, "HSEARCH000065: " + this.errorRollingBackTransaction$str(), (Object)message);
    }

    protected String errorRollingBackTransaction$str() {
        return errorRollingBackTransaction;
    }

    @Override
    public final SearchException jGroupsChannelCreationUsingXmlError(String configuration, Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000009: " + this.jGroupsChannelCreationUsingXmlError$str(), configuration), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String jGroupsChannelCreationUsingXmlError$str() {
        return jGroupsChannelCreationUsingXmlError;
    }

    @Override
    public final SearchException unableToReadSerializedLuceneWorks(Throwable e) {
        SearchException result = new SearchException(String.format("HSEARCH000084: " + this.unableToReadSerializedLuceneWorks$str(), new Object[0]), e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToReadSerializedLuceneWorks$str() {
        return unableToReadSerializedLuceneWorks;
    }

    @Override
    public final void similarityInstantiationException(String similarityName, String beanXClassName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, "HSEARCH000004: " + this.similarityInstantiationException$str(), (Object)similarityName, (Object)beanXClassName);
    }

    protected String similarityInstantiationException$str() {
        return similarityInstantiationException;
    }

    @Override
    public final void readersNotProperlyClosedInReaderProvider() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000054: " + this.readersNotProperlyClosedInReaderProvider$str(), new Object[0]);
    }

    protected String readersNotProperlyClosedInReaderProvider$str() {
        return readersNotProperlyClosedInReaderProvider;
    }

    @Override
    public final void ignoringBackendOptionForIndex(String indexName, String forcedBackend) {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000104: " + this.ignoringBackendOptionForIndex$str(), (Object)indexName, (Object)forcedBackend);
    }

    protected String ignoringBackendOptionForIndex$str() {
        return ignoringBackendOptionForIndex;
    }

    @Override
    public final void forceToUseDocumentExtraction() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000038: " + this.forceToUseDocumentExtraction$str(), new Object[0]);
    }

    protected String forceToUseDocumentExtraction$str() {
        return forceToUseDocumentExtraction;
    }

    @Override
    public final void jGroupsDisconnectingAndClosingChannel(String clusterName) {
        this.log.logf(FQCN, Logger.Level.INFO, null, "HSEARCH000013: " + this.jGroupsDisconnectingAndClosingChannel$str(), (Object)clusterName);
    }

    protected String jGroupsDisconnectingAndClosingChannel$str() {
        return jGroupsDisconnectingAndClosingChannel;
    }

    @Override
    public final AssertionFailure unknownArrayBridgeForResolution(String resolution) {
        AssertionFailure result = new AssertionFailure(String.format("HSEARCH000141: " + this.unknownArrayBridgeForResolution$str(), resolution));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unknownArrayBridgeForResolution$str() {
        return unknownArrayBridgeForResolution;
    }

    @Override
    public final void unableToShutdownAsynchronousIndexingByTimeout(String indexName) {
        this.log.logf(FQCN, Logger.Level.ERROR, null, "HSEARCH000078: " + this.unableToShutdownAsynchronousIndexingByTimeout$str(), (Object)indexName);
    }

    protected String unableToShutdownAsynchronousIndexingByTimeout$str() {
        return unableToShutdownAsynchronousIndexingByTimeout;
    }

    public final void unableToRetrieveObjectFromMessage(Class messageClass, Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, "HSEARCH000068: " + this.unableToRetrieveObjectFromMessage$str(), (Object)messageClass);
    }

    protected String unableToRetrieveObjectFromMessage$str() {
        return unableToRetrieveObjectFromMessage;
    }

    @Override
    public final SearchException cannotDeserializeOperation(String schema) {
        SearchException result = new SearchException(String.format("HSEARCH000100: " + this.cannotDeserializeOperation$str(), schema));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotDeserializeOperation$str() {
        return cannotDeserializeOperation;
    }

    @Override
    public final void jGroupsClosingChannelError(Exception toLog) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)toLog, "HSEARCH000014: " + this.jGroupsClosingChannelError$str(), new Object[0]);
    }

    protected String jGroupsClosingChannelError$str() {
        return jGroupsClosingChannelError;
    }

    @Override
    public final void checkSizeMustBePositive() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000053: " + this.checkSizeMustBePositive$str(), new Object[0]);
    }

    protected String checkSizeMustBePositive$str() {
        return checkSizeMustBePositive;
    }

    @Override
    public final void abstractClassesCannotInsertDocuments() {
        this.log.logf(FQCN, Logger.Level.WARN, null, "HSEARCH000044: " + this.abstractClassesCannotInsertDocuments$str(), new Object[0]);
    }

    protected String abstractClassesCannotInsertDocuments$str() {
        return abstractClassesCannotInsertDocuments;
    }

    @Override
    public final IllegalArgumentException notAnIndexedType(String entityName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format("HSEARCH000109: " + this.notAnIndexedType$str(), entityName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notAnIndexedType$str() {
        return notAnIndexedType;
    }

    @Override
    public final void unableToCreateCurrentMarker(String indexName, Exception e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, "HSEARCH000020: " + this.unableToCreateCurrentMarker$str(), (Object)indexName);
    }

    protected String unableToCreateCurrentMarker$str() {
        return unableToCreateCurrentMarker;
    }
}

