/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.configuration;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.util.Arrays;
import junit.framework.Assert;
import org.apache.lucene.search.Query;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.test.util.ManualConfiguration;
import org.hibernate.search.test.util.ManualTransactionContext;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class ImplicitProvidedIdTest {
    @Rule
    public ExpectedException exceptions = ExpectedException.none();

    @Test
    public void exceptionThrownWhenNotEnabled() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().property("title", ElementType.FIELD).field().property("text", ElementType.FIELD).field();
        ManualConfiguration cfg = new ManualConfiguration().addProperty("hibernate.search.default.directory_provider", "ram").setProgrammaticMapping(mapping).addClass(Book.class);
        this.exceptions.expect(SearchException.class);
        this.exceptions.expectMessage("No document id in: " + Book.class.getName());
        this.storeBooksViaProvidedId(cfg, "providedId", false);
    }

    @Test
    public void usingConfigurationTypeOverride() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().property("title", ElementType.FIELD).field().property("text", ElementType.FIELD).field();
        ManualConfiguration cfg = new ManualConfiguration().addProperty("hibernate.search.default.directory_provider", "ram").setProgrammaticMapping(mapping).setIdProvidedImplicit(true).addClass(Book.class);
        this.storeBooksViaProvidedId(cfg, "providedId", false);
    }

    @Test
    public void usingProvidedIdAsOptionsOverride() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().providedId().name("myID").property("title", ElementType.FIELD).field().property("text", ElementType.FIELD).field();
        ManualConfiguration cfg = new ManualConfiguration().addProperty("hibernate.search.default.directory_provider", "ram").setProgrammaticMapping(mapping).setIdProvidedImplicit(true).addClass(Book.class);
        this.storeBooksViaProvidedId(cfg, "myID", false);
    }

    @Test
    public void usingExplicitProvidedId() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().providedId().name("myID").property("title", ElementType.FIELD).field().property("text", ElementType.FIELD).field();
        ManualConfiguration cfg = new ManualConfiguration().addProperty("hibernate.search.default.directory_provider", "ram").setProgrammaticMapping(mapping).setIdProvidedImplicit(false).addClass(Book.class);
        this.storeBooksViaProvidedId(cfg, "myID", false);
    }

    @Test
    public void usingDefaultSettings() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().providedId().name("myID").property("title", ElementType.FIELD).field().property("text", ElementType.FIELD).field();
        ManualConfiguration cfg = new ManualConfiguration().addProperty("hibernate.search.default.directory_provider", "ram").setProgrammaticMapping(mapping).addClass(Book.class);
        this.storeBooksViaProvidedId(cfg, "myID", false);
    }

    @Test
    public void documentIdNotOverriden() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(Book.class).indexed().property("title", ElementType.FIELD).documentId().property("text", ElementType.FIELD).field();
        ManualConfiguration cfg = new ManualConfiguration().addProperty("hibernate.search.default.directory_provider", "ram").setProgrammaticMapping(mapping).addClass(Book.class);
        this.storeBooksViaProvidedId(cfg, "title", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeBooksViaProvidedId(ManualConfiguration cfg, String fieldName, boolean matchTitle) {
        SearchFactoryImplementor sf = null;
        try {
            sf = new SearchFactoryBuilder().configuration((SearchConfiguration)cfg).buildSearchFactory();
            Book book = new Book();
            book.title = "Less is nice";
            book.text = "When using Infinispan Query, users have to always remember to add @ProvidedId on their classes or a nasty exception will remind them. Can't we just assume it's always annotated?";
            String isbn = "some entity-external id";
            Work work = new Work((Object)book, (Serializable)((Object)isbn), WorkType.ADD, false);
            ManualTransactionContext tc = new ManualTransactionContext();
            sf.getWorker().performWork(work, (TransactionContext)tc);
            tc.end();
            QueryBuilder queryBuilder = sf.buildQueryBuilder().forEntity(Book.class).get();
            Query query = ((TermMatchingContext)queryBuilder.keyword().onField(fieldName).ignoreAnalyzer()).matching((Object)(matchTitle ? book.title : isbn)).createQuery();
            int queryResultSize = sf.createHSQuery().luceneQuery(query).targetedEntities(Arrays.asList(Book.class)).queryResultSize();
            Assert.assertEquals((int)1, (int)queryResultSize);
        }
        finally {
            if (sf != null) {
                sf.close();
            }
        }
    }

    static class Book {
        String title;
        String text;

        Book() {
        }
    }
}

