/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.test.backends.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import junit.framework.Assert;
import org.hibernate.search.backend.impl.jgroups.AutoNodeSelector;
import org.hibernate.search.test.util.TestForIssue;
import org.jgroups.Address;
import org.jgroups.View;
import org.junit.Test;

@TestForIssue(jiraKey="HSEARCH-1261")
public class AutoNodeSelectorTest {
    private static final String NEGATIVE_HASH_CODE_INDEX_NAME = "test.Book";
    private static final String POSITIVE_HASH_CODE_INDEX_NAME = "test.Author";
    private static final String ZERO_HASH_CODE_INDEX_NAME = "";
    private final AtomicInteger NEXT_ADDRESS_ID = new AtomicInteger(0);
    private final AtomicLong NEXT_VIEW_ID = new AtomicLong(0L);

    @Test
    public void testIndexNameUsed() {
        Assert.assertTrue((NEGATIVE_HASH_CODE_INDEX_NAME.hashCode() < 0 ? 1 : 0) != 0);
        Assert.assertTrue((ZERO_HASH_CODE_INDEX_NAME.hashCode() == 0 ? 1 : 0) != 0);
        Assert.assertTrue((POSITIVE_HASH_CODE_INDEX_NAME.hashCode() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testNegativeHashCodeIndex() {
        this.performTest(NEGATIVE_HASH_CODE_INDEX_NAME);
    }

    @Test
    public void testPositiveHashCodeIndex() {
        this.performTest(POSITIVE_HASH_CODE_INDEX_NAME);
    }

    @Test
    public void testZeroHashCodeIndex() {
        this.performTest(ZERO_HASH_CODE_INDEX_NAME);
    }

    private void performTest(String index) {
        AutoNodeSelector selector = new AutoNodeSelector(index);
        for (int viewSize = 1; viewSize <= 50; ++viewSize) {
            View view = this.createView(viewSize);
            Assert.assertEquals((int)view.getMembers().size(), (int)viewSize);
            selector.viewAccepted(view);
        }
    }

    private View createView(int size) {
        LinkedList<TestAddress> addressList = new LinkedList<TestAddress>();
        while (size-- > 0) {
            addressList.add(new TestAddress(this.NEXT_ADDRESS_ID.incrementAndGet()));
        }
        return new View((Address)addressList.get(0), this.NEXT_VIEW_ID.incrementAndGet(), addressList);
    }

    private static final class TestAddress
    implements Address {
        private int addressId;

        public TestAddress(int addressId) {
            this.addressId = addressId;
        }

        public int size() {
            return 4;
        }

        public int compareTo(Address o) {
            if (o == null || !(o instanceof TestAddress)) {
                return -1;
            }
            return Integer.valueOf(this.addressId).compareTo(((TestAddress)o).addressId);
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.addressId);
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.addressId = in.readInt();
        }

        public void writeTo(DataOutput dataOutput) throws Exception {
            dataOutput.writeInt(this.addressId);
        }

        public void readFrom(DataInput dataInput) throws Exception {
            this.addressId = dataInput.readInt();
        }

        public String toString() {
            return "TestAddress{addressId=" + this.addressId + '}';
        }
    }
}

